/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.SelectAreaTracker;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.MDIManager;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.hardware.Unknown;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.pdraw.action.SelectionToolAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.ModemManager;
import DE.siemens.ad.pdraw.app.ZoomManager;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.simulation.InputSimulationBar;
import DE.siemens.ad.pdraw.simulation.OnlineTestControl;
import DE.siemens.ad.pdraw.simulation.OnlineTestInterpreter;
import DE.siemens.ad.pdraw.simulation.OnlineTestProtocolHandler;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import DE.siemens.ad.pdraw.standard.LogoAbstractTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;

public class OnlineTestTool
extends LogoAbstractTool {
    private List fCurrentParameterComponents;
    private JButton fWatchButton;
    private LogoComfort fEditor;
    protected WiringDiagram fWiringDiagram;
    private Tool fInteractor = null;
    private static OnlineTestTool instance;
    private PropertyChangeListener fZoomValueChangedListener;
    private SimulationManager fSimulationManager;
    private OnlineTestInterpreter fInterpreter;
    private InterpreterStateChangedListener fInterpreterStateChangedListener;
    private DataTransfer fDataTransfer;
    private JComponent fOnlineTestToolbar;
    private List fWatchedBlocks;
    private BlockFigure fLastBlockFigure;
    private DrawingView fView;
    private JTextArea fWatchedBlocksTextArea;
    private JTable fWatchedBlocksTable;

    private boolean addWatchedBlockFigure(BlockFigure blockFigure) {
        Block block = blockFigure.getBlock();
        if (this.fWatchedBlocks.contains(block)) {
            return false;
        }
        Hardware hardware = this.fWiringDiagram.getHardware();
        MemoryUsageTable actualMemoryUsageTable = (MemoryUsageTable)hardware.getProperty("blockActualParameterMemory");
        if (actualMemoryUsageTable == null) {
            return false;
        }
        Iterator i = this.fWatchedBlocks.iterator();
        int actualParameterMemory = 0;
        while (i.hasNext()) {
            Block watchedBlock = (Block)i.next();
            actualParameterMemory += actualMemoryUsageTable.getMemoryUsage(watchedBlock.getClass());
        }
        actualParameterMemory += actualMemoryUsageTable.getMemoryUsage(block.getClass());
        int maxWatchedBlocksCount = hardware.getIntProperty("maxWatchedBlocksCount");
        if (this.getWatchedBlocks().size() + 1 > maxWatchedBlocksCount) {
            JOptionPane.showMessageDialog(this.fEditor.getWindow(), Language.getString("onlineTestControl.maxWatchedBlocks", "A maximum number of % blocks can be watched.", maxWatchedBlocksCount), Language.getString("pdraw.app.createTools.onlineTest", "Online test"), 1);
            return false;
        }
        int maxWatchedBytesCount = hardware.getIntProperty("maxWatchedBytesCount");
        if (actualParameterMemory > maxWatchedBytesCount) {
            JOptionPane.showMessageDialog(this.fEditor.getWindow(), Language.getString("onlineTestControl.maxWatchedBytes", "A maximum number of % bytes can be transferred during online test.", maxWatchedBytesCount), Language.getString("pdraw.app.createTools.onlineTest", "Online test"), 1);
            return false;
        }
        CurrentParameterComponent currentParameterComponent = new CurrentParameterComponent(blockFigure);
        String currentParameterText = block.getParameter().getCurrentParameterText();
        ((LogoDrawingView)this.fView).add(currentParameterComponent);
        this.getWatchButton().setVisible(false);
        ((LogoDrawingView)this.fView).repaint();
        this.getCurrentParameterComponents().add(currentParameterComponent);
        this.addWatchedBlock(block);
        return true;
    }

    protected OnlineTestTool(LogoComfort editor) {
        LogoDrawing logoDrawing = (LogoDrawing)editor.drawing();
        this.fWiringDiagram = logoDrawing.getWiringDiagram();
        this.fEditor = editor;
        this.fInterpreter = this.GetNewInterPreter(this.fWiringDiagram);
        this.fInterpreterStateChangedListener = new InterpreterStateChangedListener();
        this.fInterpreter.getStateMachine().addStateChangedListener(this.fInterpreterStateChangedListener);
        this.fSimulationManager = new SimulationManager(this.fEditor, this.fInterpreter);
        this.fOnlineTestToolbar = new JToolBar();
        this.fOnlineTestToolbar.setLayout(new ToolBarLayout(0));
        ((JToolBar)this.fOnlineTestToolbar).setFloatable(false);
        InputSimulationBar inputSimulationBar = this.fSimulationManager.getInputBlockBar();
        inputSimulationBar.setOnlineTestMode(true);
        inputSimulationBar.setEnabled(false);
        this.fOnlineTestToolbar.add(inputSimulationBar);
        this.fOnlineTestToolbar.add(this.fSimulationManager.getOutputBlockBar());
        this.fOnlineTestToolbar.add(new OnlineTestControl(this.fSimulationManager).getToolbar());
        this.fZoomValueChangedListener = new ZoomChangedHandler();
        CSH.setHelpIDString((Component)this.fOnlineTestToolbar, (String)"toolbar.onlinetest");
    }

    protected OnlineTestInterpreter GetNewInterPreter(WiringDiagram wd) {
        return new OnlineTestInterpreter(wd);
    }

    public void activate(DrawingView view) {
        super.activate(view);
        view.clearSelection();
        this.fView = view;
        this.fDataTransfer = null;
        boolean errFlag = false;
        try {
            this.fDataTransfer = DataTransfer.openConnection(false);
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            errFlag = true;
        }
        if (errFlag || this.fDataTransfer.getHardware() instanceof Unknown) {
            JOptionPane.showMessageDialog(((View)((Object)view)).getViewComponent(), Language.getString("error.com.checkMode", "Connection to device cannot be established."), Language.getString("pdraw.app.createTools.onlineTest", "Online test"), 1);
            this.deactivate(view);
            return;
        }
        this.fInterpreter.setDataTransfer(this.fDataTransfer);
        JButton watchButton = this.getWatchButton();
        watchButton.setVisible(false);
        ((LogoDrawingView)view).add(watchButton);
        this.setComponentInApplication(view);
        this.fSimulationManager.setSimulationMode(true);
        this.fSimulationManager.setVisualisationEnabled(true);
        ((LogoDrawingView)view).getZoomManager().addPropertyChangeListener(this.fZoomValueChangedListener);
        ModemManager.activeConnectModemActionState(true);
    }

    public void deactivate(DrawingView view) {
        super.deactivate(view);
        this.fInterpreter.getStateMachine().addInput("terminate");
        while (this.fInterpreter.getStateMachine().isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.removeAllCurrentParameterComponents();
        if (this.fSimulationManager != null) {
            this.fSimulationManager.setSimulationMode(false);
        }
        if (this.fDataTransfer != null) {
            this.fDataTransfer.closePort();
            this.fDataTransfer = null;
        }
        this.fOnlineTestToolbar.setVisible(false);
        ((LogoDrawingView)view).remove(this.getWatchButton());
        ((LogoDrawingView)view).getZoomManager().removePropertyChangeListener(this.fZoomValueChangedListener);
        ModemManager.activeConnectModemActionState(false);
    }

    public void editorEnded(Editor editor) {
        super.editorEnded(editor);
        this.fInterpreter.getStateMachine().addInput("terminate");
        this.fSimulationManager.setSimulationMode(false);
        long startWaitingTime = System.currentTimeMillis();
        while (this.fInterpreter.getStateMachine().isRunning()) {
            if (System.currentTimeMillis() - startWaitingTime <= 1000L) continue;
            System.err.println("OnlineTestTool: editorEnded. StateMachine can not exit");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
    }

    protected void setComponentInApplication(DrawingView view) {
        ApplicationSurface applicationSurface = this.fEditor.getApplicationSurface();
        JComponent c = applicationSurface.getWindowManager().getToolbarPanel("OnlineTest", "South");
        c.add(this.fOnlineTestToolbar);
        applicationSurface.revalidate();
    }

    public void editorActivated(Editor editor) {
        super.editorActivated(editor);
        JComponent c = editor.getApplicationSurface().getWindowManager().getToolbarPanel("OnlineTest", "South");
        c.add(this.fOnlineTestToolbar);
        this.fOnlineTestToolbar.setVisible(true);
    }

    public void editorDeactivated(Editor editor) {
        super.editorDeactivated(editor);
        this.fOnlineTestToolbar.setVisible(false);
    }

    public void mouseMove(MouseEvent evt, int x, int y, DrawingView view) {
        super.mouseMove(evt, x, y, view);
        Figure figure = view.drawing().findFigure(x, y);
        if (figure instanceof BlockFigure) {
            this.setWatchUnwatchIcon((BlockFigure)figure);
        }
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseDown(e, x, y, view);
        Figure f = view.drawing().findFigure(x, y);
        if (f == null) {
            if (!e.isControlDown()) {
                view.clearSelection();
            }
            this.fInteractor = new SelectAreaTracker();
        } else {
            if (!e.isControlDown()) {
                view.clearSelection();
            }
            if (f instanceof BlockFigure) {
                view.toggleSelection(f);
            }
        }
        if (this.fInteractor != null) {
            this.fInteractor.mouseDown(e, x, y, view);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseDrag(e, x, y, view);
        if (this.fInteractor != null) {
            this.fInteractor.mouseDrag(e, x, y, view);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseUp(e, x, y, view);
        if (this.fInteractor != null) {
            this.fInteractor.mouseUp(e, x, y, view);
            this.fInteractor = null;
        }
    }

    private JButton getWatchButton() {
        if (this.fWatchButton == null) {
            this.fWatchButton = new JButton(Global.getIcon("Watch.gif"));
            this.fWatchButton.setToolTipText(Language.getString("onlineTestControl.watchButtonStart"));
            this.fWatchButton.setIconTextGap(0);
            this.fWatchButton.setMargin(new Insets(0, 0, 0, 0));
            this.fWatchButton.setFocusable(false);
            this.fWatchButton.setSize(this.fWatchButton.getMaximumSize());
            this.fWatchButton.addActionListener(new WatchButtonHandler());
        }
        return this.fWatchButton;
    }

    protected void setWatchUnwatchIcon(BlockFigure blockFigure) {
        ParameterItemList actualParameterList;
        Block block = blockFigure.getBlock();
        BlockParameter blockParameter = block.getParameter();
        if (this.getWatchedBlocks().contains(block)) {
            this.getWatchButton().setVisible(false);
        } else if (blockParameter != null && ((actualParameterList = blockParameter.getParameterItems().getParameterItemListOfType(1)).getPublicParameterItemList().size() > 0 || blockParameter instanceof TimeProtectionParameter || blockParameter instanceof Time2ProtectionParameter)) {
            JButton watchButton = this.getWatchButton();
            Point position = blockFigure.getCurrentParmeterTextPosition();
            ZoomManager zoomManager = ((LogoDrawingView)this.fView).getZoomManager();
            Point currentParameterPosition = blockFigure.getCurrentParmeterTextPosition();
            watchButton.setLocation(zoomManager.convertModelToDisplayCoordinates(currentParameterPosition));
            watchButton.setVisible(true);
            this.fLastBlockFigure = blockFigure;
        }
    }

    private void resetCurrentParameterComponents() {
        if (this.fCurrentParameterComponents != null) {
            for (CurrentParameterComponent currentParameterComponent : this.fCurrentParameterComponents) {
                currentParameterComponent.setText("");
            }
        }
    }

    private List getWatchedBlocks() {
        if (this.fWatchedBlocks == null) {
            this.fWatchedBlocks = new ArrayList(10);
        }
        return this.fWatchedBlocks;
    }

    public List getCurrentParameterComponents() {
        if (this.fCurrentParameterComponents == null) {
            this.fCurrentParameterComponents = new ArrayList();
        }
        return this.fCurrentParameterComponents;
    }

    protected void removeAllCurrentParameterComponents() {
        for (CurrentParameterComponent currentParameterComponent : this.getCurrentParameterComponents()) {
            currentParameterComponent.removeAsParameterUpdateListener();
            ((LogoDrawingView)this.fView).remove(currentParameterComponent);
            this.removeWatchedBlock(currentParameterComponent.getBlock());
        }
    }

    private void addWatchedBlock(Block block) {
        this.getWatchedBlocks().add(block);
        if (block instanceof PIDBlock) {
            ((PIDBlock)block).setOnlineTestObserved(true);
        }
        this.fInterpreter.setRequestedBlocks(this.getWatchedBlocks());
    }

    private void removeWatchedBlock(Block block) {
        this.getWatchedBlocks().remove(block);
        if (block instanceof PIDBlock) {
            ((PIDBlock)block).setOnlineTestObserved(false);
        }
        this.fInterpreter.setRequestedBlocks(this.getWatchedBlocks());
        if (block.getParameter() != null) {
            block.getParameter().setCurrentParameterText("");
        }
    }

    public static OnlineTestTool getInstance(LogoComfort editor) {
        if (instance == null) {
            instance = new OnlineTestTool(editor);
        } else {
            instance.initialize(editor);
        }
        return instance;
    }

    public static boolean stopExistedOnlineTest() {
        if (instance != null && OnlineTestTool.isOnlineTestingExisted()) {
            return instance.setCurrentEditorToSelectionTool();
        }
        return false;
    }

    private static boolean isOnlineTestingExisted() {
        MDIManager mdiManager = Application.getInstance().getMdiManager();
        Iterator i = mdiManager.getViews().iterator();
        View view = null;
        while (i.hasNext()) {
            view = (View)i.next();
            if (view == mdiManager.getActiveTopLevelView() || !(view.getEditor() instanceof LogoComfort) || !(((LogoComfort)view.getEditor()).tool() instanceof OnlineTestTool)) continue;
            return true;
        }
        return false;
    }

    public void initialize(LogoComfort editor) {
        if (this.fEditor == editor) {
            return;
        }
        this.setCurrentEditorToSelectionTool();
        this.fInterpreterStateChangedListener.setVisualisationEnabled(true);
        LogoDrawing logoDrawing = (LogoDrawing)editor.drawing();
        this.fWiringDiagram = logoDrawing.getWiringDiagram();
        this.fEditor = editor;
        this.fInterpreter.setWiringDiagram(this.fWiringDiagram);
        this.fSimulationManager.setEditor(this.fEditor);
    }

    private boolean setCurrentEditorToSelectionTool() {
        if (this.fEditor != null && this.fEditor.getView() != null && this.fEditor.tool() == this) {
            ActionFactory actionFactory = this.fEditor.getActionFactory();
            SelectionToolAction selectionToolAction = (SelectionToolAction)actionFactory.getAction("SelectionToolAction");
            this.fEditor.setTool(selectionToolAction.getSelectionTool(), Language.getString("pdraw.app.createTools.selection", "selection tool"), selectionToolAction);
            return true;
        }
        return false;
    }

    private class WatchButtonHandler
    implements ActionListener {
        private WatchButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (OnlineTestTool.this.fLastBlockFigure != null) {
                OnlineTestTool.this.addWatchedBlockFigure(OnlineTestTool.this.fLastBlockFigure);
            }
        }
    }

    private class CurrentParameterComponent
    extends JPanel
    implements ParameterUpdateListener,
    ActionListener {
        private JLabel[] fTextLines;
        private JButton fCloseButton;
        private BlockFigure fBlockFigure;
        private Runnable fParamUpdateThread;

        public CurrentParameterComponent(BlockFigure blockFigure) {
            this.fBlockFigure = blockFigure;
            this.setBackground(new Color(255, 242, 238));
            this.setLayout(new BorderLayout());
            this.fTextLines = new JLabel[4];
            Box textPanel = new Box(1);
            for (int i = 0; i < 4; ++i) {
                this.fTextLines[i] = new JLabel();
                this.fTextLines[i].setVisible(false);
                this.fTextLines[i].setOpaque(false);
                textPanel.add(this.fTextLines[i]);
            }
            textPanel.setAlignmentY(0.0f);
            this.add((Component)textPanel, "Center");
            this.fCloseButton = new JButton(UIManager.getIcon("InternalFrame.closeIcon"));
            this.fCloseButton.setPreferredSize(new Dimension(16, 15));
            this.fCloseButton.setToolTipText(Language.getString("onlineTestControl.watchButtonStop"));
            this.fCloseButton.setIconTextGap(0);
            this.fCloseButton.setMargin(new Insets(0, 0, 0, 0));
            this.fCloseButton.setFocusable(false);
            this.fCloseButton.setAlignmentY(0.0f);
            this.add((Component)this.fCloseButton, "East");
            this.fCloseButton.addActionListener(this);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.getBlock().getParameter().addParameterUpdateListener(this);
            this.setZoomDependedLocation();
            this.setSize(this.getPreferredSize());
        }

        public void setZoomDependedLocation() {
            ZoomManager zoomManager = ((LogoDrawingView)OnlineTestTool.this.fView).getZoomManager();
            Point currentParameterPosition = this.fBlockFigure.getCurrentParmeterTextPosition();
            this.setLocation(zoomManager.convertModelToDisplayCoordinates(currentParameterPosition));
        }

        public void actionPerformed(ActionEvent e) {
            this.getBlock().getParameter().removeParameterUpdateListener(this);
            ((LogoDrawingView)OnlineTestTool.this.fView).remove(this);
            OnlineTestTool.this.removeWatchedBlock(this.getBlock());
            ((LogoDrawingView)OnlineTestTool.this.fView).repaint();
        }

        public void addAsParameterUpdateListener() {
            BlockParameter blockParameter = this.getBlock().getParameter();
            if (blockParameter != null) {
                blockParameter.removeParameterUpdateListener(this);
            }
        }

        public void removeAsParameterUpdateListener() {
            BlockParameter blockParameter = this.getBlock().getParameter();
            if (blockParameter != null) {
                blockParameter.removeParameterUpdateListener(this);
            }
        }

        public void parameterUpdated(final ParameterUpdateEvent pue) {
            if (this.fParamUpdateThread == null) {
                this.fParamUpdateThread = new Runnable(){

                    public void run() {
                        CurrentParameterComponent.this.setText(pue.getParameter().getCurrentParameterText());
                        CurrentParameterComponent.this.setSize(CurrentParameterComponent.this.getPreferredSize());
                        CurrentParameterComponent.this.invalidate();
                        CurrentParameterComponent.this.revalidate();
                    }
                };
            }
            SwingUtilities.invokeLater(this.fParamUpdateThread);
        }

        public void setText(String text) {
            StringTokenizer newLineTokenizer = new StringTokenizer(text);
            for (int lineCount = 0; newLineTokenizer.hasMoreTokens() && lineCount < this.fTextLines.length; ++lineCount) {
                this.fTextLines[lineCount].setText(newLineTokenizer.nextToken());
                this.fTextLines[lineCount].setVisible(true);
            }
            for (int i = lineCount; i < this.fTextLines.length; ++i) {
                this.fTextLines[i].setVisible(false);
            }
        }

        public Block getBlock() {
            return this.fBlockFigure.getBlock();
        }
    }

    private class InterpreterStateChangedListener
    implements StateMachine.StateChangedListener {
        private boolean fVisualisationEnabled;

        private InterpreterStateChangedListener() {
        }

        public void setVisualisationEnabled(boolean newValue) {
            this.fVisualisationEnabled = newValue;
        }

        public void finalStateReached(StateMachine stateMachine, StateMachine.State finalState) {
            OnlineTestTool.this.fSimulationManager.setVisualisationEnabled(false);
            OnlineTestTool.this.fDataTransfer.closePort();
            if (finalState == finalState.getState(OnlineTestProtocolHandler.CommunicationError.class)) {
                JOptionPane.showMessageDialog((LogoDrawingView)OnlineTestTool.this.fView, "Fehler bei der Kommunkation mit dem Ger\u00e4t", "Online test", 0);
            }
        }

        public void stateChanged(StateMachine stateMachine, StateMachine.State newState) {
            boolean visualisationEnabled;
            boolean bl = visualisationEnabled = newState == newState.getState(OnlineTestProtocolHandler.ConnectedTesting.class) || newState == newState.getState(OnlineTestProtocolHandler.OnlineTestInterrupted.class) || newState == newState.getState(OnlineTestProtocolHandler.DeviceTimeout.class);
            if (visualisationEnabled != this.fVisualisationEnabled) {
                OnlineTestTool.this.fSimulationManager.setVisualisationEnabled(visualisationEnabled);
            }
            if (newState == stateMachine.getState(OnlineTestProtocolHandler.WrongProgram.class)) {
                JOptionPane.showMessageDialog(OnlineTestTool.this.fEditor.getView().getViewComponent(), Language.getString("onlineTestControl.wrongProgram", "The program in the software differs from the program on the device!"), Language.getString("pdraw.app.createTools.onlineTest", "Online test"), 1);
            }
            if (this.fVisualisationEnabled && !visualisationEnabled) {
                OnlineTestTool.this.fSimulationManager.resetInputs();
                OnlineTestTool.this.fSimulationManager.resetOutputs();
                OnlineTestTool.this.resetCurrentParameterComponents();
            }
            if (newState == stateMachine.getState(OnlineTestProtocolHandler.DeviceStopped.class)) {
                JOptionPane.showMessageDialog(OnlineTestTool.this.fEditor.getView().getViewComponent(), Language.getString("onlineTestControl.deviceStopped", "The device was stopped."), Language.getString("pdraw.app.createTools.onlineTest", "Online test"), 1);
            }
            if (newState == stateMachine.getState(OnlineTestProtocolHandler.WrongHardware.class)) {
                JOptionPane.showMessageDialog(OnlineTestTool.this.fEditor.getView().getViewComponent(), Language.getString("onlineTestControl.noConnection", "Onlinetest not supported by the connected device."), Language.getString("pdraw.app.createTools.onlineTest", "Online test"), 1);
            }
            this.fVisualisationEnabled = visualisationEnabled;
        }
    }

    private class WatchedBlocksTableModel
    extends AbstractTableModel {
        private final String[] fHeaderStrings = new String[]{"Nr", "Funktion", "Aktualwert"};

        private WatchedBlocksTableModel() {
        }

        public String getColumnName(int column) {
            return this.fHeaderStrings[column];
        }

        public int getRowCount() {
            return OnlineTestTool.this.getWatchedBlocks().size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            Block block = (Block)OnlineTestTool.this.getWatchedBlocks().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value = block.getNumberString();
                    break;
                }
                case 1: {
                    value = block;
                    break;
                }
                case 2: {
                    value = block.getParameter().getCurrentParameterText();
                    break;
                }
                default: {
                    value = "nichts";
                }
            }
            return value;
        }
    }

    private class ZoomChangedHandler
    implements PropertyChangeListener {
        private ZoomChangedHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "zoom") {
                int newZoomValue = (Integer)evt.getNewValue();
                if (OnlineTestTool.this.fCurrentParameterComponents != null) {
                    for (CurrentParameterComponent currentParameterComponent : OnlineTestTool.this.fCurrentParameterComponents) {
                        currentParameterComponent.setZoomDependedLocation();
                    }
                }
                if (OnlineTestTool.this.fWatchButton != null && OnlineTestTool.this.fWatchButton.isVisible() && OnlineTestTool.this.fLastBlockFigure != null) {
                    ZoomManager zoomManager = ((LogoDrawingView)OnlineTestTool.this.fView).getZoomManager();
                    Point currentParameterPosition = OnlineTestTool.this.fLastBlockFigure.getCurrentParmeterTextPosition();
                    OnlineTestTool.this.fWatchButton.setLocation(zoomManager.convertModelToDisplayCoordinates(currentParameterPosition));
                }
            }
        }
    }
}

