/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.app.comp.MinimizableToolbar;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.model.AnalogInputSimulationParameter;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.simulation.SimulationButton;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import DE.siemens.ad.pdraw.standard.SimulationSpinner;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Iterator;
import javax.help.CSH;
import javax.swing.JComponent;

public class InputSimulationBar
extends MinimizableToolbar {
    protected Hashtable fSimulationParameterListenerDictionary;
    private boolean fOnlineTestMode;

    public InputSimulationBar() {
        this.setFloatingFrameResizable(true);
        this.setFloatingFrameAutoResized(false);
        this.setTitle(Language.getString("toolbar.title.input", "Input Blocks"));
        this.setHorizontalLayout(new ToolBarLayout(3, 0, 2));
        this.setName("InputSimulationBar");
        CSH.setHelpIDString((Component)this, (String)"toolbar.simulation");
    }

    private JComponent createSimulationComponent(AnalogInputSimulationParameter simulationParameter, InputBlock block, SimulationManager s) {
        SimulationSpinner simSpinner;
        SimulationSpinner lens = simSpinner = new SimulationSpinner(block, simulationParameter, this.fOnlineTestMode);
        lens.setColumns(5);
        simulationParameter.addParameterSetListener(simSpinner);
        this.fSimulationParameterListenerDictionary.put(simulationParameter, simSpinner);
        return simSpinner;
    }

    private JComponent createSimulationComponent(InputSimulationParameter simulationParameter, InputBlock block, SimulationManager s) {
        if (simulationParameter.getSwitchMode() == 2) {
            SimulationSpinner simuSpinner = new SimulationSpinner((InputBlock)simulationParameter.getBlock(), simulationParameter);
            simulationParameter.addParameterSetListener(simuSpinner);
            this.fSimulationParameterListenerDictionary.put(simulationParameter, simuSpinner);
            return simuSpinner;
        }
        SimulationButton simuButton = new SimulationButton(block, s);
        simulationParameter.addParameterSetListener(simuButton);
        this.fSimulationParameterListenerDictionary.put(simulationParameter, simuButton);
        return simuButton;
    }

    public void deregisterParameterSetListeners() {
        if (this.fSimulationParameterListenerDictionary == null) {
            return;
        }
        Iterator i = this.fSimulationParameterListenerDictionary.keySet().iterator();
        SimulationParameter simulationParameter = null;
        ParameterSetListener parameterSetListener = null;
        while (i.hasNext()) {
            simulationParameter = (SimulationParameter)i.next();
            parameterSetListener = (ParameterSetListener)this.fSimulationParameterListenerDictionary.get(simulationParameter);
            simulationParameter.removeParameterSetListener(parameterSetListener);
        }
        this.fSimulationParameterListenerDictionary = null;
    }

    public void emptyToolBar(SimulationManager s) {
        this.removeAll();
        this.addSeparator();
    }

    public void init(InputBlock[] blocks, SimulationParameter[] simParams, SimulationManager s) {
        int i;
        if (this.fSimulationParameterListenerDictionary != null) {
            this.deregisterParameterSetListeners();
        }
        this.fSimulationParameterListenerDictionary = new Hashtable();
        this.removeAll();
        for (i = 0; i < blocks.length; ++i) {
            JComponent inputComponent = null;
            if (simParams[i] == null) continue;
            if (simParams[i] instanceof AnalogInputSimulationParameter) {
                inputComponent = this.createSimulationComponent((AnalogInputSimulationParameter)simParams[i], blocks[i], s);
            }
            if (simParams[i] instanceof InputSimulationParameter) {
                inputComponent = this.createSimulationComponent((InputSimulationParameter)simParams[i], blocks[i], s);
            }
            inputComponent.setEnabled(this.isEnabled());
            this.add(inputComponent);
        }
        for (i = 0; i < this.getComponentCount(); ++i) {
            ((JComponent)this.getComponent(i)).setAlignmentY(0.0f);
        }
    }

    public void setOnlineTestMode(boolean onlineTestMode) {
        this.fOnlineTestMode = onlineTestMode;
    }
}

