/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures.constraints;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class MultiHeadConstraint
extends FigureConstraint {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected HashSet childConstraints = new HashSet(10);
    protected Point lastMoveVector;

    public MultiHeadConstraint() {
    }

    public MultiHeadConstraint(Figure figure) {
        super(figure);
    }

    public void addChildConstraint(FigureConstraint child) {
        if (this.childConstraints.contains(child)) {
            return;
        }
        this.childConstraints.add(child);
        if (child.getContainer() != this) {
            child.setContainer(this);
        }
    }

    public void delete() {
        super.delete();
        this.deleteChildren();
    }

    public void deleteChildren() {
        Iterator i = this.childConstraints.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).delete();
        }
    }

    public void doDelete() {
        super.doDelete();
        this.deleteChildren();
    }

    public void doInsert(Drawing drawing) {
        super.doInsert(drawing);
        this.insertChildren(drawing);
    }

    public void doMove(Dimension moveVector) {
    }

    public void getFigures(Vector figures) {
        Iterator childs = this.childConstraints.iterator();
        FigureConstraint figureConstraint = null;
        while (childs.hasNext()) {
            figureConstraint = (FigureConstraint)childs.next();
            if (figureConstraint instanceof MultiHeadConstraint) {
                ((MultiHeadConstraint)figureConstraint).getFigures(figures);
                continue;
            }
            figures.add(figureConstraint.getFigure());
        }
        if (this.getFigure() != null) {
            figures.add(this.getFigure());
        }
    }

    protected void insertChildren(Drawing drawing) {
        Iterator i = this.childConstraints.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).insert(drawing);
        }
    }

    public void move(Dimension moveVector) {
        super.move(moveVector);
        this.moveChildren(moveVector);
    }

    protected void moveChildren(Dimension moveVector) {
        Iterator i = this.childConstraints.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).move(moveVector);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int childCount = storableInput.readInt();
        for (int i = 0; i < childCount; ++i) {
            this.childConstraints.add(storableInput.readStorable());
        }
    }

    private void restoreChildren() {
        Iterator i = this.childConstraints.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).undoDelete();
        }
    }

    public void undoDelete() {
        if (!this.deleted) {
            return;
        }
        super.undoDelete();
        this.restoreChildren();
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.childConstraints.size());
        Iterator i = this.childConstraints.iterator();
        while (i.hasNext()) {
            storableOutput.writeStorable((Storable)i.next());
        }
    }

    public Collection getChildConstraints() {
        return this.childConstraints;
    }
}

