/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures.constraints;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.pdraw.figures.constraints.MultiHeadConstraint;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class FigureConstraint
implements Serializable,
Storable {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected HashSet linkedObjects = new HashSet(10);
    protected Figure figure;
    protected boolean deleted = false;
    public MultiHeadConstraint container;
    protected boolean inDrawing = false;
    protected Dimension lastMoveVector;
    protected Drawing fDrawing;

    public FigureConstraint() {
    }

    public FigureConstraint(Figure figure) {
        this();
        this.figure = figure;
        if (figure.container() instanceof Drawing) {
            this.fDrawing = (Drawing)figure.container();
        }
    }

    public void addBidirectionalLink(FigureConstraint linkedObject) {
        this.addLink(linkedObject);
        linkedObject.addLink(this);
    }

    protected void addLink(FigureConstraint linkedObject) {
        this.linkedObjects.add(linkedObject);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        this.inDrawing = false;
        this.doDelete();
        this.informNeighboursFromDelete();
        if (this.container != null) {
            this.container.delete();
        }
    }

    public void doDelete() {
    }

    public void doInsert(Drawing drawing) {
        this.fDrawing = drawing;
    }

    public void doMove(Dimension moveVector) {
    }

    public MultiHeadConstraint getContainer() {
        return this.container;
    }

    protected Drawing getDrawing() {
        if (this.fDrawing == null && this.figure.container() instanceof Drawing) {
            this.fDrawing = (Drawing)this.figure.container();
        }
        return this.fDrawing;
    }

    public Figure getFigure() {
        return this.figure;
    }

    public FigureConstraint getTopLevelConstraint() {
        if (this.container != null) {
            return this.container.getTopLevelConstraint();
        }
        return this;
    }

    public boolean inDrawing() {
        return false;
    }

    protected void informNeighboursFromDelete() {
        Iterator i = new ArrayList(this.linkedObjects).iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).linkedObjectDeleted(this);
        }
    }

    protected void informNeighboursFromMove(Dimension moveVector) {
        Iterator i = this.linkedObjects.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).linkedObjectMoved(this, moveVector);
        }
    }

    protected void informNeighboursFromRestore() {
        HashSet clonedLinkedObjects = (HashSet)this.linkedObjects.clone();
        Iterator i = clonedLinkedObjects.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).linkedObjectRestored(this);
        }
    }

    public void insert(Drawing drawing) {
        if (this.inDrawing) {
            return;
        }
        this.doInsert(drawing);
        this.deleted = false;
        this.inDrawing = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    void linkedObjectDeleted(FigureConstraint neighbour) {
        this.removeLink(neighbour);
    }

    void linkedObjectMoved(FigureConstraint neighbour, Dimension moveVector) {
    }

    void linkedObjectRestored(FigureConstraint neighbour) {
        this.addLink(neighbour);
        if (this.deleted) {
            this.undoDelete();
        }
    }

    public void move(Dimension moveVector) {
        if (this.lastMoveVector == moveVector) {
            return;
        }
        this.lastMoveVector = moveVector;
        if (this.container != null) {
            this.container.move(moveVector);
        }
        this.doMove(moveVector);
        this.informNeighboursFromMove(moveVector);
    }

    public void read(StorableInput storableInput) throws IOException {
        this.container = (MultiHeadConstraint)storableInput.readStorable();
        this.deleted = storableInput.readBoolean();
        this.figure = (Figure)storableInput.readStorable();
        int size = storableInput.readInt();
        this.linkedObjects = new HashSet(5);
        for (int i = 0; i < size; ++i) {
            FigureConstraint c = (FigureConstraint)storableInput.readStorable();
            if (!this.deleted) {
                this.addBidirectionalLink(c);
                continue;
            }
            this.addLink(c);
        }
    }

    public void removeBirectionalLink(FigureConstraint linkedObject) {
        this.linkedObjects.remove(linkedObject);
        linkedObject.removeLink(this);
    }

    void removeLink(FigureConstraint linkedObject) {
        this.linkedObjects.remove(linkedObject);
    }

    public void setContainer(MultiHeadConstraint newContainer) {
        this.container = newContainer;
        newContainer.addChildConstraint(this);
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setDrawing(Drawing drawing) {
        this.fDrawing = drawing;
    }

    public void setFigure(Figure figure) {
        this.figure = figure;
    }

    public void undoDelete() {
        this.deleted = false;
        if (this.container != null) {
            this.container.undoDelete();
        }
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeStorable(this.container);
        storableOutput.writeBoolean(this.deleted);
        storableOutput.writeStorable(this.figure);
        storableOutput.writeInt(this.linkedObjects.size());
        Iterator i = this.linkedObjects.iterator();
        while (i.hasNext()) {
            storableOutput.writeStorable((Storable)i.next());
        }
    }
}

