/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures.constraints;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.InputLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.MultiHeadConstraint;
import DE.siemens.ad.pdraw.figures.constraints.OutputLineConstraint;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Iterator;

public class CuttedConnectionConstraint
extends MultiHeadConstraint
implements ConnectionConstraint {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected InBlockConnector inBlockConnector;
    protected OutBlockConnector outBlockConnector;
    protected ConnectionLineConstraint directConnection;

    public void connectInModel() {
        if (this.inBlockConnector != null && this.outBlockConnector != null) {
            this.inBlockConnector.connect(this.outBlockConnector);
        }
    }

    public void connectWithInput(InBlockConnector ibc) {
        if (ibc != this.inBlockConnector) {
            this.createDirectConnection();
        }
        this.inBlockConnector = ibc;
    }

    public void connectWithOutput(OutBlockConnector obc) {
        if (obc != this.outBlockConnector) {
            this.createDirectConnection();
        }
        this.outBlockConnector = obc;
    }

    private void createDirectConnection() {
        if (this.inBlockConnector == null || this.outBlockConnector == null) {
            return;
        }
        FixedElbowConnection fec = null;
        fec = this.directConnection != null ? (FixedElbowConnection)this.directConnection.getFigure() : new FixedElbowConnection();
        Iterator i = this.childConstraints.iterator();
        FigureConstraint inputLineConstraint = null;
        FigureConstraint outputLineConstraint = null;
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = (FigureConstraint)i.next();
            if (constraint instanceof InputLineConstraint) {
                inputLineConstraint = (InputLineConstraint)constraint;
            }
            if (!(constraint instanceof OutputLineConstraint)) continue;
            outputLineConstraint = (OutputLineConstraint)constraint;
        }
        Connector end = ((ConnectionFigure)inputLineConstraint.getFigure()).end();
        Connector start = ((ConnectionFigure)outputLineConstraint.getFigure()).start();
        fec.startPoint(0, 0);
        fec.endPoint(0, 0);
        fec.connectEnd(end);
        fec.connectStart(start);
        fec.getConstraint().delete();
        this.directConnection = (ConnectionLineConstraint)fec.getConstraint();
    }

    public void disconnectInModel() {
        if (this.inBlockConnector != null) {
            this.inBlockConnector.disconnect(this.outBlockConnector);
        }
    }

    public void doDelete() {
        super.delete();
        if (this.inBlockConnector != null && this.outBlockConnector != null) {
            this.inBlockConnector.disconnect(this.outBlockConnector);
        }
    }

    public void doInsert(Drawing drawing) {
        super.doInsert(drawing);
        if (this.inBlockConnector != null && this.outBlockConnector != null) {
            this.inBlockConnector.connect(this.outBlockConnector);
        }
    }

    public ConnectionLineConstraint getDirectConnection() {
        if (this.directConnection == null) {
            this.createDirectConnection();
        }
        return this.directConnection;
    }

    public InBlockConnector getInBlockConnector() {
        return this.inBlockConnector;
    }

    public OutBlockConnector getOutBlockConnector() {
        return this.outBlockConnector;
    }

    public void insertChildren(Drawing drawing) {
        for (FigureConstraint figureConstraint : this.childConstraints) {
            if (figureConstraint instanceof ConnectionLineConstraint) continue;
            figureConstraint.insert(drawing);
        }
        for (FigureConstraint figureConstraint : this.childConstraints) {
            if (!(figureConstraint instanceof ConnectionLineConstraint)) continue;
            figureConstraint.insert(drawing);
        }
    }

    public void move(Dimension moveVector) {
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.inBlockConnector = (InBlockConnector)storableInput.readStorable();
        this.outBlockConnector = (OutBlockConnector)storableInput.readStorable();
        this.directConnection = (ConnectionLineConstraint)storableInput.readStorable();
    }

    public void setDirectConnection(ConnectionLineConstraint newDirectConnection) {
        this.directConnection = newDirectConnection;
    }

    public void undoDelete() {
        super.undoDelete();
        if (this.inBlockConnector != null && this.outBlockConnector != null) {
            this.inBlockConnector.connect(this.outBlockConnector);
        }
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.inBlockConnector);
        storableOutput.writeStorable(this.outBlockConnector);
        storableOutput.writeStorable(this.directConnection);
    }
}

