/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures.constraints;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.pdraw.figures.BlockConnectorOwner;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.InConnectorConstraint;
import DE.siemens.ad.pdraw.figures.constraints.LeftPowerRailConstraint;
import DE.siemens.ad.pdraw.figures.constraints.OutConnectorConstraint;
import java.awt.Dimension;

public class ConnectionLineConstraint
extends FigureConstraint
implements ConnectionConstraint {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected InBlockConnector inBlockConnector;
    public OutBlockConnector outBlockConnector;

    public ConnectionLineConstraint() {
    }

    public ConnectionLineConstraint(Figure figure) {
        super(figure);
    }

    protected void addLink(FigureConstraint linkedObject) {
        Figure figure;
        super.addLink(linkedObject);
        if (linkedObject instanceof InConnectorConstraint) {
            this.inBlockConnector = (InBlockConnector)((InputIfcFigure)linkedObject.getFigure()).getBlockConnector();
        }
        if (linkedObject instanceof OutConnectorConstraint) {
            this.outBlockConnector = (OutBlockConnector)((OutputIfcFigure)linkedObject.getFigure()).getBlockConnector();
        }
        if (linkedObject instanceof LeftPowerRailConstraint && (figure = linkedObject.getFigure()) != null) {
            this.outBlockConnector = (OutBlockConnector)((BlockConnectorOwner)((Object)figure)).getBlockConnector();
        }
    }

    public void connectInModel() {
        if (this.inBlockConnector != null && this.outBlockConnector != null) {
            this.inBlockConnector.connect(this.outBlockConnector);
        }
    }

    public void disconnectInModel() {
        if (this.inBlockConnector != null) {
            this.inBlockConnector.disconnect(this.outBlockConnector);
        }
    }

    public void doDelete() {
        super.doDelete();
        if (this.getDrawing() != null) {
            this.getDrawing().remove(this.figure);
        }
        this.disconnectInModel();
    }

    public void doInsert(Drawing drawing) {
        super.doInsert(drawing);
        this.linkConstraints();
        this.connectInModel();
        drawing.add(this.figure);
        ((ConnectionFigure)this.figure).updateConnection();
    }

    public void doMove(Dimension moveVector) {
        this.figure.moveBy(moveVector.width, moveVector.height);
    }

    public InBlockConnector getInBlockConnector() {
        return this.inBlockConnector;
    }

    public OutBlockConnector getOutBlockConnector() {
        return this.outBlockConnector;
    }

    public void linkConstraints() {
        this.addBidirectionalLink(((FixedElbowConnection)this.figure).endFigure().getConstraint());
        this.addBidirectionalLink(((FixedElbowConnection)this.figure).startFigure().getConstraint());
    }

    public void linkedObjectDeleted(FigureConstraint neighbour) {
        super.linkedObjectDeleted(neighbour);
        this.delete();
    }

    public void linkedObjectMoved(FigureConstraint figureConstraint, Dimension moveVector) {
        ((FixedElbowConnection)this.figure).setNeedsUpdate(true);
    }

    public void undoDelete() {
        if (!this.deleted) {
            return;
        }
        this.insert(this.getDrawing());
        super.undoDelete();
        this.informNeighboursFromRestore();
    }
}

