/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures.constraints;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.figures.constraints.CommentConstraint;
import DE.siemens.ad.pdraw.figures.constraints.MultiHeadConstraint;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class BlockConstraint
extends MultiHeadConstraint {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;

    public BlockConstraint() {
    }

    public BlockConstraint(Figure figure) {
        super(figure);
    }

    public void doDelete() {
        super.doDelete();
        if (this.getDrawing() != null) {
            this.getDrawing().remove(this.figure);
            Block block = ((BlockFigure)this.getFigure()).getBlock();
            ((LogoDrawing)this.getDrawing()).getWiringDiagram().deleteBlock(block);
            CommentManager commentManager = ((LogoDrawing)this.getDrawing()).getCommentManager();
            if (block instanceof ContactBlock || block instanceof CoilBlock) {
                CommentParameter param = commentManager.getCommentParameter(block);
                param.removeParameterSetListener((BlockFigure)this.getFigure());
                param.removeParameterSetListener(((BlockFigure)this.getFigure()).getCommentFigure());
            } else {
                commentManager.removeCommentListeners(((BlockFigure)this.getFigure()).getBlock().getNumberString());
            }
        }
    }

    public void doInsert(Drawing drawing) {
        CommentTextFigure commentFigur;
        super.doInsert(drawing);
        drawing.add(this.figure);
        BlockFigure blockFigure = (BlockFigure)this.getFigure();
        Block block = blockFigure.getBlock();
        if (((LogoDrawing)drawing).getWiringDiagram().insert(block) != null && block.getParameter() != null) {
            blockFigure.parameterSet(block.getParameter(), block.getParameter().getParameterText());
        }
        if ((commentFigur = blockFigure.getCommentFigure()) != null && commentFigur.getConstraint() != null) {
            ((CommentConstraint)commentFigur.getConstraint()).updateStatus();
        }
    }

    public void doMove(Dimension moveVector) {
        this.figure.moveBy(moveVector.width, moveVector.height);
    }

    public void getFigures(Vector figures) {
        figures.add(this.getFigure());
    }

    public void undoDelete() {
        if (!this.deleted) {
            return;
        }
        super.undoDelete();
        this.insert(this.getDrawing());
        ((BlockFigure)this.figure).getCommentParameter().addParameterSetListener((BlockFigure)this.figure);
        this.informNeighboursFromRestore();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        System.out.println(this);
        oos.defaultWriteObject();
    }
}

