/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureDrawInfo;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.OutputCutConnectFigure;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class SelectionFigure
extends AbstractFigure
implements Observer {
    int fColorIndex = 0;
    private PolyLineFigure fLine;
    private BlockConnector fDescriptionKey;
    private static Color[] cColors;
    private Rectangle fDisplayBox;
    private int fTextWidth;
    private static HashMap cDescriptionTable;
    private InBlockConnector fInBlockConnector;

    public SelectionFigure(PolyLineFigure figure, int colorIndex) {
        this.fLine = figure;
        this.fColorIndex = colorIndex;
        figure.addObserver(this);
        if (LogoProperties.instance().getBooleanProperty("marker.showLabel", true)) {
            this.fDescriptionKey = this.getDescriptionKey();
        }
    }

    public void draw(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getColor(this.fColorIndex));
        PolyLineFigure figure = this.fLine;
        Enumeration points = figure.points();
        if (points.hasMoreElements()) {
            Point start = (Point)points.nextElement();
            while (points.hasMoreElements()) {
                Point end = (Point)points.nextElement();
                g.drawLine(start.x, start.y, end.x, end.y);
                start = end;
            }
        }
        this.drawDescription(figure, g);
        g.setColor(oldColor);
    }

    private void drawDescription(PolyLineFigure figure, Graphics g) {
        if (this.fDescriptionKey != null) {
            g.setColor(this.getColor(this.fColorIndex));
            Point start = figure.pointAt(0);
            Point end = figure.pointAt(figure.pointCount() - 1);
            char[] description = this.getDescriptionText();
            this.fTextWidth = g.getFontMetrics().charsWidth(description, 0, description.length);
            if (Math.abs(start.x - end.x) > 3 * this.fTextWidth || Math.abs(start.y - end.y) > 100) {
                g.drawChars(description, 0, description.length, start.x, start.y);
                g.drawChars(description, 0, description.length, end.x - this.fTextWidth, end.y);
            }
        }
    }

    private BlockConnector getDescriptionKey() {
        if (!(this.getSourceFigure() instanceof FixedElbowConnection)) {
            return null;
        }
        StringBuffer description = new StringBuffer();
        OutBlockConnector result = null;
        OutBlockConnector outBlockConnector = null;
        Figure lineEndFigure = ((FixedElbowConnection)this.fLine).start().owner();
        if (lineEndFigure instanceof BlockIfcFigure) {
            outBlockConnector = (OutBlockConnector)((BlockIfcFigure)lineEndFigure).fBlockConnector;
        } else {
            try {
                OutputCutConnectFigure cutConnectFigure = (OutputCutConnectFigure)lineEndFigure;
                Figure blockIfcFigure = cutConnectFigure.getPartner().getConnectionFigure().start().owner();
                outBlockConnector = (OutBlockConnector)((BlockIfcFigure)blockIfcFigure).fBlockConnector;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (outBlockConnector != null) {
            result = outBlockConnector;
            description = (StringBuffer)cDescriptionTable.get(outBlockConnector);
            if (description == null) {
                description = new StringBuffer(outBlockConnector.getLocalizedNameOptimized());
            }
        }
        if ((lineEndFigure = ((FixedElbowConnection)this.fLine).end().owner()) instanceof BlockIfcFigure) {
            this.fInBlockConnector = (InBlockConnector)((BlockIfcFigure)lineEndFigure).fBlockConnector;
            if (this.fInBlockConnector != null) {
                OutBlockConnector key = (OutBlockConnector)cDescriptionTable.get(this.fInBlockConnector);
                if (key == null) {
                    description.append(">");
                    description.append(this.fInBlockConnector.getLocalizedNameOptimized());
                } else {
                    result = key;
                    StringBuffer inBlockDescription = (StringBuffer)cDescriptionTable.get(key);
                    description.append(",").append(inBlockDescription);
                }
                cDescriptionTable.put(this.fInBlockConnector, result);
            }
        }
        cDescriptionTable.put(result, description);
        return result;
    }

    private char[] getDescriptionText() {
        StringBuffer description = (StringBuffer)cDescriptionTable.get(this.fDescriptionKey);
        char[] text = new char[description.length()];
        description.getChars(0, description.length(), text, 0);
        return text;
    }

    private Color getColor(int index) {
        return cColors[index];
    }

    public void draw(Graphics g, FigureDrawInfo gdi) {
        this.draw(g);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin, new Dimension(corner.x - origin.x, corner.y - origin.y));
    }

    protected void basicMoveBy(int dx, int dy) {
    }

    public Vector handles() {
        return null;
    }

    public Figure getSourceFigure() {
        return this.fLine;
    }

    public static void initColors() {
        Color[] colors = new Color[]{Util.getColor("marker.line.color.0", new Color(0, 255, 255, 255)), Util.getColor("marker.line.color.1", new Color(0, 255, 255, 255)), Util.getColor("marker.line.color.2", new Color(0, 255, 255, 255)), Util.getColor("marker.line.color.3", new Color(0, 255, 255, 255)), Util.getColor("marker.line.color.4", new Color(0, 255, 255, 255))};
        cColors = colors;
    }

    public void update(Observable o, Object arg) {
        this.willChange();
        this.basicDisplayBox(this.calculateDisplayBox());
        this.changed();
    }

    private Rectangle calculateDisplayBox() {
        Rectangle displayBox = this.fLine.displayBox();
        if (this.fTextWidth != 0) {
            displayBox.width = displayBox.width < this.fTextWidth ? this.fTextWidth : (displayBox.width += this.fTextWidth);
        }
        return displayBox;
    }

    public Rectangle displayBox() {
        if (this.fDisplayBox == null) {
            Rectangle displayBox = this.fLine.displayBox();
            displayBox.grow(100, 100);
            this.basicDisplayBox(displayBox);
        }
        return this.fDisplayBox;
    }

    public void release() {
        this.getSourceFigure().deleteObserver(this);
        if (this.fDescriptionKey != null) {
            cDescriptionTable.remove(this.fDescriptionKey);
        }
        if (this.fInBlockConnector != null) {
            cDescriptionTable.remove(this.fInBlockConnector);
        }
    }

    static {
        SelectionFigure.initColors();
        cDescriptionTable = new HashMap();
    }
}

