/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.IntSequence;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockConnectorOwner;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.ElbowTextLocator;
import DE.siemens.ad.pdraw.figures.InputCutConnectFigure;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputCutConnectFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.CuttedConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.InputLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.OutputLineConstraint;
import DE.siemens.ad.pdraw.standard.AbsoluteConnector;
import DE.siemens.ad.pdraw.standard.AdvancedConnectionSplitter;
import DE.siemens.ad.pdraw.standard.CCRightConnector;
import DE.siemens.ad.pdraw.standard.ChangeInputIfcHandle;
import DE.siemens.ad.pdraw.standard.ChangeOutputIfcHandle;
import DE.siemens.ad.pdraw.standard.ConnectionSplitter;
import DE.siemens.ad.pdraw.standard.LogoConnectionGridConstrainer;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.pdraw.util.ZoomableFigure;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class FixedElbowConnection
extends LineConnection
implements ZoomableFigure,
BlockConnectorOwner {
    private static final long serialVersionUID = -3298865392783297204L;
    private int fixedElbowConnectionSerializedDataVersion = 4;
    private boolean fUpdatePoints = true;
    protected int fCurrentZoom = 100;
    protected static ConnectionSplitter cConnectionSplitter;
    public static final int SECOND_SECTION = 1;
    public static final int THIRD_SECTION = 2;
    public static final int FORTH_SECTION = 3;
    protected static final boolean HORIZONTAL = true;
    protected static final boolean VERTICAL = false;
    protected boolean needsUpdate = false;
    protected transient AbsoluteConnector fAbsoluteConnector;

    public FixedElbowConnection() {
        this.setAttribute("ArrowMode", new Integer(0));
    }

    public void check4Points(Drawing drawing, Point[] points) {
        int pointCount = points.length;
        int leftX = 0;
        int rightX = 0;
        if (pointCount != 4) {
            return;
        }
        if (drawing != null) {
            FixedElbowConnection feC;
            Figure figure;
            int loop;
            leftX = points[0].x;
            rightX = points[3].x;
            Vector intersectionFigures1 = drawing.findMultiFigureWithout(points[0].x + 6, points[0].y, points[3].x - 6, points[0].y, this);
            Vector intersectionFigures2 = drawing.findMultiFigureWithout(points[0].x + 6, points[3].y, points[3].x - 6, points[3].y, this);
            int count = intersectionFigures1.size();
            Rectangle displayBox = new Rectangle(points[3].x, points[0].y, 1, 1);
            for (loop = 0; loop < count; ++loop) {
                figure = (Figure)intersectionFigures1.elementAt(loop);
                if (figure instanceof BlockFigure) {
                    displayBox = ((BlockFigure)figure).getImageFigure().displayBox();
                    if (displayBox.x >= rightX) continue;
                    rightX = displayBox.x;
                    continue;
                }
                if (!(figure instanceof FixedElbowConnection)) continue;
                feC = (FixedElbowConnection)figure;
                if (feC.pointCount() == 4) {
                    if (points[0].y != feC.pointAt((int)2).y || feC.pointAt((int)2).x >= rightX) continue;
                    rightX = feC.pointAt((int)2).x;
                    continue;
                }
                if (points[0].y == feC.pointAt((int)3).y && points[0].x < feC.pointAt((int)3).x) {
                    if (feC.pointAt((int)3).x >= rightX) continue;
                    rightX = feC.pointAt((int)3).x;
                    continue;
                }
                if (points[0].y != feC.pointAt((int)4).y || points[0].x >= feC.pointAt((int)4).x || feC.pointAt((int)4).x >= rightX) continue;
                rightX = feC.pointAt((int)4).x;
            }
            count = intersectionFigures2.size();
            displayBox = new Rectangle(points[0].x, points[3].y, 1, 1);
            for (loop = 0; loop < count; ++loop) {
                figure = (Figure)intersectionFigures2.elementAt(loop);
                if (figure instanceof BlockFigure) {
                    displayBox = ((BlockFigure)figure).getImageFigure().displayBox();
                    if (displayBox.x + displayBox.width <= leftX) continue;
                    leftX = displayBox.x + displayBox.width;
                    continue;
                }
                if (!(figure instanceof FixedElbowConnection)) continue;
                feC = (FixedElbowConnection)figure;
                if (feC.pointCount() == 4) {
                    if (points[2].y != feC.pointAt((int)1).y || feC.pointAt((int)1).x <= leftX) continue;
                    leftX = feC.pointAt((int)1).x;
                    continue;
                }
                if (points[2].y == feC.pointAt((int)1).y && points[3].x > feC.pointAt((int)1).x) {
                    if (feC.pointAt((int)1).x <= leftX) continue;
                    leftX = feC.pointAt((int)1).x;
                    continue;
                }
                if (points[2].y != feC.pointAt((int)2).y || points[3].x <= feC.pointAt((int)2).x || feC.pointAt((int)2).x <= leftX) continue;
                leftX = feC.pointAt((int)2).x;
            }
            if (leftX <= rightX) {
                IntSequence sequence = new IntSequence(points[1].x, leftX, rightX, 5);
                while (sequence.hasMoreInts()) {
                    int value = sequence.nextInt();
                    Vector tempIntersectionFigures = drawing.findMultiFigureWithout(value, points[1].y, value, points[2].y, this);
                    if (tempIntersectionFigures.size() == 0) {
                        this.movePoints(1, value - points[1].x);
                        break;
                    }
                    boolean move = true;
                    for (int j = 0; j < tempIntersectionFigures.size(); ++j) {
                        if (tempIntersectionFigures.elementAt(j) instanceof FixedElbowConnection && (this.start().owner().equals(((FixedElbowConnection)tempIntersectionFigures.elementAt(j)).start().owner()) || this.end().owner().equals(((FixedElbowConnection)tempIntersectionFigures.elementAt(j)).end().owner()))) continue;
                        move = false;
                    }
                    if (!move) continue;
                    this.movePoints(1, value - points[1].x);
                    break;
                }
            }
        }
    }

    public void check6Points(Drawing drawing, Point[] points) {
        int pointCount = points.length;
        int leftX = 0;
        int rightX = 0;
        if (pointCount != 6) {
            return;
        }
        if (drawing != null) {
            FixedElbowConnection feC;
            Figure figure;
            int loop;
            leftX = 0;
            rightX = 1000;
            Vector intersectionFigures1 = drawing.findMultiFigureWithout(points[0].x + 6, points[0].y, 5000, points[0].y, this);
            Vector intersectionFigures2 = drawing.findMultiFigureWithout(0, points[5].y, points[5].x - 6, points[5].y, this);
            int count = intersectionFigures1.size();
            Rectangle displayBox = new Rectangle(points[0].x, points[0].y, 1, 1);
            for (loop = 0; loop < count; ++loop) {
                figure = (Figure)intersectionFigures1.elementAt(loop);
                if (figure instanceof BlockFigure) {
                    displayBox = ((BlockFigure)figure).getImageFigure().displayBox();
                    if (displayBox.x >= rightX) continue;
                    rightX = displayBox.x;
                    continue;
                }
                if (!(figure instanceof FixedElbowConnection)) continue;
                feC = (FixedElbowConnection)figure;
                if (feC.pointCount() == 4) {
                    if (points[0].y != feC.pointAt((int)2).y || feC.pointAt((int)2).x >= rightX) continue;
                    rightX = feC.pointAt((int)2).x;
                    continue;
                }
                if (points[0].y == feC.pointAt((int)3).y && points[0].x < feC.pointAt((int)3).x) {
                    if (feC.pointAt((int)3).x >= rightX) continue;
                    rightX = feC.pointAt((int)3).x;
                    continue;
                }
                if (points[0].y != feC.pointAt((int)4).y || points[0].x >= feC.pointAt((int)4).x || feC.pointAt((int)4).x >= rightX) continue;
                rightX = feC.pointAt((int)4).x;
            }
            count = intersectionFigures2.size();
            displayBox = new Rectangle(points[4].x, points[3].y, 1, 1);
            for (loop = 0; loop < count; ++loop) {
                figure = (Figure)intersectionFigures2.elementAt(loop);
                if (figure instanceof BlockFigure) {
                    displayBox = ((BlockFigure)figure).getImageFigure().displayBox();
                    if (displayBox.x + displayBox.width <= leftX) continue;
                    leftX = displayBox.x + displayBox.width;
                    continue;
                }
                if (!(figure instanceof FixedElbowConnection)) continue;
                feC = (FixedElbowConnection)figure;
                if (feC.pointCount() == 4) {
                    if (points[4].y != feC.pointAt((int)1).y || feC.pointAt((int)1).x <= leftX) continue;
                    leftX = feC.pointAt((int)1).x;
                    continue;
                }
                if (points[4].y == feC.pointAt((int)1).y && points[3].x > feC.pointAt((int)1).x) {
                    if (feC.pointAt((int)1).x <= leftX) continue;
                    leftX = feC.pointAt((int)1).x;
                    continue;
                }
                if (points[4].y != feC.pointAt((int)2).y || points[5].x <= feC.pointAt((int)2).x || feC.pointAt((int)2).x <= leftX) continue;
                leftX = feC.pointAt((int)2).x;
            }
            boolean rightOk = false;
            boolean leftOk = false;
            int value2 = 0;
            int value3 = 0;
            IntSequence sequence = new IntSequence(points[2].y, points[1].y - 150, points[4].y + 150, 5);
            while (sequence.hasMoreInts()) {
                int value = sequence.nextInt();
                figure = drawing.findFigureWithout(points[3].x, value, points[2].x, value, this);
                if (figure != null) continue;
                rightOk = false;
                IntSequence seq2 = new IntSequence(points[1].x, points[0].x + 6 + 2, rightX, 5);
                while (seq2.hasMoreInts()) {
                    value2 = seq2.nextInt();
                    figure = drawing.findFigureWithout(value2, points[1].y, value2, points[2].y, this);
                    if (figure != null) continue;
                    rightOk = true;
                    break;
                }
                if (rightOk) {
                    leftOk = false;
                    IntSequence seq3 = new IntSequence(points[4].x, leftX, points[5].x - 6 - 2, 5);
                    while (seq3.hasMoreInts()) {
                        value3 = seq3.nextInt();
                        figure = drawing.findFigureWithout(value3, points[3].y, value3, points[4].y, this);
                        if (figure != null) continue;
                        leftOk = true;
                        break;
                    }
                }
                if (!leftOk || !rightOk || (figure = drawing.findFigureWithout(value3, value, value2, value, this)) != null) continue;
                this.movePoints(1, value2 - points[1].x);
                this.movePoints(2, value - points[2].y);
                this.movePoints(3, value3 - points[4].x);
                break;
            }
        }
    }

    public void checkPointOrder() {
        int pointCount = this.pointCount();
        if (pointCount > 2) {
            Point[] points = new Point[pointCount];
            for (int loop = 0; loop < pointCount; ++loop) {
                points[loop] = this.pointAt(loop);
            }
            if (points[0].x > points[1].x - 2 || points[0].x > points[2].x - 2) {
                points[1].x = points[0].x + 2;
                points[2].x = points[0].x + 2;
            }
            if (points[pointCount - 1].x < points[pointCount - 2].x + 2) {
                points[pointCount - 2].x = points[pointCount - 1].x - 2;
                points[pointCount - 3].x = points[pointCount - 1].x - 2;
            }
        }
    }

    public void checkPoints() {
        int pointCount = this.pointCount();
        Drawing drawing = this.drawing();
        Point[] points = new Point[pointCount];
        for (int loop = 0; loop < pointCount; ++loop) {
            points[loop] = this.pointAt(loop);
        }
        if (drawing != null) {
            if (pointCount == 4) {
                this.check4Points(drawing, points);
            } else if (pointCount == 6) {
                this.check6Points(drawing, points);
            }
        }
    }

    public Object clone() {
        FixedElbowConnection figure = (FixedElbowConnection)super.clone();
        figure.setAttribute("ArrowMode", new Integer(0));
        figure.fCurrentZoom = 100;
        return figure;
    }

    public Locator connectedTextLocator(Figure f) {
        return new ElbowTextLocator();
    }

    public void connectEnd(Connector end) {
        this.fEnd = end;
        if (!this.getConstraint().isDeleted()) {
            end.owner().getConstraint().addBidirectionalLink(this.getConstraint());
        }
    }

    public void connectStart(Connector start) {
        super.connectStart(start);
        if (!this.getConstraint().isDeleted()) {
            start.owner().getConstraint().addBidirectionalLink(this.getConstraint());
        }
    }

    public FigureConstraint createConstraint() {
        if (this.fEnd != null && this.fEnd.owner() instanceof InputCutConnectFigure) {
            return new OutputLineConstraint(this);
        }
        if (this.fStart != null && this.fStart.owner() instanceof OutputCutConnectFigure) {
            return new InputLineConstraint(this);
        }
        return new ConnectionLineConstraint(this);
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.getConstraint().removeBirectionalLink(this.endFigure().getConstraint());
        this.fEnd = null;
    }

    public void disconnectStart() {
        this.getConstraint().removeBirectionalLink(this.startFigure().getConstraint());
        this.fStart = null;
    }

    public Rectangle displayBox() {
        Rectangle r = super.displayBox();
        r.grow(0, 2);
        return r;
    }

    public void draw(Graphics g) {
        if (this.needsUpdate) {
            this.updateConnection();
        }
        super.draw(g);
        if (this.fConnectorVisibility && this.fAbsoluteConnector != null) {
            this.fAbsoluteConnector.draw(g);
        }
    }

    public Color getFrameColor() {
        return super.getFrameColor();
    }

    protected Stroke getStroke() {
        if (this.fStart != null && this.fStart.owner() instanceof BlockIfcFigure) {
            return ((BlockIfcFigure)this.fStart.owner()).getStroke();
        }
        if (this.fEnd != null && this.fEnd.owner() instanceof BlockIfcFigure) {
            return ((BlockIfcFigure)this.fEnd.owner()).getStroke();
        }
        return super.getStroke();
    }

    public void drawSimulation1(Graphics g) {
        boolean value = false;
        boolean binaryConnector = true;
        if (this.startFigure() instanceof BlockConnectorOwner) {
            BlockConnectorOwner oif = (BlockConnectorOwner)((Object)this.startFigure());
            OutBlockConnector outBlockConnector = (OutBlockConnector)oif.getBlockConnector();
            if (outBlockConnector instanceof BinaryOutBlockConnector) {
                value = ((BinaryOutBlockConnector)outBlockConnector).getBinaryValue();
            } else {
                binaryConnector = false;
            }
        } else {
            InputIfcFigure iif = (InputIfcFigure)this.endFigure();
            OutBlockConnector outBlockConnector = ((InBlockConnector)iif.getBlockConnector()).getLinkedConnector();
            if (outBlockConnector instanceof BinaryOutBlockConnector) {
                value = ((BinaryOutBlockConnector)outBlockConnector).getBinaryValue();
            } else {
                binaryConnector = false;
            }
        }
        Color oldColor = this.getFrameColor();
        if (binaryConnector) {
            Color color = null;
            color = value ? Global.SIMULATION_COLOR_HIGH : Global.SIMULATION_COLOR_LOW;
            if (this.getFrameColor().equals(color)) {
                return;
            }
            this.setFrameColor(color);
        }
        this.draw(g);
        this.setFrameColor(oldColor);
    }

    private boolean endFigureIsLeftOfStartFigure() {
        Figure start = this.start().owner();
        Figure end = this.end().owner();
        Rectangle rStart = start.displayBox();
        Rectangle rEnd = end.displayBox();
        boolean retValue = rStart.x + rStart.width >= rEnd.x;
        return retValue;
    }

    public Vector handles() {
        int i;
        Vector<AbstractHandle> handles = new Vector<AbstractHandle>(this.fPoints.size() * 2);
        handles.addElement(new ChangeOutputIfcHandle(this));
        for (i = 1; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new NullHandle(this, FixedElbowConnection.locator(i)));
        }
        handles.addElement(new ChangeInputIfcHandle(this));
        for (i = 1; i < this.fPoints.size() - 2; ++i) {
            handles.addElement(new ElbowHandle(this, i));
        }
        return handles;
    }

    public boolean intersectsLine(int x1, int y1, int x2, int y2) {
        Rectangle r = new Rectangle(new Point(x1, y1));
        r.add(x2, y2);
        r.grow(1, 1);
        int pointCount = this.pointCount();
        if (pointCount == 4 || pointCount == 6) {
            if (y1 == y2) {
                Rectangle figureRect = new Rectangle(this.pointAt(0));
                figureRect.add(this.pointAt(1));
                figureRect.grow(1, 1);
                if (figureRect.intersects(r)) {
                    return true;
                }
                figureRect = new Rectangle(this.pointAt(3));
                figureRect.add(this.pointAt(2));
                figureRect.grow(1, 1);
                if (figureRect.intersects(r)) {
                    return true;
                }
                if (pointCount == 6) {
                    figureRect = new Rectangle(this.pointAt(4));
                    figureRect.add(this.pointAt(5));
                    figureRect.grow(1, 1);
                    if (figureRect.intersects(r)) {
                        return true;
                    }
                }
            } else if (x1 == x2) {
                Rectangle figureRect = new Rectangle(this.pointAt(1));
                figureRect.add(this.pointAt(2));
                figureRect.grow(1, 1);
                if (figureRect.intersects(r)) {
                    return true;
                }
                if (pointCount == 6) {
                    figureRect = new Rectangle(this.pointAt(3));
                    figureRect.add(this.pointAt(4));
                    figureRect.grow(1, 1);
                    if (figureRect.intersects(r)) {
                        return true;
                    }
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public boolean intersectsRectangle(Rectangle r) {
        for (int i = 0; i < this.pointCount() - 1; ++i) {
            Rectangle lineRectangle = new Rectangle(Math.min(this.pointAt((int)i).x, this.pointAt((int)(i + 1)).x), Math.min(this.pointAt((int)i).y, this.pointAt((int)(i + 1)).y), Math.abs(this.pointAt((int)(i + 1)).x - this.pointAt((int)i).x), Math.abs(this.pointAt((int)(i + 1)).y - this.pointAt((int)i).y));
            lineRectangle.grow(1, 1);
            if (!lineRectangle.intersects(r)) continue;
            return true;
        }
        return false;
    }

    private void moveDependentPoints(int pointNumber) {
        Point p = null;
        Point helpPoint = null;
        Enumeration k = this.fPoints.elements();
        int counter = 0;
        while (k.hasMoreElements()) {
            p = (Point)k.nextElement();
            if (counter == 1) {
                p.y = helpPoint.y;
            } else if (counter == pointNumber - 1) {
                helpPoint.y = p.y;
            }
            helpPoint = p;
            ++counter;
        }
    }

    public void movePoints(int section, int distance) {
        int counter = 0;
        int modificationPoint = 99;
        Point p = null;
        boolean direction = false;
        Enumeration k = this.fPoints.elements();
        switch (section) {
            case 1: {
                modificationPoint = 1;
                break;
            }
            case 2: {
                modificationPoint = 2;
                direction = true;
                break;
            }
            case 3: {
                modificationPoint = 3;
            }
        }
        while (k.hasMoreElements()) {
            p = (Point)k.nextElement();
            if (counter == modificationPoint || counter == modificationPoint + 1) {
                if (!direction) {
                    p.x += distance;
                } else {
                    p.y += distance;
                }
            }
            ++counter;
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fCurrentZoom = dr.readInt();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fixedElbowConnectionSerializedDataVersion == 1) {
            Figure f;
            this.fixedElbowConnectionSerializedDataVersion = 2;
            if (this.fStart != null && (f = this.fStart.owner()) instanceof OutputCutConnectFigure) {
                this.disconnectStart();
                this.connectStart(new CCRightConnector(f));
            }
            if (this.fEnd != null && (f = this.fEnd.owner()) instanceof InputCutConnectFigure) {
                this.disconnectEnd();
                this.connectEnd(new CCRightConnector(f));
            }
        }
        if (this.fixedElbowConnectionSerializedDataVersion < 4) {
            this.fixedElbowConnectionSerializedDataVersion = 4;
            this.needsUpdate = true;
        }
    }

    public void setNeedsUpdate(boolean newValue) {
        if (newValue && !this.needsUpdate) {
            this.invalidate();
            this.setChanged();
        }
        this.needsUpdate = newValue;
    }

    public void setUpdateMode(boolean newMode) {
        this.fUpdatePoints = newMode;
    }

    public CuttedConnectionConstraint splitConnection(DrawingView drawingView) {
        CuttedConnectionConstraint ccc = null;
        if (cConnectionSplitter == null) {
            cConnectionSplitter = new AdvancedConnectionSplitter();
        }
        ccc = cConnectionSplitter.splittConnection(this, drawingView);
        ccc.insert(drawingView.drawing());
        return ccc;
    }

    public String toString() {
        return super.toString() + ": fStart=" + this.fStart + "; fEnd=" + this.fEnd;
    }

    public void updateConnection() {
        if (this.fUpdatePoints) {
            super.updateConnection();
            int prePointCount = this.pointCount();
            this.updatePoints();
            if (prePointCount != this.pointCount()) {
                this.constrainerPoints();
            }
            this.needsUpdate = false;
        }
    }

    protected void constrainerPoints() {
        DrawingView view = null;
        try {
            view = ((LogoComfort)Application.getInstance().getActiveApplicationSurface().getEditor()).view();
        }
        catch (Exception e) {
            // empty catch block
        }
        PointConstrainer c = null;
        if (view != null) {
            c = view.getConstrainer();
        }
        if (!(c instanceof LogoGridConstrainer) || !((LogoGridConstrainer)c).getGridIfc().gridConnectionAttractionIsOn()) {
            return;
        }
        c = new LogoConnectionGridConstrainer(c);
        boolean isVertical = false;
        Point startPoint = this.startPoint();
        Point endPoint = this.endPoint();
        for (int i = 1; i < this.pointCount() - 1; ++i) {
            Point p;
            if (isVertical) {
                p = c.constrainY(this.pointAt(i));
                p.x = this.pointAt((int)(i - 1)).x;
            } else {
                p = c.constrainX(this.pointAt(i));
                p.y = this.pointAt((int)(i - 1)).y;
            }
            boolean bl = isVertical = !isVertical;
            if (i == 1 && this.pointCount() == 4) {
                if (endPoint.x - p.x <= 0) {
                    p.x = (startPoint.x + endPoint.x) / 2;
                }
            } else if (i == 3 && this.pointCount() == 6 && endPoint.x - p.x <= 0) {
                p.x -= c.getStepX();
            }
            this.fPoints.setElementAt(p, i);
        }
        Point p1 = this.pointAt(this.pointCount() - 2);
        this.fPoints.setElementAt(new Point(p1.x, endPoint.y), this.pointCount() - 2);
    }

    protected void updatePoints() {
        if (this.fUpdatePoints) {
            if (this.start() == null || this.end() == null) {
                this.container().removeFromDrawing(this);
                return;
            }
            this.checkPointOrder();
            this.willChange();
            Point start = this.startPoint();
            Point end = this.endPoint();
            Object p = null;
            int DIFF = 20;
            int count = this.fPoints.size();
            if (this.endFigureIsLeftOfStartFigure()) {
                if (count == 2 || count == 4) {
                    this.fPoints.removeAllElements();
                    this.fPoints.addElement(start);
                    this.fPoints.addElement(new Point(start.x + 20, start.y));
                    this.fPoints.addElement(new Point(start.x + 20, start.y + (end.y - start.y) / 2));
                    this.fPoints.addElement(new Point(end.x - 20, start.y + (end.y - start.y) / 2));
                    this.fPoints.addElement(new Point(end.x - 20, end.y));
                    this.fPoints.addElement(end);
                    this.checkPoints();
                } else {
                    this.moveDependentPoints(count);
                }
            } else if (count == 2 || count == 6) {
                this.fPoints.removeAllElements();
                this.fPoints.addElement(start);
                this.fPoints.addElement(new Point((start.x + end.x) / 2, start.y));
                this.fPoints.addElement(new Point((start.x + end.x) / 2, end.y));
                this.fPoints.addElement(end);
                this.checkPoints();
            } else {
                this.moveDependentPoints(count);
            }
            this.changed();
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fCurrentZoom);
    }

    public void zoomChanged(int newZoom) {
        int pointCount = this.pointCount();
        double zoomFactor = (double)newZoom / (double)this.fCurrentZoom;
        Point p = null;
        for (int i = 1; i < pointCount - 1; ++i) {
            p = this.pointAt(i);
            p.x = (int)((double)p.x * zoomFactor);
            p.y = (int)((double)p.y * zoomFactor);
        }
        this.fCurrentZoom = newZoom;
        this.setNeedsUpdate(true);
    }

    public boolean canConnect() {
        return true;
    }

    public Connector connectorAt(int x, int y) {
        if (this.fAbsoluteConnector == null) {
            this.fAbsoluteConnector = new AbsoluteConnector(this, new Point(x, y));
        }
        this.fAbsoluteConnector.setLocation(new Point(x, y));
        return this.fAbsoluteConnector;
    }

    public BlockConnector getBlockConnector() {
        if (this.startFigure() instanceof BlockConnectorOwner) {
            return ((BlockConnectorOwner)((Object)this.startFigure())).getBlockConnector();
        }
        return null;
    }

    public Point getSnatchPoint(Point cursorPosition) {
        return cursorPosition;
    }
}

