/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DeletedFigureEvent;
import CH.ifa.draw.framework.FigureContainer;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.pdraw.figures.CutConnectTextFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.constraints.CutConnectionFigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.util.ZoomableFigure;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public abstract class CutConnectFigure
extends PolygonFigure
implements Observer,
ZoomableFigure {
    static final long serialVersionUID = 6576871698394945994L;
    private int cutConnectFigureSerializedDataVersion = 2;
    public static int FIGURE_SIZE = 5;
    protected static int FIGURE_BASEPOINTS = 6;
    protected CutConnectFigure fPartnerFigure = null;
    protected FixedElbowConnection fConnectionFigure = null;
    protected Point[] fBasePoints;
    transient int fMoveByRestX = 0;
    transient int fMoveByRestY = 0;
    protected CutConnectTextFigure fCCTextFigure = new CutConnectTextFigure();
    transient boolean fDescriptionNeedsUpdate = false;

    public CutConnectFigure() {
        this.fBasePoints = new Point[FIGURE_BASEPOINTS];
    }

    public void basicMoveBy(int x, int y) {
        super.basicMoveBy(x, y);
    }

    public abstract Point connectorStartPoint();

    public FigureConstraint createConstraint() {
        return new CutConnectionFigureConstraint(this);
    }

    public Rectangle displayBox() {
        Rectangle r1 = super.displayBox();
        Rectangle r2 = this.fCCTextFigure.displayBox();
        r1.y -= r2.height;
        r1.height += r2.height;
        if (r2.width > r1.width) {
            r1.width = r2.width;
        }
        return r1;
    }

    public void draw(Graphics g) {
        super.draw(g);
        if (this.fDescriptionNeedsUpdate) {
            this.fDescriptionNeedsUpdate = false;
        }
        Font originFont = g.getFont();
        Font textFont = this.fCCTextFigure.getFont();
        if (textFont != null) {
            g.setFont(textFont);
        }
        g.drawString(this.fCCTextFigure.getText(), this.pointAt((int)0).x, this.pointAt((int)0).y - 1);
        if (originFont != null) {
            g.setFont(originFont);
        }
    }

    public FixedElbowConnection getConnectionFigure() {
        return (FixedElbowConnection)((CutConnectionFigureConstraint)this.getConstraint()).getConnectionLineConstraint().getFigure();
    }

    public String getDescription() {
        return this.fCCTextFigure.getText();
    }

    public CutConnectFigure getPartner() {
        return this.fPartnerFigure;
    }

    public Vector handles() {
        Vector<NullHandle> handles = new Vector<NullHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return handles;
    }

    public boolean intersectsLine(int x1, int y1, int x2, int y2) {
        Rectangle r = new Rectangle(new Point(x1, y1));
        r.add(x2, y2);
        r.grow(1, 1);
        return this.displayBox().intersects(r);
    }

    public void invalidate() {
        Rectangle r1 = super.displayBox();
        Rectangle r2 = this.fCCTextFigure.displayBox();
        r1.y -= r2.height;
        r1.height += r2.height;
        if (r2.width > r1.width) {
            r1.width = r2.width;
        }
        r1.grow(8, 8);
        FigureContainer fc = this.container();
        if (fc != null) {
            fc.invalidate(r1);
        }
    }

    protected Rectangle parentDisplayBox() {
        return super.displayBox();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fPartnerFigure = (CutConnectFigure)dr.readStorable();
        this.fConnectionFigure = (FixedElbowConnection)dr.readStorable();
        this.fCCTextFigure = (CutConnectTextFigure)dr.readStorable();
        for (int i = 0; i < FIGURE_BASEPOINTS; ++i) {
            this.fBasePoints[i] = new Point(dr.readInt(), dr.readInt());
        }
        this.fDescriptionNeedsUpdate = true;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
    }

    public void setConnectionFigure(FixedElbowConnection connection) {
        this.fConnectionFigure = connection;
    }

    public abstract void setDescription(LogoDrawing var1);

    public abstract String getTooltip(LogoDrawing var1);

    public void setPartner(CutConnectFigure partner) {
        if (this.fPartnerFigure != partner) {
            this.fPartnerFigure = partner;
            partner.setPartner(this);
        }
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof DeletedFigureEvent && this.container() != null) {
            this.container().removeFromDrawing(this);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fPartnerFigure);
        dw.writeStorable(this.fConnectionFigure);
        dw.writeStorable(this.fCCTextFigure);
        for (int i = 0; i < FIGURE_BASEPOINTS; ++i) {
            dw.writeInt(this.fBasePoints[i].x);
            dw.writeInt(this.fBasePoints[i].y);
        }
    }

    public void zoomChanged(int newZoom) {
        int pointCount = this.pointCount();
        Polygon polygon = new Polygon();
        for (int i = 0; i < this.fBasePoints.length; ++i) {
            polygon.addPoint(this.fBasePoints[i].x * newZoom / 100, this.fBasePoints[i].y * newZoom / 100);
        }
        this.substitutePolygon(polygon);
        this.fMoveByRestX = 0;
        this.fMoveByRestY = 0;
        if (this.fCCTextFigure != null) {
            this.fCCTextFigure.zoomChanged(newZoom);
        }
    }
}

