/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.constraints.CommentConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.standard.FupFigureDrawInfo;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.util.ChangedCommentEvent;
import DE.siemens.ad.pdraw.util.ZoomableFigure;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Observable;
import java.util.Vector;

public class CommentTextFigure
extends TextFigure
implements ZoomableFigure,
ParameterSetListener {
    protected CommentParameter fCommentParameter;
    private static final long serialVersionUID = 1L;
    private int CommentFigureSerializedDataVersion = 2;
    protected int fSize100 = FONT_SIZE;
    protected int fOriginX100 = 0;
    protected int fOriginY100 = 0;
    protected String fInvisibleText = "";
    protected boolean fIsVisible = true;
    protected static String FONT_NAME = "dialog";
    protected static int FONT_SIZE = 10;
    protected static int FONT_STYLE = 0;
    protected transient int fUpdateLocationCalls = 0;

    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        super.basicDisplayBox(newOrigin, newCorner);
        this.fOriginX100 = newOrigin.x;
        this.fOriginY100 = newOrigin.y;
    }

    protected void basicMoveBy(int x, int y) {
        super.basicMoveBy(x, y);
    }

    public Object clone() {
        CommentTextFigure figure = (CommentTextFigure)super.clone();
        figure.fSize100 = CommentTextFigure.getCurrentFontSize();
        return figure;
    }

    public void connect(Figure figure) {
        BlockFigure blockFigure;
        if (figure instanceof BlockFigure && (blockFigure = (BlockFigure)figure).getCommentFigure() == null) {
            blockFigure.setCommentFigure(this);
            super.connect(figure);
        }
    }

    public FigureConstraint createConstraint() {
        return new CommentConstraint(this);
    }

    public void disconnect() {
        super.disconnect();
    }

    public void draw(Graphics g) {
        if (this.container() instanceof Drawing && !((LogoDrawing)this.drawing()).getOptionProperties().getDisplayComments()) {
            return;
        }
        super.draw(g);
    }

    public void draw(Graphics g, FigureDrawInfo fdi) {
        if (this.container() instanceof Drawing && !((FupFigureDrawInfo)fdi).drawComments()) {
            return;
        }
        super.draw(g, fdi);
    }

    public void setCommentParameter(CommentParameter commentParameter) {
        if (this.fCommentParameter != null) {
            this.fCommentParameter.removeParameterSetListener(this);
        }
        this.fCommentParameter = commentParameter;
        if (commentParameter != null) {
            commentParameter.addParameterSetListener(this);
            if (commentParameter.getText() != null && commentParameter.getText().length() > 0) {
                this.setVisible(true);
                this.setText(commentParameter.getText());
            } else {
                this.setVisible(false);
            }
        }
    }

    public String getText() {
        if (this.fObservedFigure != null) {
            if (this.fObservedFigure instanceof BlockFigure) {
                BlockFigure bF = (BlockFigure)this.fObservedFigure;
                return bF.getCommentParameter().getText();
            }
            return super.getText();
        }
        return super.getText();
    }

    public Vector handles() {
        Vector<NullHandle> handles = new Vector<NullHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        return handles;
    }

    public boolean intersectsRectangle(Rectangle r) {
        return false;
    }

    public boolean isVisible() {
        return this.fIsVisible;
    }

    public boolean isSelectable() {
        return this.fIsVisible;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fSize100 = dr.readInt();
        this.fOriginX100 = dr.readInt();
        this.fOriginY100 = dr.readInt();
        this.fInvisibleText = dr.readString();
        this.fIsVisible = dr.readBoolean();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.getConstraint().addBidirectionalLink(this.getConstraint());
        }
        this.markDirty();
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        if (name.equals("FontSize")) {
            Integer s = (Integer)value;
            this.fSize100 = s;
        }
    }

    public void setText(String newText) {
        if (super.getText() != null && super.getText().equals(newText)) {
            return;
        }
        if (this.fIsVisible) {
            super.setText(newText);
        } else {
            this.fInvisibleText = newText;
        }
        if (this.fObservedFigure != null && this.fObservedFigure instanceof BlockFigure) {
            BlockFigure bF = (BlockFigure)this.fObservedFigure;
            bF.getCommentParameter().setText(newText);
            bF.getCommentParameter().fireParameterSetEvent();
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            if (!this.fIsVisible) {
                this.fIsVisible = true;
                if (this.fInvisibleText != null) {
                    super.setText(this.fInvisibleText);
                }
            }
        } else if (this.fIsVisible) {
            this.fIsVisible = false;
            this.fInvisibleText = this.getText();
            super.setText("");
        }
    }

    public Dimension size() {
        if (this.fIsVisible) {
            return super.size();
        }
        super.setText(this.fInvisibleText);
        Dimension dim = super.size();
        super.setText("");
        return dim;
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof ChangedCommentEvent) {
            this.setText(((ChangedCommentEvent)arg).getComment());
            if (this.container() != null) {
                this.container().forceUpdate();
            }
        } else {
            super.update(o, arg);
        }
    }

    protected void updateLocation() {
        if (this.fLocator != null && this.fLocator.getOffset().equals(new Dimension(0, 0))) {
            Point p = this.fLocator.locate(this.fObservedFigure);
            int dx = p.x - (this.size().width / 2 + this.fOriginX);
            int dy = p.y - (this.size().height + this.fOriginY);
            if (dy != 0 || dy != 0) {
                this.willChange();
                this.basicMoveBy(dx, dy);
                this.changed();
            }
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fSize100);
        dw.writeInt(this.fOriginX100);
        dw.writeInt(this.fOriginY100);
        dw.writeString(this.fInvisibleText);
        dw.writeBoolean(this.fIsVisible);
    }

    public void zoomChanged(int newZoom) {
        this.willChange();
        Rectangle rect = this.displayBox();
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), font.getStyle(), this.fSize100 * newZoom / 100));
        Dimension d = this.textExtent();
        super.basicDisplayBox(new Point(this.fOriginX100 * newZoom / 100, this.fOriginY100 * newZoom / 100), new Point(this.fOriginX100 * newZoom / 100 + d.width * newZoom / 100, this.fOriginY100 * newZoom / 100 + d.height * newZoom / 100));
        this.changed();
        this.invalidate();
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        super.setText(newParameterText);
    }

    public OffsetLocator getOffsetLocator() {
        return this.fLocator;
    }
}

