/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureContainer;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.BlockNameChangedListener;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.BlockPropertyChangeListener;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.BlockTextFigure;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.figures.ConnectorNameTextFigure;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.figures.ParameterTextFigure;
import DE.siemens.ad.pdraw.figures.PrintImageFigure;
import DE.siemens.ad.pdraw.figures.SimulationTextFigure;
import DE.siemens.ad.pdraw.figures.constraints.BlockConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.standard.FupFigureDrawInfo;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.util.ZoomableFigure;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BlockFigure
extends CompositeFigure
implements ZoomableFigure,
BlockNameChangedListener,
ParameterSetListener,
BlockPropertyChangeListener {
    public static final String PARAMETER_FIGURE_GROUP = "parameterFigureGroup";
    public static final String BLOCK_NUMBER_FIGURE_GROUP = "blockNumberFigureGroup";
    public static final String OUT_CONNECTOR_FIGURE_GROUP = "outConnectorFigureGroup";
    public static final String IN_CONNECTOR_FIGURE_GROUP = "inConnectorFigureGroup";
    public static final String IMAGE_FIGURE_GROUP = "imageFigureGroup";
    public static final String CONNECTOR_NAME_FIGURE_GROUP = "connectorNameFigureGroup";
    protected static final int IFCLENGTH = 6;
    protected static int MINDISTANCE = 10;
    protected static final int TEXT_EXTENT_HEIGHT = 16;
    protected Rectangle fDisplayBox;
    protected Rectangle fDisplayBox100;
    protected int fImageWidth100;
    protected int fImageHeight100;
    protected Block fBlock;
    protected boolean fParameterTextIsVisible = true;
    protected boolean fBlockNumberIsVisible = true;
    protected Color fBorderColor = Color.black;
    protected CommentParameter fCommentParameter = null;
    protected CommentTextFigure fCommentFigure = null;
    protected CommentTextFigure fCCFigure = new ConnectorNameTextFigure();
    private static final long serialVersionUID = -405133564768517078L;
    private int blockFigureSerializedDataVersion = 6;
    protected transient TextFigure fTmpParameterTextFigure;
    protected transient Color fTmpParameterTextColor = new Color(255, 255, 204);
    protected Map fGroupFiguresMap;

    public BlockFigure() {
        this.fDisplayBox = new Rectangle(0, 0, 0, 0);
        this.fBlock = null;
    }

    public BlockFigure(Block block, Point origin) {
        this.fDisplayBox = new Rectangle(origin.x, origin.y, 0, 0);
        this.fBlock = block;
        this.createBlockFigureComponents();
        this.fTmpParameterTextFigure = new SimulationTextFigure();
        this.fTmpParameterTextFigure.setAttribute("FillColor", new Color(255, 255, 204));
        this.fBlock.addPropertyChangeListener(this);
    }

    protected void addBlockTextFigure() {
        BlockTextFigure blockTextFigure = new BlockTextFigure();
        String blockName = this.fBlock.getNumberString();
        blockTextFigure.setText(blockName);
        if (this.fBlock != null) {
            this.fBlock.addBlockNameChangedListener(this);
        }
        this.add(blockTextFigure, BLOCK_NUMBER_FIGURE_GROUP);
    }

    protected void addInputFigure(BlockConnector blockConnector) {
        InputIfcFigure inputFigure = new InputIfcFigure(blockConnector);
        inputFigure.getConstraint().setContainer((BlockConstraint)this.getConstraint());
        this.add(inputFigure, IN_CONNECTOR_FIGURE_GROUP);
    }

    protected void addInputFigures() {
        int inputCount = this.fBlock.getInConnectorCount();
        InBlockConnector blockConnector = null;
        for (int i = 0; i < inputCount; ++i) {
            blockConnector = this.fBlock.getInConnector(i);
            this.addInputFigure(blockConnector);
        }
    }

    protected void addOutputFigure(OutBlockConnector outBlockConnector) {
        OutputIfcFigure outputFigure = new OutputIfcFigure(outBlockConnector);
        outputFigure.getConstraint().setContainer((BlockConstraint)this.getConstraint());
        this.add(outputFigure, OUT_CONNECTOR_FIGURE_GROUP);
    }

    protected void addOutputFigures() {
        int outputCount = this.fBlock.getOutConnectorCount();
        for (int i = 0; i < outputCount; ++i) {
            this.addOutputFigure(this.fBlock.getOutConnector(i));
        }
    }

    protected void addConnectorNameFigure() {
        this.add(this.fCCFigure, CONNECTOR_NAME_FIGURE_GROUP);
    }

    protected void addParameterTextFigure() {
        ParameterTextFigure parameterTextFigure = new ParameterTextFigure();
        if (this.fBlock.getParameter() != null) {
            String parameterText = this.fBlock.getParameter().getParameterText();
            parameterTextFigure.setText(Util.restrictLenght(parameterText, 15));
            this.fBlock.getParameter().addParameterSetListener(this);
        } else {
            parameterTextFigure.setText(" ");
        }
        this.add(parameterTextFigure, PARAMETER_FIGURE_GROUP);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
        this.layout();
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            figureEnumeration.nextFigure().moveBy(x, y);
        }
    }

    public void blockNameChanged(Block newBlock) {
        LogoDrawing drawing = (LogoDrawing)this.drawing();
        if (this.fBlock.equals(newBlock)) {
            String blockName = this.fBlock.getNumberString();
            BlockTextFigure figure = this.getBlockTextFigure();
            String oldFigureName = null;
            if (figure != null) {
                oldFigureName = figure.getText();
                figure.setText(blockName);
            }
            if (drawing != null) {
                CommentParameter newCommentParam;
                if (oldFigureName != null) {
                    drawing.updateCutConnectFigures(oldFigureName);
                }
                if (this.fCommentParameter != (newCommentParam = drawing.getCommentManager().getCommentParameter(this.fBlock))) {
                    if (this.fCommentParameter != null) {
                        this.fCommentParameter.removeParameterSetListener(this);
                    }
                    this.fCommentParameter = newCommentParam;
                    if (this.fCommentParameter != null) {
                        this.fCommentParameter.addParameterSetListener(this);
                        this.setComment(this.fCommentParameter);
                    }
                }
                this.setInputName();
            }
        }
    }

    public void setComment(CommentParameter commentParameter) {
        if (this.fCommentFigure != null) {
            this.fCommentFigure.setCommentParameter(commentParameter);
            if (this.container() instanceof LogoDrawing) {
                this.fCommentFigure.getConstraint().insert((LogoDrawing)this.container());
            }
        } else if (commentParameter != null && commentParameter.getText() != null && commentParameter.getText().length() > 0) {
            CommentTextFigure ctf = new CommentTextFigure();
            System.out.println("new Comment figure created.");
            ctf.setCommentParameter(commentParameter);
            ctf.connect(this);
            ctf.updateLocation();
            if (this.drawing() != null) {
                this.drawing().add(this.fCommentFigure);
            }
        }
    }

    public boolean containsPoint(int x, int y) {
        Rectangle bounds = this.getImageFigure().displayBox();
        return bounds.contains(x, y);
    }

    protected void createBlockFigureComponents() {
        if (this.fBlock == null) {
            return;
        }
        String imageName = "/DE/siemens/ad/logo/images/" + this.fBlock.getIconName();
        Image image = Global.getImage(this.fBlock.getIconName());
        PrintImageFigure imageFigure = new PrintImageFigure(image, imageName, new Point(this.fDisplayBox.x, this.fDisplayBox.y));
        this.add(imageFigure, IMAGE_FIGURE_GROUP);
        this.addInputFigures();
        this.addOutputFigures();
        this.addBlockTextFigure();
        this.addParameterTextFigure();
        this.addConnectorNameFigure();
        this.layout();
    }

    public FigureConstraint createConstraint() {
        return new BlockConstraint(this);
    }

    public Rectangle displayBox() {
        FigureEnumeration k = this.figures();
        Rectangle r = null;
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle displayBox = figure.displayBox();
            if (!figure.isVisible()) continue;
            if (r == null) {
                r = new Rectangle(displayBox);
                continue;
            }
            r.add(displayBox);
        }
        ++r.height;
        return r;
    }

    public void draw(Graphics g, FigureDrawInfo figureDrawInfo) {
        Figure fig = null;
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            fig = k.nextFigure();
            if (fig == this.fCCFigure) {
                if (!(figureDrawInfo instanceof FupFigureDrawInfo) || !((FupFigureDrawInfo)figureDrawInfo).drawConnectorNames()) continue;
                fig.draw(g, figureDrawInfo);
                continue;
            }
            if (fig instanceof PrintImageFigure) {
                ((PrintImageFigure)fig).draw(g, figureDrawInfo, this);
                continue;
            }
            fig.draw(g, figureDrawInfo);
        }
        FupFigureDrawInfo fupFigureDrawInfo = (FupFigureDrawInfo)figureDrawInfo;
        this.drawBorder(g);
    }

    protected void drawBorder(Graphics g) {
        if (this.getBlock() instanceof ContactBlock || this.getBlock() instanceof CoilBlock) {
            return;
        }
        ImageFigure iF = this.getImageFigure();
        if (iF != null) {
            Rectangle r = iF.displayBox();
            g.setColor(this.fBorderColor);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    public void drawSimulation1(Graphics g) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().drawSimulation1(g);
        }
        boolean binaryConnector = true;
        boolean value = true;
        Block block = this.getBlock();
        OutBlockConnector[] conArr = block.getOutConnectors();
        if (conArr != null && conArr.length > 0 && conArr[0] instanceof BinaryOutBlockConnector) {
            for (int j = 0; j < conArr.length; ++j) {
                if (((BinaryOutBlockConnector)conArr[j]).getOwner().getBinaryValue()) continue;
                value = false;
            }
        } else {
            binaryConnector = false;
        }
        Color oldColor = this.fBorderColor;
        if (binaryConnector) {
            this.fBorderColor = value ? Global.SIMULATION_COLOR_HIGH : Global.SIMULATION_COLOR_LOW;
        }
        ImageFigure iF = this.getImageFigure();
        Rectangle r = null;
        if (iF != null) {
            r = iF.displayBox();
            g.setColor(this.fBorderColor);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        this.fBorderColor = oldColor;
    }

    public void drawSimulation2(Graphics g) {
        Block block = this.getBlock();
        if (block instanceof SpecialBlock || block instanceof InputBlock) {
            this.getCurrentParameterTextFigure();
            Point currentValuePosition = this.getCurrentParmeterTextPosition();
            this.fTmpParameterTextFigure.basicDisplayBox(currentValuePosition, currentValuePosition);
            BlockParameter blockParameter = block.getParameter();
            String parameterText = "";
            if (blockParameter != null) {
                parameterText = blockParameter.getCurrentParameterText();
            }
            this.fTmpParameterTextFigure.setText(parameterText);
            this.fTmpParameterTextFigure.draw(g);
        }
    }

    public void drawSimulation3(Graphics g) {
        if (this.getBlock() instanceof ContactBlock) {
            boolean value = ((ContactBlock)this.getBlock()).getBinaryContactValue();
            Color borderColor = null;
            borderColor = value ? Global.SIMULATION_COLOR_HIGH : Global.SIMULATION_COLOR_LOW;
            ImageFigure iF = this.getImageFigure();
            if (iF != null) {
                Rectangle r = iF.displayBox();
                g.setColor(borderColor);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }
    }

    public Block getBlock() {
        return this.fBlock;
    }

    public BlockTextFigure getBlockTextFigure() {
        FigureEnumeration k = this.figures();
        Figure f = null;
        while (k.hasMoreElements()) {
            f = (Figure)k.nextElement();
            if (!(f instanceof BlockTextFigure)) continue;
            return (BlockTextFigure)f;
        }
        return null;
    }

    public Point getAlignmentAnchor() {
        Rectangle alignDisplayBox = null;
        FigureEnumeration figures = this.figures();
        Figure figure = null;
        ParameterTextFigure parameterTextFigure = this.getParameterTextFigure();
        while (figures.hasMoreElements()) {
            figure = figures.nextFigure();
            if (figure == parameterTextFigure) continue;
            if (alignDisplayBox == null) {
                alignDisplayBox = new Rectangle(figure.getAlignmentAnchor());
                continue;
            }
            alignDisplayBox.add(figure.getAlignmentAnchor());
        }
        if (this.getBlock().getInConnectorCount() == 0) {
            alignDisplayBox.x -= 6;
        }
        return alignDisplayBox.getLocation();
    }

    public Point getAlignmentAnchorGrid() {
        Point ret = this.getAlignmentAnchor();
        FigureEnumeration figures = this.figures();
        Figure figure = null;
        while (figures.hasMoreElements()) {
            figure = figures.nextFigure();
            if (!(figure instanceof BlockIfcFigure)) continue;
            ret.y = figure.displayBox().getLocation().y;
            break;
        }
        return ret;
    }

    public CommentTextFigure getCommentFigure() {
        return this.fCommentFigure;
    }

    public CommentParameter getCommentParameter() {
        return this.fCommentParameter;
    }

    public ImageFigure getImageFigure() {
        Vector figures = (Vector)this.getGroupFiguresMap().get(IMAGE_FIGURE_GROUP);
        if (!figures.isEmpty()) {
            return (ImageFigure)figures.elementAt(0);
        }
        return null;
    }

    public InputIfcFigure getInputIfcFigure(BlockConnector blockConnector) {
        FigureEnumeration k = this.figures();
        Figure f = null;
        while (k.hasMoreElements()) {
            InputIfcFigure iFigure;
            f = (Figure)k.nextElement();
            if (!(f instanceof InputIfcFigure) || !(iFigure = (InputIfcFigure)f).getBlockConnector().equals(blockConnector)) continue;
            return iFigure;
        }
        return null;
    }

    public Point getCurrentParmeterTextPosition() {
        ImageFigure imageFigure = this.getImageFigure();
        Rectangle r = null;
        if (imageFigure != null) {
            r = imageFigure.displayBox();
        }
        return new Point(r.getLocation().x, r.getLocation().y + r.height + 1);
    }

    public TextFigure getCurrentParameterTextFigure() {
        if (this.fTmpParameterTextFigure == null) {
            this.fTmpParameterTextFigure = new SimulationTextFigure();
            this.fTmpParameterTextFigure.setAttribute("FillColor", this.getCurrentParameterTextFigureColor());
        }
        return this.fTmpParameterTextFigure;
    }

    private Object getCurrentParameterTextFigureColor() {
        if (this.fTmpParameterTextColor == null) {
            this.fTmpParameterTextColor = new Color(255, 255, 204);
        }
        return this.fTmpParameterTextColor;
    }

    public OutputIfcFigure getOutputIfcFigure(BlockConnector bConnector) {
        FigureEnumeration k = this.figures();
        Figure f = null;
        while (k.hasMoreElements()) {
            OutputIfcFigure iFigure;
            f = (Figure)k.nextElement();
            if (!(f instanceof OutputIfcFigure) || !(iFigure = (OutputIfcFigure)f).getBlockConnector().equals(bConnector)) continue;
            return iFigure;
        }
        return null;
    }

    public ParameterTextFigure getParameterTextFigure() {
        Vector figures = (Vector)this.getGroupFiguresMap().get(PARAMETER_FIGURE_GROUP);
        if (!figures.isEmpty()) {
            return (ParameterTextFigure)figures.elementAt(0);
        }
        return null;
    }

    public Vector handles() {
        Vector<NullHandle> handles = new Vector<NullHandle>();
        ImageFigure imageFigure = this.getImageFigure();
        handles.addElement(new NullHandle(imageFigure, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(imageFigure, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(imageFigure, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(imageFigure, RelativeLocator.southEast()));
        return handles;
    }

    public void blockPropertyChange(BlockPropertyChangeEvent event) {
        Vector inputFiguresList;
        if (event.getPropertyType() == "inConnector" && (inputFiguresList = new Vector((Vector)this.getGroupFiguresMap().get(IN_CONNECTOR_FIGURE_GROUP))) != null) {
            this.removeAll(inputFiguresList);
            InBlockConnector[] inBlockConnectors = this.fBlock.getInConnectors();
            for (int i = 0; i < inBlockConnectors.length; ++i) {
                InputIfcFigure inputFigure = this.getInputIfcFigure(inBlockConnectors[i], inputFiguresList);
                if (inputFigure != null) {
                    this.add(inputFigure, IN_CONNECTOR_FIGURE_GROUP);
                    continue;
                }
                this.addInputFigure(inBlockConnectors[i]);
            }
        }
        if (event.getPropertyType() == "icon") {
            this.remove(this.getImageFigure());
            String imageName = this.fBlock.getIconName();
            Image image = Global.getImage(imageName);
            PrintImageFigure imageFigure = new PrintImageFigure(image, imageName, new Point(this.fDisplayBox.x, this.fDisplayBox.y));
            this.add(imageFigure, IMAGE_FIGURE_GROUP);
            this.layout();
        }
        BlockParameter parameter = this.fBlock.getParameter();
        String paramText = " ";
        if (parameter != null) {
            paramText = ((Parameter)parameter).getParameterText();
            parameter.addParameterSetListener(this);
        }
        this.parameterSet(parameter, paramText);
    }

    private InputIfcFigure getInputIfcFigure(InBlockConnector inBlockConnector, List inputIfcList) {
        for (InputIfcFigure inputIfcFigure : inputIfcList) {
            if (inputIfcFigure.getBlockConnector() != inBlockConnector) continue;
            return inputIfcFigure;
        }
        return null;
    }

    protected void insertedIntoDrawing(Drawing drawing) {
        LogoDrawing logoDrawing = (LogoDrawing)drawing;
        String blockName = this.getBlock().getNumberString();
        if (logoDrawing.getCommentManager() != null) {
            if (this.fCommentParameter == null) {
                this.fCommentParameter = logoDrawing.getCommentManager().getCommentParameter(this.getBlock());
            } else {
                CommentParameter oldParam = logoDrawing.getCommentManager().getCommentParameter(this.getBlock());
                if (oldParam != this.fCommentParameter) {
                    if (this.getBlock() instanceof ContactBlock || this.getBlock() instanceof CoilBlock) {
                        this.fCommentParameter.removeAllParameterSetListeners();
                        this.fCommentParameter = oldParam;
                    } else {
                        logoDrawing.getCommentManager().removeCommentListeners(this.getBlock());
                        logoDrawing.getCommentManager().addCommentParameter(this.getBlock(), this.fCommentParameter);
                    }
                } else {
                    System.out.println("???");
                }
            }
            this.setComment(this.fCommentParameter);
            this.fCommentParameter.addParameterSetListener(this);
        }
        String text = null;
        if (logoDrawing.getInputNamesManager() != null && (text = logoDrawing.getInputNamesManager().getInputName(this.getBlock().getNumberString())) != null) {
            if (text.length() > 0) {
                this.fCCFigure.setText("(" + text + ")");
            } else {
                this.fCCFigure.setText("");
            }
        }
    }

    public boolean intersectsLine(int x1, int y1, int x2, int y2) {
        Rectangle r = new Rectangle(new Point(x1, y1));
        r.add(x2, y2);
        r.grow(1, 1);
        Rectangle r2 = this.getImageFigure().displayBox();
        if (x1 == x2) {
            r2.x -= 6;
            r2.width += 12;
        }
        r2.add(this.getBlockTextFigure().displayBox());
        return r2.intersects(r);
    }

    public boolean intersectsRectangle(Rectangle r) {
        Rectangle r2 = this.getImageFigure().displayBox();
        r2.x -= 6;
        r2.width += 12;
        r2.add(this.getBlockTextFigure().displayBox());
        if (r2.intersects(r)) {
            return true;
        }
        ParameterTextFigure ptf = this.getParameterTextFigure();
        if (ptf != null) {
            return r.intersects(ptf.displayBox());
        }
        return false;
    }

    public void invalidate() {
        Rectangle r1 = this.displayBox();
        Rectangle r2 = this.fCCFigure.displayBox();
        r1.width += r2.width;
        r1.grow(8, 8);
        FigureContainer fc = this.container();
        if (fc != null) {
            fc.invalidate(r1);
        }
    }

    protected void layout() {
        BlockTextFigure blockNumberFigure = (BlockTextFigure)((List)this.getGroupFiguresMap().get(BLOCK_NUMBER_FIGURE_GROUP)).get(0);
        Rectangle blockNumberDisplayBox = blockNumberFigure.displayBox();
        ParameterTextFigure parameterTextFigure = (ParameterTextFigure)((List)this.getGroupFiguresMap().get(PARAMETER_FIGURE_GROUP)).get(0);
        Rectangle parameterDisplayBox = parameterTextFigure.displayBox();
        List inConnectorGroup = (List)this.getGroupFiguresMap().get(IN_CONNECTOR_FIGURE_GROUP);
        int inputCount = 0;
        if (inConnectorGroup != null) {
            inputCount = inConnectorGroup.size();
        }
        ImageFigure imageFigure = this.getImageFigure();
        Rectangle imageBox = imageFigure.displayBox();
        imageBox.height = inputCount == 4 ? 38 : 34;
        imageFigure.basicDisplayBox(imageBox);
        Point parameterInConnectorPosition = null;
        for (int i = 0; i < inputCount; ++i) {
            InputIfcFigure inFig = (InputIfcFigure)inConnectorGroup.get(i);
            int yPos = imageBox.y + this.getInputOffset(inputCount, i);
            inFig.setPoints(new Point(imageBox.x - 6, yPos), new Point(imageBox.x, yPos));
            if (inFig.getBlockConnector() instanceof ParameterInBlockConnector && parameterInConnectorPosition == null) {
                parameterInConnectorPosition = new Point(imageBox.x - 6, yPos);
            }
            inFig.getConstraint().move(new Dimension(0, 0));
        }
        List outConnectorGroup = (List)this.getGroupFiguresMap().get(OUT_CONNECTOR_FIGURE_GROUP);
        if (outConnectorGroup != null) {
            for (int i = 0; i < outConnectorGroup.size(); ++i) {
                OutputIfcFigure outFig = (OutputIfcFigure)outConnectorGroup.get(i);
                int yPos = imageBox.y + this.getOffsetOfOutConnector() + i * MINDISTANCE;
                outFig.setPoints(new Point(imageBox.x + imageBox.width, yPos), new Point(imageBox.x + imageBox.width + 6, yPos));
            }
        }
        blockNumberDisplayBox.setLocation(imageBox.x + (imageBox.width - blockNumberDisplayBox.width) / 2, imageBox.getLocation().y - blockNumberDisplayBox.height);
        blockNumberFigure.basicDisplayBox(blockNumberDisplayBox);
        Rectangle connectorNameDisplayBox = this.fCCFigure.displayBox();
        connectorNameDisplayBox.setLocation(blockNumberDisplayBox.x + blockNumberDisplayBox.width, blockNumberDisplayBox.y);
        this.fCCFigure.basicDisplayBox(connectorNameDisplayBox);
        if (parameterInConnectorPosition == null) {
            parameterInConnectorPosition = imageBox.getLocation();
        }
        parameterInConnectorPosition.translate(-parameterDisplayBox.width, 0);
        parameterDisplayBox.setLocation(parameterInConnectorPosition);
        parameterTextFigure.displayBox(parameterDisplayBox);
    }

    private int getInputOffset(int inputCount, int index) {
        if (index > inputCount - 1 || index < 0) {
            System.out.println("Error getInputOffset(), invalid index");
            return 0;
        }
        if (inputCount == 1) {
            return this.getOffsetOfFirstInConnector() + MINDISTANCE;
        }
        if (inputCount == 2) {
            return this.getOffsetOfFirstInConnector() + index * 2 * MINDISTANCE;
        }
        return this.getOffsetOfFirstInConnector() + index * MINDISTANCE;
    }

    private int getOffsetOfFirstInConnector() {
        return 5;
    }

    private int getOffsetOfOutConnector() {
        return 15;
    }

    private void divideFiguresInGroups() {
        Map figureGroupMap = this.getGroupFiguresMap();
        Vector<Figure> imageFigureList = new Vector<Figure>(1);
        figureGroupMap.put(IMAGE_FIGURE_GROUP, imageFigureList);
        Vector<Figure> blockNumberFigureList = new Vector<Figure>(1);
        figureGroupMap.put(BLOCK_NUMBER_FIGURE_GROUP, blockNumberFigureList);
        Vector<Figure> inConnectorFiguresList = new Vector<Figure>(4);
        figureGroupMap.put(IN_CONNECTOR_FIGURE_GROUP, inConnectorFiguresList);
        Vector<Figure> outConnectorFiguresList = new Vector<Figure>(1);
        figureGroupMap.put(OUT_CONNECTOR_FIGURE_GROUP, outConnectorFiguresList);
        Vector<Figure> parameterTextFigureList = new Vector<Figure>(1);
        figureGroupMap.put(PARAMETER_FIGURE_GROUP, parameterTextFigureList);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure instanceof PrintImageFigure) {
                imageFigureList.add(figure);
            }
            if (figure instanceof BlockTextFigure) {
                blockNumberFigureList.add(figure);
            }
            if (figure instanceof ParameterTextFigure) {
                parameterTextFigureList.add(figure);
            }
            if (figure instanceof InputIfcFigure) {
                inConnectorFiguresList.add(figure);
            }
            if (!(figure instanceof OutputIfcFigure)) continue;
            outConnectorFiguresList.add(figure);
        }
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        if (newParameterText == null || newParameterText.equals("")) {
            newParameterText = " ";
        }
        if (parameter instanceof CommentParameter) {
            this.setComment((CommentParameter)parameter);
        } else {
            ParameterTextFigure parameterTextFigure = this.getParameterTextFigure();
            if (parameterTextFigure != null) {
                parameterTextFigure.setText(Util.restrictLenght(newParameterText, 15));
            }
            this.layout();
            this.forceUpdate();
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.fParameterTextIsVisible = dr.readBoolean();
        this.fBlockNumberIsVisible = dr.readBoolean();
        this.fBlock = (Block)dr.readStorable();
        this.fCommentParameter = (CommentParameter)dr.readStorable();
        this.fCommentFigure = (CommentTextFigure)dr.readStorable();
        this.fCCFigure = (CommentTextFigure)dr.readStorable();
        int groups = dr.readInt();
        this.fGroupFiguresMap = new Hashtable(groups);
        for (int i = 0; i < groups; ++i) {
            String key = dr.readString();
            Vector value = dr.readVector();
            this.fGroupFiguresMap.put(key, value);
        }
        this.fBlock.addBlockNameChangedListener(this);
        if (null != this.fBlock.getParameter()) {
            this.fBlock.getParameter().addParameterSetListener(this);
        }
        if (null != this.fCommentParameter) {
            this.fCommentParameter.addParameterSetListener(this);
        }
        if (this.fCommentFigure != null && this.fCommentFigure.getConstraint().isDeleted()) {
            this.fCommentFigure = null;
        }
        this.fBlock.addPropertyChangeListener(this);
        this.layout();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Iterator figureIterator = this.fFigures.iterator();
        Figure f = null;
        while (figureIterator.hasNext()) {
            f = (Figure)figureIterator.next();
            if (!(f instanceof BlockIfcFigure)) continue;
            f.getConstraint().addBidirectionalLink(this.getConstraint());
        }
        if (null != this.fBlock.getParameter()) {
            this.fBlock.getParameter().addParameterSetListener(this);
            this.fBlock.addBlockNameChangedListener(this);
        }
        this.fBlock.addPropertyChangeListener(this);
        if (this.fCommentParameter != null) {
            this.fCommentParameter.addParameterSetListener(this);
        }
        if (this.blockFigureSerializedDataVersion < 3) {
            this.blockFigureSerializedDataVersion = 3;
            this.divideFiguresInGroups();
            ImageFigure imageFigure = this.getImageFigure();
            if (imageFigure instanceof PrintImageFigure) {
                ((PrintImageFigure)imageFigure).determinFigureDrawingData(this.fBlock);
            }
        }
        if (this.blockFigureSerializedDataVersion < 4) {
            this.blockFigureSerializedDataVersion = 4;
            if (!(this.fCCFigure instanceof ConnectorNameTextFigure)) {
                this.remove(this.fCCFigure);
                ConnectorNameTextFigure connectorNameTextFigure = new ConnectorNameTextFigure();
                connectorNameTextFigure.setText(this.fCCFigure.getText());
                this.fCCFigure = connectorNameTextFigure;
                this.add(this.fCCFigure, CONNECTOR_NAME_FIGURE_GROUP);
            }
        }
        if (this.blockFigureSerializedDataVersion < 6) {
            this.blockFigureSerializedDataVersion = 6;
            this.layout();
        }
    }

    protected void removedFromDrawing(Drawing drawing) {
        CommentManager commentManager = ((LogoDrawing)drawing).getCommentManager();
        this.fCommentParameter.removeParameterSetListener(this);
    }

    public void setBlockTextVisible(boolean newMode) {
        this.fBlockNumberIsVisible = newMode;
        this.invalidate();
        this.forceUpdate();
    }

    public void setCommentFigure(TextFigure commentFigure) {
    }

    public void setCommentFigure(CommentTextFigure commentFigure) {
        if (this.fCommentFigure == null) {
            this.fCommentFigure = commentFigure;
        } else {
            System.err.println("Comment figure existed.");
        }
    }

    public void setContainer(FigureContainer c) {
        if (c instanceof LogoDrawing) {
            this.insertedIntoDrawing((LogoDrawing)c);
        } else if (this.container() instanceof LogoDrawing) {
            this.removedFromDrawing((LogoDrawing)this.container());
        }
        super.setContainer(c);
    }

    public void setInputName() {
        LogoDrawing drawing = (LogoDrawing)this.drawing();
        if (drawing == null) {
            return;
        }
        String text = drawing.getInputNamesManager().getInputName(this.getBlock().getNumberString());
        if (text.length() > 0) {
            this.fCCFigure.setText("(" + text + ")");
        } else {
            this.fCCFigure.setText("");
        }
    }

    public void setParameterTextVisible(boolean newMode) {
        this.getParameterTextFigure().setVisible(newMode);
        this.fParameterTextIsVisible = newMode;
    }

    public String toString() {
        return super.toString() + ": " + this.fBlock + "; " + this.displayBox();
    }

    public void updateInputName(String newName) {
        this.invalidate();
        if (this.fCCFigure != null) {
            if (newName.length() > 0) {
                this.fCCFigure.setText("(" + newName + ")");
            } else {
                this.fCCFigure.setText("");
            }
        }
        this.invalidate();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        dw.writeBoolean(this.fParameterTextIsVisible);
        dw.writeBoolean(this.fBlockNumberIsVisible);
        dw.writeStorable(this.fBlock);
        dw.writeStorable(this.fCommentParameter);
        dw.writeStorable(this.fCommentFigure);
        dw.writeStorable(this.fCCFigure);
        Map groupFiguresMap = this.getGroupFiguresMap();
        dw.writeInt(groupFiguresMap.size());
        for (String key : groupFiguresMap.keySet()) {
            dw.writeString(key);
            dw.writeVector((Vector)groupFiguresMap.get(key));
        }
    }

    public void zoomChanged(int newZoom) {
        FigureEnumeration e = this.figures();
        while (e.hasMoreElements()) {
            Figure f = e.nextFigure();
            if (f instanceof ImageFigure) {
                Rectangle rect = f.displayBox();
                Point imagePoint = this.getBlock().getInConnectorCount() > 0 ? new Point(this.fDisplayBox100.x * newZoom / 100 + 6, this.fDisplayBox100.y * newZoom / 100) : new Point(this.fDisplayBox100.x * newZoom / 100, this.fDisplayBox100.y * newZoom / 100);
                int imageWidth = this.fImageWidth100 * newZoom / 100;
                int imageHeight = this.fImageHeight100 * newZoom / 100;
                f.basicDisplayBox(imagePoint, new Point(imagePoint.x + imageWidth, imagePoint.y + imageHeight));
                continue;
            }
            if (f instanceof BlockTextFigure) {
                BlockTextFigure bF = (BlockTextFigure)f;
                bF.zoomChanged(newZoom);
            }
            if (!(f instanceof ParameterTextFigure)) continue;
            ParameterTextFigure pF = (ParameterTextFigure)f;
            pF.setVisible(true);
            pF.zoomChanged(newZoom);
            pF.setVisible(this.fParameterTextIsVisible);
        }
        this.fDisplayBox.x = this.fDisplayBox100.x * newZoom / 100;
        this.fDisplayBox.y = this.fDisplayBox100.y * newZoom / 100;
        this.fDisplayBox.width = this.fDisplayBox100.width * newZoom / 100 + 1;
        this.fDisplayBox.height = this.fDisplayBox100.height * newZoom / 100 + 1;
        this.layout();
        this.invalidate();
    }

    public boolean canConnect() {
        return false;
    }

    public void add(Figure figure, String group) {
        Map figureGroupsMap = this.getGroupFiguresMap();
        Vector figuresInGroup = null;
        if (!figureGroupsMap.containsKey(group)) {
            figuresInGroup = new Vector(1);
            figureGroupsMap.put(group, figuresInGroup);
        } else {
            figuresInGroup = (Vector)figureGroupsMap.get(group);
        }
        figuresInGroup.add(figure);
        super.add(figure);
    }

    public void remove(Figure figure) {
        for (List currentGroup : this.getGroupFiguresMap().values()) {
            currentGroup.remove(figure);
        }
        super.remove(figure);
    }

    protected Map getGroupFiguresMap() {
        if (this.fGroupFiguresMap == null) {
            this.fGroupFiguresMap = new Hashtable(5);
        }
        return this.fGroupFiguresMap;
    }

    public Rectangle selectionBox() {
        return this.getImageFigure().displayBox();
    }

    public ArrayList getInputIfcFigures() {
        ArrayList<Figure> list = new ArrayList<Figure>();
        FigureEnumeration k = this.figures();
        Figure f = null;
        while (k.hasMoreElements()) {
            f = (Figure)k.nextElement();
            if (!(f instanceof InputIfcFigure)) continue;
            list.add(f);
        }
        return list;
    }

    public ArrayList getOutputIfcFigures() {
        ArrayList<Figure> list = new ArrayList<Figure>();
        FigureEnumeration k = this.figures();
        Figure f = null;
        while (k.hasMoreElements()) {
            f = (Figure)k.nextElement();
            if (!(f instanceof OutputIfcFigure)) continue;
            list.add(f);
        }
        return list;
    }
}

