/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.print.LogoPrintable;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ParameterPagePrinter
extends LogoPrintable
implements Printable {
    protected int fCurrentIndex = 0;
    Block[] fBlocksArr;
    int[] fIndexArr;
    int fParameterPages = -1;
    protected LogoDrawingView fLogoDrawingView;
    public Vector fBlocksToPrint;

    public ParameterPagePrinter(LogoDrawing logoDrawing, Vector blocksToPrint) {
        super(logoDrawing);
        this.fBlocksToPrint = blocksToPrint;
        this.fCurrentIndex = 0;
        this.fParameterPages = -1;
    }

    protected void fillBlocksArray() {
        boolean index = false;
        this.fBlocksArr = null;
        if (0 < this.fBlocksToPrint.size()) {
            this.fBlocksArr = new Block[this.fBlocksToPrint.size()];
            this.fBlocksToPrint.copyInto(this.fBlocksArr);
            this.fIndexArr = new int[this.fBlocksToPrint.size() + 1];
        }
        if (null != this.fBlocksArr) {
            Block.sortForBlockNumber(this.fBlocksArr);
        }
    }

    public void fillIndexArray(Graphics g, PageFormat pf) throws PrinterException {
        this.fParameterPages = 0;
        this.fCurrentIndex = 0;
        this.fillBlocksArray();
        if (null != this.fBlocksArr) {
            while (this.fCurrentIndex < this.fBlocksArr.length) {
                this.fIndexArr[this.fParameterPages] = this.fCurrentIndex;
                this.fCurrentIndex = this.printParameterPage(g, pf, this.fCurrentIndex);
                ++this.fParameterPages;
            }
            this.fIndexArr[this.fParameterPages] = -1;
        }
    }

    public int getPageCount(PageFormat pf, Graphics g) {
        try {
            this.fillIndexArray(g, pf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fParameterPages;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        pi -= this.fFirstPageNumber;
        if (this.fIndexArr == null) {
            this.fillIndexArray(g, pf);
        }
        if (pi >= this.fParameterPages) {
            return 1;
        }
        this.fCurrentIndex = this.fIndexArr[pi];
        g.setColor(Color.black);
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        Dimension printArea = this.printFooter(g, pf, pi + this.fFirstPageNumber + 1 + this.getPageNumberOffset(), 0);
        this.setClip(g, new Rectangle(1, 1, printArea.width, printArea.height), pf, false);
        if (null != this.fBlocksArr) {
            this.fCurrentIndex = this.printParameterPage(g, pf, this.fCurrentIndex);
        }
        g.translate(-((int)pf.getImageableX()), -((int)pf.getImageableY()));
        return 0;
    }

    protected int printParameterPage(Graphics g, PageFormat pf, int startIndex) {
        Dimension printArea = this.printFooter(g, pf, 0, 0);
        return this.printParameters(g, this.fBlocksArr, startIndex, printArea);
    }

    protected int printParameters(Graphics pg, Block[] blocks, int index, Dimension usableDimension) {
        int lineDiff = 15;
        int xPosBlock = 20;
        int xPosParameter = 315;
        int yPos = lineDiff;
        boolean pageFull = false;
        int currentIndex = index;
        String blockName = "";
        String comment = "";
        Vector subStringVector = null;
        Font ft = null;
        FontMetrics metrics = null;
        ft = new Font("Dialog", 1, 8);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        int textHeight = metrics.getHeight();
        pg.drawString(Language.getString("print.blocknumber", "Blocknumber(Type)"), xPosBlock, yPos);
        pg.drawString(Language.getString("print.parameter", "Parameter"), xPosParameter, yPos);
        pg.drawLine(0, yPos + lineDiff, usableDimension.width, yPos + lineDiff);
        pg.drawLine(0, yPos + lineDiff + 1, usableDimension.width, yPos + lineDiff + 1);
        yPos += lineDiff * 2;
        ft = new Font("monospaced", 0, 8);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        textHeight = metrics.getHeight();
        while (blocks.length > currentIndex && !pageFull) {
            int commentYPos = yPos;
            if (null != blocks[currentIndex].getParameter()) {
                String parameterString = blocks[currentIndex].getParameter().getParameterText();
                StringTokenizer tokenizer = new StringTokenizer(parameterString, "\n");
                if (yPos + tokenizer.countTokens() * textHeight + lineDiff > usableDimension.height) {
                    pageFull = true;
                }
                if (!pageFull) {
                    blockName = blocks[currentIndex].getNumberString();
                    CommentManager cManager = this.fDrawing.getCommentManager();
                    comment = cManager.getCommentParameter(blocks[currentIndex]).getText();
                    if (comment != null && comment.length() > 0 && yPos + (subStringVector = Util.createSubStrings(comment, metrics, xPosParameter - lineDiff - xPosBlock)).size() * textHeight + lineDiff > usableDimension.height) {
                        pageFull = true;
                    }
                }
                if (!pageFull) {
                    blockName = blockName + "(";
                    blockName = blockName + Language.getString(blocks[currentIndex].getLanguageKey(), blocks[currentIndex].getName());
                    blockName = blockName + ") : ";
                    pg.drawString(blockName, xPosBlock, yPos);
                    if (comment != null && comment.length() > 0) {
                        for (int i = 0; i < subStringVector.size(); ++i) {
                            pg.drawString((String)subStringVector.elementAt(i), xPosBlock, commentYPos += textHeight);
                        }
                    }
                    while (tokenizer.hasMoreTokens()) {
                        String subParameterString = tokenizer.nextToken();
                        pg.drawString(subParameterString, xPosParameter, yPos);
                        yPos += textHeight;
                    }
                    yPos -= textHeight;
                    yPos = Math.max(yPos, commentYPos);
                }
            }
            if (pageFull) continue;
            pg.drawLine(0, yPos + lineDiff, usableDimension.width, yPos + lineDiff);
            yPos += lineDiff * 2;
            ++currentIndex;
        }
        pg.drawLine(xPosParameter - lineDiff, 0, xPosParameter - lineDiff, yPos - lineDiff);
        return currentIndex;
    }
}

