/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app;

import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;

public class LogoHelp {
    String fHelpJarName;
    static String DEFAULT_HELP_FILE_NAME = "Help_en_US.jar";
    protected static LogoHelp cSingeltonInstanz = null;
    static String fHsName = null;
    static String fHsPath = null;
    static HelpSet fMainHelpSet = null;
    static HelpBroker fMainHelpBroker = null;
    protected static boolean fInstantHelp = false;
    protected static boolean fHelpAvailable = true;

    private LogoHelp() throws ProgramException {
        this.initialize();
        cSingeltonInstanz = this;
    }

    public static DefaultHelpBroker getHelpBroker() throws ProgramException {
        if (fMainHelpBroker == null) {
            LogoHelp.getInstance();
        }
        LogoProperties props = LogoProperties.instance();
        fMainHelpBroker.setSize(new Dimension(props.getIntProperty("helpWin.width", 1000), props.getIntProperty("helpWin.height", 800)));
        fMainHelpBroker.setLocation(new Point(props.getIntProperty("helpWin.posX", 0), props.getIntProperty("helpWin.posY", 0)));
        return (DefaultHelpBroker)fMainHelpBroker;
    }

    public static HelpSet getHelpSet() throws ProgramException {
        if (fMainHelpSet == null) {
            LogoHelp.getInstance();
        }
        return fMainHelpSet;
    }

    public static LogoHelp getInstance() throws ProgramException {
        if (cSingeltonInstanz == null) {
            if (fHelpAvailable) {
                try {
                    new LogoHelp();
                }
                catch (ProgramException e) {
                    fHelpAvailable = false;
                    throw e;
                }
            } else {
                throw new ProgramException();
            }
        }
        return cSingeltonInstanz;
    }

    protected URL[] getUrlArray(String url) {
        URL[] result = new URL[1];
        try {
            result[0] = new URL(url);
        }
        catch (Exception ex) {
            System.err.println("cannot create URL for " + url);
        }
        return result;
    }

    protected void initialize() throws ProgramException {
        this.fHelpJarName = "Help_" + Language.getLocale() + ".jar";
        this.loadHSFile();
        Object hs = null;
        String path = fHsPath;
        String name = fHsName;
        URL[] x = this.getUrlArray(path);
        URLClassLoader cl = new URLClassLoader(x);
        URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)name, (Locale)Language.getLocale());
        if (url != null) {
            try {
                fMainHelpSet = new HelpSet((ClassLoader)cl, url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ProgramException(Language.getString("error.couldNotCreateHS", "Could not create Helpset", this.fHelpJarName));
            }
        }
        fMainHelpBroker = fMainHelpSet.createHelpBroker();
        LogoProperties props = LogoProperties.instance();
        try {
            fMainHelpBroker.setSize(new Dimension(props.getIntProperty("helpWin.width", 640), props.getIntProperty("helpWin.height", 420)));
            fMainHelpBroker.setLocation(new Point(props.getIntProperty("helpWin.posX", 0), props.getIntProperty("helpWin.posY", 0)));
            fMainHelpBroker.setIconImage(Global.getImage("HelpContextIcon.gif"));
            fMainHelpBroker.setLocale(Language.getLocale());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ProgramException(Language.getString("error.couldNotCreateHS", "Could not create Helpset", this.fHelpJarName));
        }
    }

    public static boolean isAvailable() {
        boolean result;
        try {
            LogoHelp.getInstance();
            result = true;
        }
        catch (ProgramException e) {
            result = false;
        }
        return result;
    }

    public static boolean enableHelpOnButton(Component component, String helpID) {
        if (!LogoHelp.isAvailable()) {
            return false;
        }
        try {
            LogoHelp logoHelp = LogoHelp.getInstance();
            if (logoHelp.isInstantHelp()) {
                LogoHelp.getHelpBroker().enableHelpOnButton(component, helpID, null);
                return false;
            }
            return true;
        }
        catch (ProgramException programException) {
            programException.display(null, null);
            return false;
        }
    }

    public boolean isInstantHelp() {
        return LogoProperties.instance().getProperty("instantHelp", false);
    }

    protected void loadHSFile() throws ProgramException {
        String helpJarPath = "help/";
        File hsFile = new File("help/" + this.fHelpJarName);
        if (!(hsFile = new File(hsFile.getAbsolutePath())).exists()) {
            String fileName = LogoProperties.findFileInClassPath(this.fHelpJarName);
            if (fileName != null) {
                hsFile = new File(fileName);
            }
            if (!hsFile.exists()) {
                hsFile = new File("help/" + DEFAULT_HELP_FILE_NAME);
            }
            if (!hsFile.exists()) {
                Log.printStartSequence(Language.getString("msg.openFile", "Open Helpfile"));
                ProgramException e = new ProgramException(Language.getString("error.noHelpFile", "Helpfile % not found", this.fHelpJarName));
                e.setLog(Language.getString("error.noHelpFile", "Helpfile % not found", DEFAULT_HELP_FILE_NAME));
                throw e;
            }
            Log.printStartSequence(Language.getString("msg.openFile", "Open Helpfile"));
            this.fHelpJarName = DEFAULT_HELP_FILE_NAME;
        }
        String path = this.openHSFile(hsFile);
        try {
            fHsPath = new String(hsFile.getAbsoluteFile().toURL().toString());
        }
        catch (MalformedURLException mue) {
            Log.printStartSequence(Language.getString("msg.openFile", "Open Helpfile"));
            System.out.println(mue);
            fHsPath = "";
            throw new ProgramException(Language.getString("error.noHelpFile", "Helpfile % not found", path));
        }
    }

    protected String openHSFile(File hsFile) throws ProgramException {
        fHsName = hsFile.getName();
        String path = null;
        if (fHsName.endsWith(".jar")) {
            path = hsFile.getPath();
            fHsName = "";
            try {
                JarFile jar = new JarFile(hsFile);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".hs")) continue;
                    fHsName = entryName;
                }
            }
            catch (IOException ee) {
                System.out.println(path + " doesn't have an Helpset");
                throw new ProgramException(Language.getString("error.helpFileCorrupt", "Helpfile % is corrupt", path));
            }
        } else {
            System.out.println(fHsName + " Helpfile is no .jar-file");
            throw new ProgramException(Language.getString("error.helpFileCorrupt", "Helpfile % is corrupt", path));
        }
        return path;
    }
}

