/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.StandardDrawingView;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.InternApplicationSurface;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.StatusLine;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.WindowManager;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.BorderPanelPane;
import DE.siemens.ad.logo.app.comp.RolloverButtonToolBar;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.app.dialog.LookAndFeelPanel;
import DE.siemens.ad.logo.app.dialog.MDIManagerSelectionPanel;
import DE.siemens.ad.logo.app.dialog.OptionsPanel;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.Modem;
import DE.siemens.ad.logo.comm.VirtualDeviceDataTransfer;
import DE.siemens.ad.logo.dialog.AutoCutLinesPanel;
import DE.siemens.ad.logo.dialog.ColorOptionsPanel;
import DE.siemens.ad.logo.dialog.DisplayOptionsPanel;
import DE.siemens.ad.logo.dialog.GeneralOptionsPanel;
import DE.siemens.ad.logo.dialog.GridPanel;
import DE.siemens.ad.logo.dialog.PortSelectionPanel;
import DE.siemens.ad.logo.dialog.PrintOptionsPanel;
import DE.siemens.ad.logo.dialog.PropertyPanel;
import DE.siemens.ad.logo.dialog.SelectExportScopePanel;
import DE.siemens.ad.logo.dialog.SimulationOptionsPanel;
import DE.siemens.ad.logo.dialog.SimulationParameterPanel;
import DE.siemens.ad.logo.dialog.comp.MessageGlobalSettingPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HardwareChangedListener;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.LogoProm;
import DE.siemens.ad.logo.model.OptionProperties;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.ExportToSoft;
import DE.siemens.ad.logo.model.lgoExImport.Import;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoIOException;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.action.AutoCutLinesAction;
import DE.siemens.ad.pdraw.action.BlockToolAction;
import DE.siemens.ad.pdraw.action.SaveDrawingAction;
import DE.siemens.ad.pdraw.action.SelectLogoAction;
import DE.siemens.ad.pdraw.action.SelectionToolAction;
import DE.siemens.ad.pdraw.action.ShowMessageWindowAction;
import DE.siemens.ad.pdraw.action.SimulationToolAction;
import DE.siemens.ad.pdraw.action.ToolSelectionAction;
import DE.siemens.ad.pdraw.app.FupEditorInfo;
import DE.siemens.ad.pdraw.app.FupMenuManager;
import DE.siemens.ad.pdraw.app.print.LogoPrintBook;
import DE.siemens.ad.pdraw.app.print.LogoPrinter;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.PageLineFigure;
import DE.siemens.ad.pdraw.standard.ImageBlockTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.TreeImageBlockTool;
import DE.siemens.ad.pdraw.util.GridInfo;
import DE.siemens.ad.pdraw.util.GridPainter;
import DE.siemens.ad.pdraw.util.ImagePainter;
import DE.siemens.ad.pdraw.util.LayoutProducer;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import DE.siemens.ad.pdraw.util.PageLinePainter;
import DE.siemens.ad.pdraw.util.PrintPreview;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.sun.jimi.core.Jimi;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class LogoComfort
extends DrawApplication
implements Editor,
HardwareChangedListener {
    protected MenuManager fMenuManager;
    protected BorderPanelPane.BorderPanel fToolTreePanel;
    protected boolean fActivated;
    protected Application fApplication;
    protected Hardware fHardware;
    protected ActionManager fActionManager;
    protected ActionFactory fActionFactory;
    protected DrawingView fActiveView;
    protected ApplicationSurface fApplicationWindow;
    protected Vector fViews;
    protected BorderPanelPane.BorderPanel fLogWindow;
    private BlockToolAction[] fBlockToolActions;
    protected TreeImageBlockTool fTreeImageBlockTool;
    private int fProgressPoints;

    public void setActionManager(ActionManager actionManager) {
        this.fActionManager = actionManager;
    }

    public void activate(ApplicationSurface applicationWindow) {
        this.fActivated = true;
        this.fApplicationWindow = applicationWindow;
        WindowManager windowManager = applicationWindow.getWindowManager();
        if (!(applicationWindow instanceof InternApplicationSurface)) {
            this.fLogWindow = windowManager.getBorderPanel("Infowindow", "South", new Dimension(200, 100));
            this.fLogWindow.getBorderPanelPane().setFloatingBorderPanelAutoResized(false);
            if (this.fLogWindow.isNewlyCreated()) {
                Log.getInstance().initBorderPanel(this.fLogWindow);
            }
            ShowMessageWindowAction infoWindowAction = (ShowMessageWindowAction)this.getActionFactory().getAction("ShowMessageWindowAction");
            this.fLogWindow.addBorderPanelListener(infoWindowAction);
            infoWindowAction.setSelected(this.fLogWindow.isOpened());
            windowManager.getToolbarPanel("Standard", "North").add(this.fStandardToolBar);
            Log.getInstance().setEditor(this);
            ((LogoComfortStatusLine)this.fStatusLine).setModemStatus(Modem.getModemStatus());
        }
        if (this.fTreeImageBlockTool != null) {
            boolean doMinimize = false;
            int width = LogoProperties.instance().getIntProperty("blockTree.width", 160);
            if (width == 0) {
                width = 160;
                doMinimize = true;
            }
            this.fToolTreePanel = windowManager.getBorderPanel("toolTreePanel", "West", new Dimension(width, 200));
            if (doMinimize) {
                this.fToolTreePanel.setMinimized(true);
            }
            this.fToolTreePanel.removeAll();
            this.fToolTreePanel.getBorderPanelPane().setFloatingBorderPanelAutoResized(false);
            this.fToolTreePanel.setTitle(Language.getString("toolbar.title.tools", "Tools"));
            this.fToolTreePanel.setLayout(new BorderLayout());
            this.fToolTreePanel.add(new JScrollPane(this.fTreeImageBlockTool.getBlockTree()));
            this.fToolTreePanel.setClosable(false);
            this.fToolTreePanel.setMaximizable(false);
            this.fToolTreePanel.setToolbarPanel(this.fToolPalette);
            this.fToolPalette.setFloatable(false);
            this.fToolTreePanel.setImageIcon(Global.getIcon("Tool.gif"));
            this.fToolTreePanel.getBorderPanelPane().setFloatingBorderPanelAlwaysOnTop(true);
        } else {
            JComponent paletteContainer = windowManager.getToolbarPanel("Palette", "South");
            paletteContainer.add(this.fToolPalette);
        }
        if (this.fTool != null) {
            this.fTool.editorActivated(this);
        }
    }

    protected void addTools(JToolBar palette) {
        ActionFactory actionFactory = this.getActionManager().getActionFactory();
        RolloverButtonToolBar toolbar = (RolloverButtonToolBar)palette;
        toolbar.add((LogoToggleAction)actionFactory.getAction("SelectionToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("ConnectionToolAction"));
        BlockToolAction[] blockToolActions = this.getBlockToolActions();
        for (int i = 0; i < blockToolActions.length; ++i) {
            toolbar.add(blockToolActions[i]);
        }
        toolbar.add((LogoToggleAction)actionFactory.getAction("ConnectedTextToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("CutConnectToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("SimulationToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("OnlineTestToolAction"));
    }

    public void addView(View view) {
        if (!this.getViews().contains(view)) {
            this.getViews().add(view);
        }
    }

    public static boolean betaExpired() {
        boolean retValue = true;
        String version1 = LogoProperties.instance().getProperty("logo.bv1", "0");
        String version2 = LogoProperties.instance().getProperty("logo.bv2", "0");
        String version3 = LogoProperties.instance().getProperty("logo.bv3", "0");
        long actDate = new Date().getTime();
        try {
            File file;
            String filename;
            long v1 = Long.parseLong(version1);
            long v2 = Long.parseLong(version2);
            long v3 = Long.parseLong(version3);
            if (v2 == v1 / 1930L + 113L && actDate <= v1 && null != (filename = LogoProperties.findFileInClassPath("Application.ini")) && (file = new File(filename)).isFile() && v1 > file.lastModified() && v1 - actDate < v3 && v3 % 3491L == 0L) {
                retValue = false;
            }
            v3 = v1 - actDate;
            int rest = (int)(v3 % 3491L);
            LogoProperties.instance().setProperty("logo.bv3", String.valueOf(v3 += (long)(3491 - rest)));
            LogoProperties.instance().saveProperties();
        }
        catch (Exception e) {
            return retValue;
        }
        return retValue;
    }

    protected BlockToolAction[] createBlockToolActions() {
        BlockToolAction[] blockToolActions = null;
        if (this.fHardware == null) {
            blockToolActions = new BlockToolAction[]{};
            return blockToolActions;
        }
        BlockGroup rootBlockGroup = this.getBlockGroup();
        blockToolActions = new BlockToolAction[rootBlockGroup.getElementCount()];
        for (int i = 0; i < rootBlockGroup.getElementCount(); ++i) {
            BlockGroup blockGroup = (BlockGroup)rootBlockGroup.getElementAt(i);
            ImageBlockTool tool = new ImageBlockTool(blockGroup);
            BlockToolAction bta = (BlockToolAction)this.getActionFactory().getAction("BlockToolAction", "BlockToolAction" + i);
            bta.setIcon(blockGroup.getName() + "Icon");
            bta.setTextKey("block." + blockGroup.getName());
            bta.setDefaultText(blockGroup.getName());
            bta.setTool(tool);
            blockToolActions[i] = bta;
        }
        this.resetBlockToolTree(rootBlockGroup);
        return blockToolActions;
    }

    protected BlockGroup getBlockGroup() {
        WiringDiagram wiringDiagram = new WiringDiagram(this.fHardware);
        return wiringDiagram.getProgrammingLanguage().getAvailableBlockGroups(this.fHardware);
    }

    private void resetBlockToolTree(BlockGroup rootBlockGroup) {
        this.fTreeImageBlockTool = new TreeImageBlockTool(rootBlockGroup);
        JTree blockTree = this.fTreeImageBlockTool.getBlockTree();
        blockTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (LogoComfort.this.fTool != LogoComfort.this.fTreeImageBlockTool) {
                    LogoComfort.this.setTool(LogoComfort.this.fTreeImageBlockTool, Language.getString("tool.catalog", "Catalog"), new SimulationToolAction());
                }
            }
        });
    }

    protected Drawing createDrawing() {
        long start = System.currentTimeMillis();
        LogoDrawing ld = new LogoDrawing();
        this.setHardware(ld.getWiringDiagram().getHardware());
        return ld;
    }

    protected StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        LogoDrawingView view = new LogoDrawingView(this, d.width, d.height);
        CSH.setHelpIDString((Component)view, (String)"window.DrawingView");
        view.setBackground(Global.BACKGROUND_COLOR);
        if (Global.fun) {
            view.addBackground(new ImagePainter());
        }
        view.addBackground(new PageLinePainter());
        view.addBackground(new GridPainter(view.getGridInfo()));
        view.setAutoscrolls(true);
        return view;
    }

    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        this.addTools(palette);
    }

    public void deactivate() {
        this.fActivated = false;
        if (this.fTool != null) {
            this.fTool.editorDeactivated(this);
        }
    }

    public void determineLogo() {
        Log.printStartSequence("log.msg.checkResources", "Check Resources");
        this.displayInfoWiringDiagram();
    }

    public void displayDict(Dictionary ht) {
        Enumeration k = ht.keys();
        while (k.hasMoreElements()) {
            String key = (String)k.nextElement();
            Log.println(Language.getString(key, key));
            Vector v = (Vector)ht.get(key);
            int size = v.size();
            if (size <= 0) continue;
            for (int i = 0; i < size; ++i) {
                Log.println(((Block)v.elementAt(i)).getLocalizedName(true));
            }
        }
    }

    public void displayInfoWiringDiagram() {
        this.displayUsedRessources();
        Log.println("");
        this.displaySuitableHardware();
        WiringDiagram wd = ((LogoDrawing)this.drawing()).getWiringDiagram().getFup();
        this.displayDict(wd.getErrors());
        this.displayDict(wd.getWarnings());
    }

    public void displaySuitableHardware() {
        WiringDiagram wd = ((LogoDrawing)this.drawing()).getWiringDiagram();
        String[] hwNames = wd.getSuitableHardwareString(wd.getSuitableHardware(new ArrayList()));
        Log.println("log.msg.suitableHardware", "You can use the following Hardware:");
        String s = Language.getString("msg.minLogo", "Minimal LOGO! needed: ");
        if (hwNames.length > 0) {
            this.showStatus(s + hwNames[0]);
            for (int i = 0; i < hwNames.length; ++i) {
                Log.println(hwNames[i]);
            }
        } else {
            String noSuitableHardware = Language.getString("log.msg.noSuitableHardware", "No suitable hardware.");
            this.showStatus(noSuitableHardware);
            Log.println(noSuitableHardware);
        }
    }

    public void setHardware(Hardware newHardware) {
        if (this.fHardware != null && newHardware != null && this.fHardware.getName().equals(newHardware.getName())) {
            this.checkBlockAvailability();
            return;
        }
        this.fHardware = newHardware;
        long start = System.currentTimeMillis();
        this.reInitBlockTools(this.fToolPalette);
        if (this.fToolTreePanel != null) {
            this.fToolTreePanel.removeAll();
            this.fToolTreePanel.add(new JScrollPane(this.fTreeImageBlockTool.getBlockTree()));
        }
        this.checkBlockAvailability();
        this.setOnlineTestActivated(newHardware);
        this.setMessageRTFActivated(newHardware);
        ((LogoComfortStatusLine)this.getStatusLine()).setHardware(newHardware);
    }

    private void checkBlockAvailability() {
        LogoDrawing logoDrawing = (LogoDrawing)this.drawing();
        if (this.fTreeImageBlockTool != null && logoDrawing != null) {
            this.fTreeImageBlockTool.checkBlockAvailability(logoDrawing.getWiringDiagram());
        }
    }

    protected void setOnlineTestActivated(Hardware newHardware) {
        this.getActionFactory().getAction("OnlineTestToolAction").setActivated(newHardware.supports("onlineTest"));
    }

    protected void setMessageRTFActivated(Hardware newHardware) {
        this.getActionFactory().getAction("MessageGlobalSettingAction").setActivated(newHardware.supports("supportAsiaLanguage"));
    }

    public void displayUsedRessources() {
        WiringDiagram wd = ((LogoDrawing)this.drawing()).getWiringDiagram();
        Block[] maxStackBlocks = wd.getMaxStackDepthBlocks();
        Log.println("log.msg.usedResources", "Used Resources:");
        Log.print(wd.getResourceInfo());
        if (maxStackBlocks.length > 0) {
            Log.print(Language.getString("log.msg.log.maxStackBlock", "max. Stackdepth: "));
            Log.print(" " + maxStackBlocks[0].getNumberString());
            for (int i = 1; i < maxStackBlocks.length; ++i) {
                Log.print("-");
                Log.print(maxStackBlocks[i].getNumberString());
            }
            Log.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(ProgressListener progressListener) {
        WiringDiagram wd = ((LogoDrawing)this.drawing()).getWiringDiagram().getFup();
        DataTransfer dt = null;
        this.showStatus(Log.printStartSequence(Language.getString("msg.com.downloadTo", "PC-->LOGO!", Language.getString("hardware.family.name", "Device"))));
        this.displayDict(wd.getWarnings());
        try {
            Hashtable ht = wd.getErrors();
            if (ht.size() == 0) {
                dt = DataTransfer.openConnection(true);
                if (!dt.isTransmissionPossible(this.getApplicationSurface())) {
                    return;
                }
                int tmpDelay = LogoProperties.instance().getIntProperty("FW_RUNSTOP_READ_DELAY", -1);
                if (tmpDelay != -1 && tmpDelay > 0) {
                    Thread.sleep(tmpDelay);
                    System.out.println("Time delay:" + tmpDelay);
                }
                progressListener.setMinimum(0);
                progressListener.setMaximum(dt.getHardware().getNumberOfTransferBytes());
                progressListener.setValue(0);
                dt.addProgressListener(progressListener);
                progressListener.setVisible(true);
                wd.download(dt);
                this.showStatus(Language.getString("error.com.downloadOk", "Download successful"));
                Log.println("log.downloadOk", "*** Download succesful");
            } else {
                this.showStatus(Language.getString("error.com.downloadFailed", "Download failed"));
                this.displayDict(wd.getErrors());
                String error = Language.getString("error.com.downloadFailed", "Download failed");
                String msg = error + Language.getString("msg.seeMsgWindow", "\nDetails: See MessageWindow");
                new LogoError(this.getApplicationSurface().getWindow(), msg, msg, 0).display();
                Log.println(error);
            }
        }
        catch (ProgramException e) {
            e.setUser(Language.getString("error.com.downloadFailed", "Download failed"));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    e.display(LogoComfort.this.getApplicationSurface().getWindow(), LogoComfort.this.getStatusLine());
                }
            });
        }
        catch (ExceptionAlreadyHandledException e) {
        }
        catch (Exception e) {
            progressListener.setVisible(false);
            String s = Language.getString("error.com.downloadFailed", "Download failed");
            this.showStatus(s);
            Log.println(s);
            e.printStackTrace();
            final LogoError error = new LogoError(this.getApplicationSurface().getWindow(), s);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    error.display();
                }
            });
        }
        finally {
            if (dt != null) {
                dt.closePort();
            }
        }
    }

    public void editDrawingProperties() {
        PropertyPanel propertyPanel = new PropertyPanel((LogoDrawing)this.drawing());
        SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), propertyPanel, 11);
        dialog.show();
    }

    public void editMessageGlobalSetting() {
        MessageGlobalSettingPanel msgPanel = new MessageGlobalSettingPanel((LogoDrawing)this.drawing());
        msgPanel.activateParameterTab();
        SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), msgPanel, 11);
        dialog.show();
    }

    public void editDrawingParameter() {
        PropertyPanel propertyPanel = new PropertyPanel((LogoDrawing)this.drawing());
        propertyPanel.activateParameterTab();
        SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), propertyPanel, 11);
        dialog.show();
    }

    public void editOptionProperties() {
        OptionsPanel optionsPanel = new OptionsPanel();
        OptionProperties op = new OptionProperties();
        GeneralOptionsPanel gop = new GeneralOptionsPanel(op);
        optionsPanel.addPanel(gop);
        MDIManagerSelectionPanel mdimsp = new MDIManagerSelectionPanel(this.getApplication());
        optionsPanel.addPanel(mdimsp);
        DisplayOptionsPanel dop = new DisplayOptionsPanel(op);
        optionsPanel.addPanel(dop);
        PrintOptionsPanel printop = new PrintOptionsPanel(new LogoPrinter(this));
        optionsPanel.addPanel(printop);
        AutoCutLinesPanel aclp = new AutoCutLinesPanel();
        optionsPanel.addPanel(aclp);
        PortSelectionPanel psp = new PortSelectionPanel(op);
        optionsPanel.addPanel(psp);
        SimulationOptionsPanel sop = new SimulationOptionsPanel(op);
        optionsPanel.addPanel(sop);
        ColorOptionsPanel cop = new ColorOptionsPanel(op);
        optionsPanel.addPanel(cop);
        optionsPanel.addPanel(new LookAndFeelPanel());
        SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), optionsPanel, 11);
        dialog.show();
        if (this.getApplicationSurface() != null) {
            this.getApplicationSurface().repaint();
        }
    }

    public void editSimulationParameter() {
        LogoDrawing logoDrawing = (LogoDrawing)this.drawing();
        WiringDiagram wiringDiagram = logoDrawing.getWiringDiagram();
        SimulationParameterPanel simulationParameterPanel = new SimulationParameterPanel(wiringDiagram.getInputBlocks(), logoDrawing);
        SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), simulationParameterPanel, 11);
        dialog.show();
    }

    public void end() {
        this.deactivate();
        if (this.fTool != null) {
            this.fTool.deactivate(this.fView);
            this.fTool.editorEnded(this);
            this.fTool = null;
        }
        ShowMessageWindowAction messageWindowAction = (ShowMessageWindowAction)this.getActionFactory().getAction("ShowMessageWindowAction");
        this.fLogWindow.removeBorderPanelListener(messageWindowAction);
        LogoProperties.instance().setIntProperty("blockTree.width", this.fToolTreePanel.getWidth());
        if (this.fActionFactory != null) {
            this.fActionFactory.setOwner(null);
            this.fActionFactory = null;
        }
        this.fActiveView = null;
        this.fApplication = null;
        this.fActionManager = null;
        if (this.fBlockToolActions != null) {
            for (int i = 0; i < this.fBlockToolActions.length; ++i) {
                this.fBlockToolActions[i].setOwner(null);
                this.fBlockToolActions[i] = null;
            }
        }
        this.fHardware = null;
        this.fLogWindow = null;
        this.fMenuManager = null;
        this.fToolAction = null;
        this.fView = null;
        this.fTreeImageBlockTool = null;
    }

    protected void saveAsHex(File file) {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            WiringDiagram wd = ((LogoDrawing)this.drawing()).getWiringDiagram();
            Hardware hardware = wd.getHardware();
            VirtualDeviceDataTransfer dt = new VirtualDeviceDataTransfer();
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
                writer.write(Version.getCurrentVersion().toString());
                writer.newLine();
                writer.write(hardware.getName());
                writer.newLine();
                dt.writeHardwareID(hardware.getID() & 0xFF);
                wd.download(dt);
                dt.writeHexToWriter(writer);
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.getApplicationSurface(), e, "Error", 0);
            }
            outputStream.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    protected void finalize() throws Throwable {
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
        }
        return this.fActionFactory;
    }

    public ActionManager getActionManager() {
        if (this.fActionManager == null) {
            this.fActionManager = new ActionManager(this);
        }
        return this.fActionManager;
    }

    public Application getApplication() {
        return this.fApplication;
    }

    public ApplicationSurface getApplicationSurface() {
        return this.fApplicationWindow;
    }

    public BlockToolAction[] getBlockToolActions() {
        if (this.fBlockToolActions == null) {
            this.fBlockToolActions = this.createBlockToolActions();
        }
        return this.fBlockToolActions;
    }

    public EditorInfo getEditorInfo() {
        return new FupEditorInfo();
    }

    protected GridInfo getGridInfo() {
        return ((LogoDrawingView)this.view()).getGridInfo();
    }

    public MenuManager getMenuManager() {
        if (this.fMenuManager == null) {
            this.fMenuManager = new FupMenuManager(this);
        }
        return this.fMenuManager;
    }

    public StatusLine getStatusLine() {
        return this.fStatusLine;
    }

    public View getView() {
        return (View)((Object)this.view());
    }

    public List getViews() {
        if (this.fViews == null) {
            this.fViews = new Vector(2);
        }
        return this.fViews;
    }

    public Window getWindow() {
        if (this.view() != null) {
            Window wind = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, ((View)((Object)this.view())).getViewComponent());
            if (wind == null) {
                wind = this.getApplicationSurface().getWindow();
            }
            return wind;
        }
        return this.getApplicationSurface().getWindow();
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangeEvent) {
        Hardware newHardware = (Hardware)hardwareChangeEvent.getNewValue();
        this.getView().getModel().setModified(true);
        this.setHardware(newHardware);
    }

    protected boolean loadHexFile(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            reader.readLine();
            String hardwareName = reader.readLine();
            Hardware hardware = HardwareFactory.getInstance().createInstance(hardwareName);
            this.initDrawing();
            VirtualDeviceDataTransfer dt = new VirtualDeviceDataTransfer();
            dt.readHexFromReader(reader);
            reader.close();
            WiringDiagram wd = hardware.uploadProgram(dt);
            this.setWiringDiagram(wd);
            this.setHardware(wd.getHardware());
            LayoutProducer layoutProducer = new LayoutProducer(this.view(), wd.getBlocks());
            layoutProducer.layout();
            if (((LogoDrawing)this.drawing()).getOptionProperties().getSplitConnectionsOnImport()) {
                AutoCutLinesAction acla = new AutoCutLinesAction();
                acla.determinLinesAndSplit((LogoDrawing)this.fView.drawing(), this.fView);
            }
            this.setZoomValue(((LogoDrawingView)this.view()).getZoomManager().getZoom());
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getApplicationSurface(), e, "Error", 0);
            return false;
        }
    }

    public void init(Application application) {
        this.open();
        this.fApplication = application;
        this.getMenuManager().getMenuBar(application.getMenuActionGroup());
        this.fStandardToolBar = this.getMenuManager().getToolBar(application.getToolbarActionGroup());
    }

    public void initDrawing() {
        super.initDrawing();
        LogoDrawing logoDrawing = (LogoDrawing)this.drawing();
        logoDrawing.getWiringDiagram().addHardwareChangedListener(this);
        logoDrawing.setDefaultPage();
        logoDrawing.setModified(false);
    }

    protected boolean readFromImport(String file, ProgressListener progressListener) throws IOException {
        this.showStatus(Language.getString("msg.importLGO", "Import form LOGO!Soft..."));
        progressListener.setNote(Language.getString("log.convertData", "converting Data..."));
        Log.printStartSequence("log.msg.importLGO", "Importing from *.lgo");
        Log.print("log.msg.fileRead", "Reading file ");
        Log.println(" " + file);
        try {
            Import.createNewImport(file, progressListener);
            Import im = Import.getReferences();
            WiringDiagram wd = im.getImportedWD();
            this.showStatus(Language.getString("msg.importLGO", "Import form LOGO!Soft..."));
            Log.println("log.createDrawing", "Creating drawing...");
            this.initDrawing();
            LogoDrawing drawing = (LogoDrawing)this.drawing();
            this.setWiringDiagram(wd);
            this.setHardware(wd.getHardware());
            DrawingView view = this.view();
            Vector blocks = wd.getBlocks();
            progressListener.setNote(Language.getString("msg.loadMessage", "...loading Wiringdiagram"));
            LayoutProducer layoutProducer = new LayoutProducer(view, blocks);
            progressListener.setSubset(100, layoutProducer.getProgressSteps());
            layoutProducer.layout2(progressListener);
            if (((LogoDrawing)this.drawing()).getOptionProperties().getSplitConnectionsOnImport()) {
                AutoCutLinesAction acla = new AutoCutLinesAction();
                acla.determinLinesAndSplit((LogoDrawing)this.fView.drawing(), this.fView);
            }
            this.setZoomValue(((LogoDrawingView)this.view()).getZoomManager().getZoom());
            im.addIOPortComments(drawing);
            im.delReferences();
            return true;
        }
        catch (Exception e) {
            if (e instanceof ProgramException) {
                System.out.println(e.toString());
                System.out.println(((ProgramException)e).get("e"));
                String user = ((ProgramException)e).get("u");
                if (user.equals("")) {
                    Log.println("log.err.interpretingTmpFile", "ERROR: Interpreting Importfile failed");
                } else {
                    Log.println(user);
                }
            } else {
                Log.println("log.err.interpretingTmpFile", "ERROR: Interpreting Importfile failed");
            }
            Import.delReferences();
            throw new IOException();
        }
    }

    public View newDocument() {
        this.fView = this.createDrawingView();
        this.initDrawing();
        LogoDrawing logoDrawing = (LogoDrawing)this.drawing();
        ((LogoComfortStatusLine)this.fStatusLine).setHardware(logoDrawing.getWiringDiagram().getHardware());
        SaveDrawingAction saveDrawingAction = (SaveDrawingAction)this.getActionFactory().getAction("SaveDrawingAction");
        this.getView().getModel().addModelFileListener(saveDrawingAction);
        return this.getView();
    }

    protected boolean loadXmlFile(File file) {
        return false;
    }

    public void markAllFigures() {
        this.view().clearSelection();
        FigureEnumeration k = this.drawing().figures();
        Vector<Figure> figures = new Vector<Figure>();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (f instanceof PageLineFigure) continue;
            figures.addElement(f);
        }
        this.view().addToSelectionAll(figures);
        this.view().checkDamage();
    }

    protected void open() {
        super.open();
        this.fStatusLine = new LogoComfortStatusLine();
        SelectLogoAction selectLogoAction = (SelectLogoAction)this.getActionFactory().getAction("SelectLogoAction");
        ((LogoComfortStatusLine)this.fStatusLine).addHardwareClickedListener(selectLogoAction);
    }

    protected void saveAsLogosoftOutput2(String fileName) throws ProgramException {
        if (Version.getCurrentVersion().isDemoVersion()) {
            String s = Language.getString("msg.noExport", "No export of .lgo-file in the demoversion");
            throw new ProgramException(s);
        }
        LogoDrawing drawing = (LogoDrawing)this.drawing();
        WiringDiagram wd = drawing.getWiringDiagram().getFup();
        this.showStatus(Language.getString("msg.exportLGO", "Export to LOGO!Soft..."));
        Log.printStartSequence("msg.exportLGO", "Exporting to *.lgo");
        ExportToSoft export = null;
        try {
            ExportToSoft.createNewExport(drawing);
            export = ExportToSoft.getReferences();
            export.saveLgoFile(fileName);
            Log.print("msg.exportFile", "writing File");
            Log.println(" " + fileName);
            export.delReferences();
            String s = Language.getString("error.export.succesful", "Export succesful");
            Log.println(s);
            this.showStatus(s);
        }
        catch (Exception e) {
            if (e instanceof ProgramException) {
                export.delReferences();
                throw (ProgramException)e;
            }
            e.printStackTrace();
            String s = Language.getString("error.export.failed", "Export failed");
            export.delReferences();
            throw new ProgramException().setUser(s);
        }
    }

    public void printPreview() {
        PrintPreview.create(this, new LogoPrinter(this).getBook(), Language.getString("dialog.printPreview.title", "Printpreview"));
    }

    protected void reInitBlockTools(JToolBar palette) {
        this.toolDone();
        long start = System.currentTimeMillis();
        this.fBlockToolActions = null;
        if (palette == null) {
            palette = this.createToolPalette();
        } else {
            Component[] components = palette.getComponents();
            for (int i = 0; i < components.length; ++i) {
                palette.remove(components[i]);
            }
            ((RolloverButtonToolBar)palette).clearListenerRegistry();
        }
        this.createTools(palette);
    }

    public void removeView(View view) {
        this.getViews().remove(view);
    }

    public void saveDocument(File file, ProgressListener progressListener) throws IOException, FileNotFoundException, ProgramException {
        String lowerCaseFileName = file.getName().toLowerCase();
        if (lowerCaseFileName.endsWith(".hex")) {
            this.saveAsHex(file);
            return;
        }
        if (lowerCaseFileName.endsWith(".lsc")) {
            this.saveAsObjectOutput(file, progressListener);
            ((LogoDrawing)this.drawing()).setModified(false);
            return;
        }
        if (lowerCaseFileName.endsWith(".lgo")) {
            this.saveAsLogosoftOutput2(file.getPath());
            return;
        }
        if (lowerCaseFileName.endsWith(".pdf")) {
            this.saveAsPDF(file.getPath());
            return;
        }
        if (lowerCaseFileName.endsWith(".svg")) {
            this.saveAsSVG(file.getPath());
            return;
        }
        if (lowerCaseFileName.endsWith(".jpg") || lowerCaseFileName.endsWith(".bmp") || lowerCaseFileName.endsWith(".pcx")) {
            this.saveAsImage(file);
            return;
        }
        if (lowerCaseFileName.endsWith(".xml")) {
            this.saveAsXml(file);
            return;
        }
        this.saveAsObjectOutput(file, progressListener);
    }

    private void saveAsXml(File file) {
    }

    protected void saveAsImage(File file) throws IOException {
        LogoDrawingView view = (LogoDrawingView)this.view();
        int scope = 1;
        if (!view.selection().isEmpty()) {
            SelectExportScopePanel selectScopePanel = new SelectExportScopePanel();
            SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), selectScopePanel, 11);
            dialog.show();
            if (dialog.getControlPanel().getResult() == 2) {
                return;
            }
            scope = selectScopePanel.getScope();
        }
        Image image = null;
        if (scope == 0) {
            java.awt.Rectangle selectionBounds = view.getSelectionBounds();
            try {
                image = this.getApplicationSurface().createImage(selectionBounds.width, selectionBounds.height);
            }
            catch (OutOfMemoryError e) {
                this.showErrorMessage();
                return;
            }
            Graphics g = image.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, selectionBounds.width, selectionBounds.height);
            g.translate(-selectionBounds.x, -selectionBounds.y);
            view.drawSelection(g);
        } else {
            Dimension viewSize = ((LogoDrawing)this.drawing()).getViewSize100();
            try {
                image = this.getApplicationSurface().createImage(viewSize.width, viewSize.height);
            }
            catch (OutOfMemoryError e) {
                this.showErrorMessage();
                return;
            }
            Graphics g = image.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, viewSize.width, viewSize.height);
            view.drawing().draw(g);
        }
        try {
            Jimi.putImage((Image)image, (String)file.getPath());
        }
        catch (OutOfMemoryError oe) {
            this.showErrorMessage();
        }
        catch (Exception ie) {
            throw new IOException(ie.getMessage());
        }
    }

    protected void saveAsPDF(String fileName) throws IOException {
        LogoPrinter printer = new LogoPrinter(this);
        if (printer.showPrintScopeDialog() == 1) {
            try {
                Document document = new Document();
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
                writer.open();
                PdfContentByte content = writer.getDirectContent();
                DefaultFontMapper mapper = new DefaultFontMapper();
                PdfTemplate template = content.createTemplate(20.0f, 20.0f);
                Graphics2D graphics = template.createGraphics(20.0f, 20.0f, (FontMapper)mapper);
                mapper.insertDirectory("c:\\winnt\\fonts");
                LogoPrintBook book = printer.getBook(graphics);
                int count = book.getNumberOfPages();
                if (count > 0) {
                    document.setPageCount(count);
                    for (int index = 0; index < count; ++index) {
                        PageFormat format = book.getPageFormat(index);
                        float width = (float)format.getPaper().getWidth();
                        float height = (float)format.getPaper().getHeight();
                        Rectangle size = new Rectangle(0.0f, 0.0f, width, height);
                        if (format.getOrientation() == 0) {
                            size = size.rotate();
                        }
                        document.setPageSize(size);
                        document.newPage();
                        if (!document.isOpen()) {
                            document.open();
                        }
                        template = content.createTemplate(size.width(), size.height());
                        graphics = template.createGraphics(size.width(), size.height(), (FontMapper)mapper);
                        book.getPrintable(index).print(graphics, format, index);
                        graphics.dispose();
                        content.addTemplate(template, 0.0f, 0.0f);
                    }
                    if (document.isOpen()) {
                        document.close();
                    }
                } else {
                    document.open();
                    document.add((Element)new Paragraph("This Page Contains Absolutely Nothing!"));
                    document.close();
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void saveAsSVG(String fileName) throws IOException {
    }

    public void selectionChanged(DrawingView view) {
        ActionFactory actionFactory = this.getActionManager().getActionFactory();
        int selectedFigureCount = view.selectionCount();
        boolean greaterZero = selectedFigureCount > 0;
        actionFactory.getAction("CutAction").setActivated(greaterZero);
        actionFactory.getAction("CopyAction").setActivated(greaterZero);
        actionFactory.getAction("DeleteFiguresAction").setActivated(greaterZero);
        actionFactory.getAction("MarkedToFrontAction").setActivated(greaterZero);
        actionFactory.getAction("MarkedToBackAction").setActivated(greaterZero);
        boolean greaterOne = selectedFigureCount > 1;
        actionFactory.getAction("AlignBlocksAutomaticallyAction").setActivated(greaterOne);
        actionFactory.getAction("AlignHorizontalAction").setActivated(greaterOne);
        actionFactory.getAction("AlignVerticalAction").setActivated(greaterOne);
        actionFactory.getAction("SnapToGridAction").setActivated(greaterZero && this.getGridInfo().gridAttractionIsOn());
        boolean singleBlockSelection = selectedFigureCount == 1 && view.selection().elementAt(0) instanceof BlockFigure;
        actionFactory.getAction("EditBlockPropertiesAction").setActivated(singleBlockSelection);
    }

    public void setActiveView(DrawingView activeView) {
        this.fActiveView = activeView;
        ((LogoDrawingView)this.fActiveView).getZoomManager().activateDeactivateZoomActions();
        this.setZoomValue(((LogoDrawingView)activeView).getZoomManager().getZoom());
    }

    public void setApplication(Application application) {
        this.fApplication = application;
    }

    public void setApplicationSurface(ApplicationSurface applicationWindow) {
        this.fApplicationWindow = applicationWindow;
    }

    public void setLogWindowVisible(boolean visibility) {
        this.fLogWindow.setOpened(visibility);
    }

    public void setSimulationPaletteVisible(boolean visibility) {
        JComponent simulationPanel = this.getApplicationSurface().getWindowManager().getToolbarPanel("Simulation", "South");
        simulationPanel.setVisible(visibility);
        simulationPanel.invalidate();
    }

    public void setStandardToolBarVisible(boolean newValue) {
        this.fStandardToolBar.setVisible(newValue);
    }

    public void setTool(Tool t, String name, ToolSelectionAction toolSelectionAction) {
        this.getActionFactory().changeContext(t.getClass());
        super.setTool(t, name, toolSelectionAction);
        Iterator i = this.getViews().iterator();
        while (i.hasNext()) {
            ((LogoDrawingView)i.next()).setCursor(t.getCursor());
        }
    }

    public void setToolPaletteVisible(boolean newValue) {
        WindowManager windowManager = this.getApplicationSurface().getWindowManager();
        windowManager.getBorderPanel("toolTreePanel", "West").setOpened(newValue);
    }

    public void toggleGrid() {
        GridInfo gridInfo = this.getGridInfo();
        GridPanel gridPanel = new GridPanel(gridInfo);
        SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), gridPanel, 11);
        dialog.show();
        ((LogoDrawingView)this.getView()).setGridInfo(gridInfo);
        this.selectionChanged(this.view());
    }

    public void toolDone() {
        SelectionToolAction selectionToolAction = (SelectionToolAction)this.getActionManager().getActionFactory().getAction("SelectionToolAction");
        selectionToolAction.setSelected(true);
        selectionToolAction.doIt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WiringDiagram uploadWiringDiagram(ProgressListener progressListener) {
        Hardware hw = null;
        String hwName = "";
        WiringDiagram wd = null;
        DataTransfer dt = null;
        this.showStatus(Log.printStartSequence(Language.getString("msg.com.uploadFrom", "LOGO! --> ", Language.getString("hardware.family.name", "Device"))));
        try {
            dt = DataTransfer.openConnection(true);
            if (!dt.isTransmissionPossible(this.getApplicationSurface())) {
                WiringDiagram wiringDiagram = null;
                return wiringDiagram;
            }
            hw = dt.getHardware();
            if (hw.getName().equals("Unknown")) {
                new LogoError(this.getApplicationSurface(), "error.unknownHardwareWrongResult", "LOGO! unknown.\nResult may be wrong!", 2).display();
            }
            progressListener.setMinimum(0);
            int numberOfTransferBytes = hw.getNumberOfTransferBytes();
            this.fProgressPoints = (int)((float)numberOfTransferBytes * 0.2f);
            progressListener.setMaximum(numberOfTransferBytes + this.fProgressPoints);
            progressListener.setValue(0);
            dt.addProgressListener(progressListener);
            progressListener.setVisible(true);
            hwName = hw.getLocalizedPath() + hw.getLocalizedName();
            Log.println(hwName);
            if (hw instanceof LogoProm) {
                throw new ProgramException(Language.getString("error.prom.noUpload", "LOGO! Prom doesn't supported Upload "));
            }
            wd = hw.uploadProgram(dt);
            String s = Language.getString("error.com.uploadOk", "Upload successful", hwName);
            this.showStatus(s);
            Log.println(s);
        }
        catch (ProgramException e) {
            e.setUser(Language.getString("error.com.uploadFailed", "Upload failed"));
            Runnable r = new Runnable(){

                public void run() {
                    e.display(Application.getInstance().getWindow(), LogoComfort.this.getStatusLine());
                }
            };
            SwingUtilities.invokeLater(r);
            WiringDiagram wiringDiagram = null;
            return wiringDiagram;
        }
        catch (ExceptionAlreadyHandledException e) {
            WiringDiagram r = null;
            return r;
        }
        catch (Exception e) {
            String s = Language.getString("error.com.uploadFailed", "Upload failed");
            Log.println(s);
            this.showStatus(s);
            e.printStackTrace();
            WiringDiagram wiringDiagram = null;
            return wiringDiagram;
        }
        finally {
            if (dt != null) {
                dt.closePort();
            }
        }
        return wd;
    }

    public boolean checkDrawing() {
        return true;
    }

    public boolean upload(ProgressListener progressListener) {
        WiringDiagram wd = this.uploadWiringDiagram(progressListener);
        if (wd == null) {
            return false;
        }
        this.setWiringDiagram(wd);
        this.setHardware(wd.getHardware());
        progressListener.setSubset(100, 3);
        progressListener.setNote(Language.getString("upload.layout", "Layout..."));
        progressListener.increment(1);
        LayoutProducer layoutProducer = new LayoutProducer(this.view(), wd.getBlocks());
        layoutProducer.layout();
        if (((LogoDrawing)this.drawing()).getOptionProperties().getSplitConnectionsOnImport()) {
            progressListener.setNote(Language.getString("upload.splitConnection", "Split connections..."));
            progressListener.increment(2);
            AutoCutLinesAction acla = new AutoCutLinesAction();
            acla.determinLinesAndSplit((LogoDrawing)this.fView.drawing(), this.fView);
        }
        this.setZoomValue(((LogoDrawingView)this.view()).getZoomManager().getZoom());
        return true;
    }

    public DrawingView view() {
        if (this.fActiveView != null) {
            return this.fActiveView;
        }
        return this.fView;
    }

    public boolean isActivated() {
        return this.fActivated;
    }

    public void setWiringDiagram(WiringDiagram wiringDiagramFup) {
        LogoDrawing logoDrawing = (LogoDrawing)this.drawing();
        if (logoDrawing != null) {
            WiringDiagram oldWiringDiagram = logoDrawing.getWiringDiagram();
            if (oldWiringDiagram != null) {
                oldWiringDiagram.removeHardwareChangedListener(this);
            }
            logoDrawing.setWiringDiagram(wiringDiagramFup);
            this.setHardware(wiringDiagramFup.getHardware());
            wiringDiagramFup.addHardwareChangedListener(this);
        }
    }

    public View loadDocument(File file, ProgressListener progressListener) {
        try {
            this.fView = this.createDrawingView();
            boolean returnValue = true;
            if (file.getName().toLowerCase().endsWith(".xml")) {
                return this.loadXmlFile(file) ? (View)((Object)this.fView) : null;
            }
            if (file.getName().toLowerCase().endsWith(".hex")) {
                return this.loadHexFile(file) ? (View)((Object)this.fView) : null;
            }
            if (file.getName().toLowerCase().endsWith("lgo")) {
                if (Version.getCurrentVersion().isDemoVersion()) {
                    String s = Language.getString("msg.noImport", "No import of .lgo-file in the demoversion");
                    this.showStatus(s);
                    Log.println(s);
                    throw new LogoIOException("msg.accessDenied", s);
                }
                this.readFromImport(file.getPath(), progressListener);
            } else {
                String absoluteFilename = file.getAbsolutePath();
                this.loadDrawing(absoluteFilename, progressListener);
                this.drawing().setStorePath(absoluteFilename);
                ((LogoDrawing)this.drawing()).setModified(false);
                WiringDiagram wiringDiagram = ((LogoDrawing)this.drawing()).getWiringDiagram();
                wiringDiagram.addHardwareChangedListener(this);
                wiringDiagram.hardwareChanged(wiringDiagram.getHardware());
                this.showStatus(Language.getString("msg.readSuccessful", "Read successful"));
            }
            SaveDrawingAction saveDrawingAction = (SaveDrawingAction)this.getActionFactory().getAction("SaveDrawingAction");
            this.getView().getModel().addModelFileListener(saveDrawingAction);
            return (View)((Object)this.fView);
        }
        catch (LogoIOException e) {
            if (e.getType() == "msg.accessDenied") {
                new LogoError(this.getApplication().getActiveApplicationSurface(), e.getMessage()).display();
            } else {
                Object[] arr = new String[]{file.getPath()};
                new LogoError((Component)this.getApplication().getActiveApplicationSurface(), "error.openFile", "Loading " + file.getPath() + " failed", arr, 0, 0).display();
            }
            return null;
        }
        catch (IOException e) {
            Log.println(Language.getString("error.openFile", "Reading % failed", file));
            if (e instanceof StreamCorruptedException) {
                String s = Language.getString("msg.unknownFileType", "Unknown file content");
                this.showStatus(s);
                Log.println(s);
            } else if (e.getMessage() != null) {
                Log.println(e.getMessage());
            } else {
                Log.println(e.toString());
            }
            return null;
        }
    }

    public void endNew() {
        boolean showAtNewFile = false;
        try {
            showAtNewFile = LogoProperties.instance().getBooleanProperty("showPropertyOnNew", true);
        }
        catch (Exception nfe) {
            showAtNewFile = true;
        }
        if (showAtNewFile) {
            this.editDrawingProperties();
        }
    }

    private void showErrorMessage() {
        new LogoError(null, "error.dialog.tooLargeImage", "The image is too big.", 0).display();
    }
}

