/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.Enumeration;
import java.util.Vector;

public class MarkedToBackAction
extends UndoableAction {
    protected Vector selectedFigures = new Vector();
    protected Vector indicesOfFigures = new Vector();

    public MarkedToBackAction() {
        this.putValue("Name", "Marked to back");
        this.putValue("textKey", "edit.marktoback");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.marktoback", "markedToBack"));
    }

    public boolean doIt() {
        super.doIt();
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        Figure f = null;
        this.indicesOfFigures.removeAllElements();
        Enumeration selectedFiguresEnumeration = this.selectedFigures.elements();
        while (selectedFiguresEnumeration.hasMoreElements()) {
            f = (Figure)selectedFiguresEnumeration.nextElement();
            this.indicesOfFigures.add(new Integer(drawing.getIndexOfFigure(f)));
            drawing.sendToBack(f);
        }
        super.doIt();
        return true;
    }

    public boolean prepareAction() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        this.selectedFigures.removeAllElements();
        ReverseFigureEnumerator k = new ReverseFigureEnumerator(view.selectionZOrdered());
        while (k.hasMoreElements()) {
            this.selectedFigures.add(k.nextElement());
        }
        return true;
    }

    public void undoIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        for (int i = this.selectedFigures.size() - 1; i >= 0; --i) {
            drawing.setIndexOfFigure((Figure)this.selectedFigures.elementAt(i), (Integer)this.indicesOfFigures.elementAt(i));
        }
        view.checkDamage();
    }
}

