/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.BlockSelectionPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class GotoBlockAction
extends LogoAction
implements BlockSelectionPanel.BlockSelectionListener {
    protected BlockSelectionPanel blockSelectionPanel;
    protected SplittedDlg gotoBlockDialog;
    protected Block fBlock;

    public GotoBlockAction() {
        this.putValue("Name", "edit.gotoBlock");
        this.putValue("textKey", "edit.gotoBlock");
        this.putValue("SmallIcon", Global.getIcon("Goto.gif"));
    }

    public boolean prepareAction() {
        LogoDrawing drawing = (LogoDrawing)((LogoComfort)this.getOwner()).drawing();
        Vector blockVector = drawing.getWiringDiagram().getBlocks();
        if (this.gotoBlockDialog == null) {
            this.blockSelectionPanel = new BlockSelectionPanel((List)blockVector, drawing);
            this.gotoBlockDialog = SplittedDlg.create((JFrame)((LogoComfort)this.getOwner()).getWindow(), this.blockSelectionPanel, 11);
        }
        this.blockSelectionPanel.setBlocks(blockVector);
        this.gotoBlockDialog.requestFocus();
        this.blockSelectionPanel.requestFocus();
        this.blockSelectionPanel.setFocus();
        this.blockSelectionPanel.addBlockSelectionListener(this);
        this.gotoBlockDialog.show();
        this.blockSelectionPanel.removeBlockSelectionListener(this);
        this.fBlock = this.blockSelectionPanel.getSelectedBlock();
        return true;
    }

    public boolean doIt() {
        LogoDrawingView view = this.getDrawingView();
        LogoDrawing drawing = (LogoDrawing)((LogoComfort)this.getOwner()).drawing();
        BlockFigure blockFigure = ((LogoDrawing)((LogoComfort)this.getOwner()).drawing()).getBlockFigure(this.fBlock);
        if (blockFigure == null) {
            return false;
        }
        view.scrollToFigure(blockFigure);
        view.clearSelection();
        view.addToSelection(blockFigure);
        view.checkDamage();
        return true;
    }

    public void selectionGained(Block block) {
        LogoDrawingView view = this.getDrawingView();
        BlockFigure blockFigure = ((LogoDrawing)view.drawing()).getBlockFigure(this.blockSelectionPanel.getSelectedBlock());
        if (blockFigure == null) {
            return;
        }
        view.scrollToFigure(blockFigure);
        view.clearSelection();
        view.addToSelection(blockFigure);
        view.checkDamage();
    }

    public void selectionLost(Block block) {
    }
}

