/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.ParameterTabbedPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.util.Collections;
import java.util.Vector;

public class EditBlockPropertiesAction
extends LogoAction {
    protected Vector fParameters;
    protected Block fBlock;

    public EditBlockPropertiesAction() {
        this.putValue("Name", "editproperties");
        this.putValue("textKey", "edit.blockproperty");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.disabledContextVector = Collections.singletonList(OnlineTestTool.class);
    }

    public boolean doIt() {
        String old = this.fBlock.getNumberString();
        this.editBlockProperties(this.fBlock);
        if (!old.equals(this.fBlock.getNumberString())) {
            try {
                this.getOwner().getActionManager().deleteUndoBuffer();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.fBlock = null;
        return true;
    }

    public boolean prepareAction() {
        this.fBlock = null;
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        BlockFigure blockFigure = null;
        Vector selectedFigures = view.selection();
        for (int i = 0; i < selectedFigures.size(); ++i) {
            if (!(selectedFigures.elementAt(i) instanceof BlockFigure)) continue;
            blockFigure = (BlockFigure)selectedFigures.elementAt(i);
            break;
        }
        if (blockFigure != null) {
            this.fBlock = blockFigure.getBlock();
        }
        return this.fBlock != null;
    }

    public void editBlockProperties(Block block) {
        LogoComfort logoComfort = (LogoComfort)this.getOwner();
        boolean simulationOn = logoComfort.tool() instanceof SimulationTool;
        CommentManager commentManager = ((LogoDrawing)this.getDrawingView().drawing()).getCommentManager();
        ParameterTabbedPanel parameterTabbedPanel = new ParameterTabbedPanel(block, commentManager, simulationOn, (LogoDrawing)this.getDrawingView().getModel());
        int controlPanelMode = simulationOn ? 15 : 11;
        SplittedDlg dialog = SplittedDlg.create(logoComfort.getApplicationSurface().getWindow(), parameterTabbedPanel, controlPanelMode);
        dialog.setModal(!simulationOn);
        if (simulationOn) {
            ((SimulationTool)logoComfort.tool()).addOpenDialog(dialog);
        } else {
            dialog.setConsiderPreferedSize(true);
        }
        dialog.show();
        LogoDrawingView dv = (LogoDrawingView)logoComfort.view();
        if (dv != null) {
            dv.checkDamage();
        }
    }
}

