/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.CuttedConnectionConstraint;
import DE.siemens.ad.pdraw.standard.AdvancedConnectionSplitter;

public class CutLineAction
extends UndoableAction {
    protected int LABEL_RIGHT = 1;
    protected int LABEL_LEFT = -1;
    public FixedElbowConnection originalConnection;
    public CuttedConnectionConstraint cuttedConnectionConstraint;
    protected DrawingView view;

    public CutLineAction() {
        this.putValue("Name", "edit.cutLine");
        this.putValue("textKey", "edit.cutLine");
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.cutLine", "edit.cutLine"));
    }

    public boolean doIt() {
        this.getDrawingView().clearSelection();
        this.originalConnection.getConstraint().delete();
        this.cuttedConnectionConstraint.insert(this.getDrawingView().drawing());
        super.doIt();
        return true;
    }

    public CuttedConnectionConstraint getCuttedConnectionConstraint() {
        return this.cuttedConnectionConstraint;
    }

    public FixedElbowConnection getOriginalConnection() {
        return this.originalConnection;
    }

    public boolean prepareAction() {
        this.view = ((LogoComfort)this.getOwner()).view();
        Figure figure = (Figure)this.view.selection().elementAt(0);
        AdvancedConnectionSplitter splitter = new AdvancedConnectionSplitter();
        if (figure instanceof FixedElbowConnection) {
            this.originalConnection = (FixedElbowConnection)figure;
            if (((ConnectionConstraint)((Object)this.originalConnection.getConstraint())).getOutBlockConnector().getOwner().getName().equals("LeftPowerRail")) {
                this.view.clearSelection();
                return false;
            }
            this.cuttedConnectionConstraint = splitter.splittConnection(this.originalConnection, this.view);
            return true;
        }
        return false;
    }

    public void setCuttedConnectionConstraint(CuttedConnectionConstraint newConnectionConstraint) {
        this.cuttedConnectionConstraint = newConnectionConstraint;
    }

    public void setOriginalConnection(FixedElbowConnection newConnection) {
        this.originalConnection = newConnection;
    }

    public void undoIt() {
        this.cuttedConnectionConstraint.delete();
        this.originalConnection.getConstraint().undoDelete();
        this.getDrawingView().checkDamage();
    }
}

