/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import DE.siemens.ad.logo.app.action.CompositeUndoableAction;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.CopyAction;
import DE.siemens.ad.pdraw.action.DeleteFiguresAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.Vector;

public class CutAction
extends CompositeUndoableAction {
    public Block[] lastCutBlocks = new Block[0];

    public CutAction() {
        this.putValue("Name", "Ausschneiden");
        this.putValue("textKey", "edit.cut");
        this.putValue("SmallIcon", Global.getIcon("Cut.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.cut", "cut"));
        this.disabledContextVector = new Vector(2);
        this.disabledContextVector.add(SimulationTool.class);
        this.disabledContextVector.add(OnlineTestTool.class);
    }

    public boolean doIt() {
        LogoDrawing drawing = (LogoDrawing)((LogoComfort)this.getOwner()).drawing();
        WiringDiagram wiringDiagram = drawing.getWiringDiagram();
        try {
            wiringDiagram.releaseBlock(this.lastCutBlocks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fillLastCutBlocks();
        super.doIt();
        wiringDiagram.reserveBlock(this.lastCutBlocks);
        return true;
    }

    public void fillLastCutBlocks() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        Vector<Block> lastCutBlocksVector = new Vector<Block>();
        FigureEnumeration figures = view.selectionElements();
        boolean index = false;
        Figure f = null;
        while (figures.hasMoreElements()) {
            f = (Figure)figures.nextElement();
            if (!(f instanceof BlockFigure)) continue;
            lastCutBlocksVector.add(((BlockFigure)f).getBlock());
        }
        this.lastCutBlocks = new Block[lastCutBlocksVector.size()];
        lastCutBlocksVector.copyInto(this.lastCutBlocks);
    }

    public boolean prepareAction() {
        this.children = new Vector();
        CopyAction copyAction = new CopyAction();
        copyAction.setOwner(this.getOwner());
        copyAction.prepareAction();
        DeleteFiguresAction deleteAction = (DeleteFiguresAction)this.getOwner().getActionFactory().getAction("DeleteFiguresAction");
        deleteAction.setOwner(this.getOwner());
        deleteAction.prepareAction();
        this.children.add(copyAction);
        this.children.add(deleteAction);
        return true;
    }

    public void undoIt() {
        WiringDiagram wiringDiagram = ((LogoDrawing)((LogoComfort)this.getOwner()).drawing()).getWiringDiagram();
        super.undoIt();
        wiringDiagram.releaseBlock(this.lastCutBlocks);
    }
}

