/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class StateMachine
implements Runnable {
    private boolean fDebug = false;
    InputHandler fInputHandler;
    Hashtable fStateSingletonDictionary;
    List fFinalStates;
    Vector fInputQueue;
    State fStartState;
    State fCurrentState;
    private boolean fParallel;
    private int fParallelPriority = 5;
    private String fName;
    private List fStateChangedListeners;
    private boolean fRunning;

    public StateMachine(String name, State[] machineStates, State startState, List endStates, boolean parallel) {
        this.setStates(machineStates);
        this.fName = name;
        this.fStartState = startState;
        this.fFinalStates = endStates;
        this.fParallel = parallel;
        this.fInputQueue = new Vector();
    }

    public void start() {
        this.fRunning = true;
        this.fInputQueue.clear();
        if (this.isParallel()) {
            Thread t = new Thread((Runnable)this, this.fName);
            t.setPriority(this.fParallelPriority);
            t.start();
        } else {
            this.run();
        }
        if (this.fDebug) {
            System.out.println("StateMachine '" + this.fName + "' started.");
        }
    }

    public void run() {
        this.fRunning = true;
        this.fCurrentState = this.fStartState;
        this.fireStateChangedEvent(this.fCurrentState);
        Object input = null;
        while (!this.fFinalStates.contains(this.fCurrentState)) {
            input = this.fInputQueue.size() > 0 ? this.fInputQueue.remove(0) : null;
            State nextState = this.fInputHandler.handleInput(input, this.fCurrentState);
            if (nextState == null || !this.fStateSingletonDictionary.contains(nextState)) {
                throw new IllegalStateException("State " + this.fCurrentState + " returned illegal follow state " + nextState + " for Command " + input + ". " + nextState + " is not defined in StateMachine " + this.fName);
            }
            if (this.fDebug) {
                System.out.print("StateMachine: currentState=" + this.getClassNameShort(this.fCurrentState));
            }
            if (this.fDebug) {
                System.out.print("; input=" + input);
            }
            if (this.fDebug) {
                System.out.println("; follow state=" + this.getClassNameShort(nextState));
            }
            if (nextState != this.fCurrentState) {
                this.fCurrentState = nextState;
                this.fireStateChangedEvent(nextState);
            }
            if (!this.fParallel) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fRunning = false;
        if (this.fDebug) {
            System.out.println("StateMachine '" + this.fName + "' TERMINATED. state=" + this.fCurrentState);
        }
    }

    public List getStates() {
        return new ArrayList(this.fStateSingletonDictionary.values());
    }

    public void setStates(State[] states) {
        this.fStateSingletonDictionary = new Hashtable(10);
        for (int i = 0; i < states.length; ++i) {
            State state = states[i];
            state.setStateMachine(this);
            this.fStateSingletonDictionary.put(state.getClass(), state);
        }
    }

    public List getFinalStates() {
        return this.fFinalStates;
    }

    public void setFinalStates(List endStates) {
        this.fFinalStates = endStates;
    }

    public boolean isParallel() {
        return this.fParallel;
    }

    public void setParallel(boolean parallel) {
        this.fParallel = parallel;
    }

    public State getState(Class stateClass) {
        if (!this.fStateSingletonDictionary.containsKey(stateClass)) {
            throw new IllegalArgumentException("The state '" + stateClass + "' is no valid state for the state machine '" + this.fName + "'");
        }
        return (State)this.fStateSingletonDictionary.get(stateClass);
    }

    public InputHandler getInputHandler() {
        return this.fInputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.fInputHandler = inputHandler;
    }

    public void addInput(Object inputSymbol) {
        this.fInputQueue.add(inputSymbol);
    }

    public State getCurrentState() {
        return this.fCurrentState;
    }

    public List getStateChangedListeners() {
        if (this.fStateChangedListeners == null) {
            this.fStateChangedListeners = new ArrayList(3);
        }
        return this.fStateChangedListeners;
    }

    public void addStateChangedListener(StateChangedListener stateChangedListener) {
        if (!this.getStateChangedListeners().contains(stateChangedListener)) {
            this.getStateChangedListeners().add(stateChangedListener);
        }
    }

    public void removeStateChangedListener(StateChangedListener stateChangedListener) {
        this.getStateChangedListeners().remove(stateChangedListener);
    }

    public void fireStateChangedEvent(State newState) {
        long start = System.currentTimeMillis();
        for (StateChangedListener listener : new ArrayList(this.getStateChangedListeners())) {
            if (this.fFinalStates.contains(newState)) {
                listener.finalStateReached(this, newState);
                continue;
            }
            listener.stateChanged(this, newState);
        }
        if (this.fDebug) {
            System.out.println("StateMachine: listener notification took " + (System.currentTimeMillis() - start));
        }
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public boolean isRunning() {
        return this.fRunning;
    }

    private String getClassNameShort(State state) {
        String className = state.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot);
        }
        return className;
    }

    public State getStartState() {
        return this.fStartState;
    }

    public void setStartState(State startState) {
        if (!this.fStateSingletonDictionary.values().contains(startState)) {
            throw new IllegalArgumentException("The passes start-state" + startState + " is not contained the collection" + "of states!");
        }
        this.fStartState = startState;
    }

    public boolean isDebug() {
        return this.fDebug;
    }

    public void setDebug(boolean b) {
        this.fDebug = b;
    }

    public int getParallelPriority() {
        return this.fParallelPriority;
    }

    public void setParallelPriority(int priority) {
        this.fParallelPriority = priority;
    }

    public static abstract class State {
        private StateMachine fStateMachine;

        public void setStateMachine(StateMachine stateMachine) {
            this.fStateMachine = stateMachine;
        }

        protected void sleep(long milliseconds) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public StateMachine getStateMachine() {
            return this.fStateMachine;
        }

        public State getState(Class stateClass) {
            return this.fStateMachine.getState(stateClass);
        }
    }

    public static abstract class InputHandler {
        public abstract Object[] getInputSymbols();

        public abstract State handleInput(Object var1, State var2);
    }

    public static interface StateChangedListener {
        public void stateChanged(StateMachine var1, State var2);

        public void finalStateReached(StateMachine var1, State var2);
    }
}

