/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ScalableMouseEvent
extends MouseEvent {
    private int fX;
    private int fY;
    private int fUnscaledX;
    private int fUnscaledY;

    public ScalableMouseEvent(MouseEvent me) {
        super((Component)me.getSource(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
        this.fX = this.fUnscaledX = me.getX();
        this.fY = this.fUnscaledY = me.getY();
    }

    public ScalableMouseEvent(MouseEvent me, int zoom) {
        this(me);
        this.scale(zoom);
    }

    public Point getPoint() {
        return new Point(this.fX, this.fY);
    }

    public Point getUnscaledPoint() {
        return new Point(this.fUnscaledX, this.fUnscaledY);
    }

    public int getUnscaledX() {
        return this.fUnscaledX;
    }

    public int getUnscaledY() {
        return this.fUnscaledY;
    }

    public int getX() {
        return this.fX;
    }

    public int getY() {
        return this.fY;
    }

    public void scale(double scale) {
        this.fX = (int)((double)this.fX * (1.0 / scale));
        this.fY = (int)((double)this.fY * (1.0 / scale));
    }

    public void scale(int zoom) {
        double scale = (double)zoom / 100.0;
        this.fX = (int)((double)this.fX * (1.0 / scale));
        this.fY = (int)((double)this.fY * (1.0 / scale));
    }
}

