/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo0;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory8;
import DE.siemens.ad.logo.util.MemoryEnumeration;

public class ProgramMemory8
extends Memory8 {
    Block[] fBlockObjArr = null;

    public boolean isChecksumRelevant() {
        return true;
    }

    public void createReferences(CompilerFromLogo compiler) {
        int lineCount = 0;
        boolean blockOffset = false;
        int blockSize = this.getBlockSize();
        int ref = 0;
        MemoryEnumeration memoryEnum = this.elements();
        while (memoryEnum.hasMoreElements()) {
            int[] line = memoryEnum.nextBlock();
            if (CompilerFromLogo.isOpcode(line[0])) {
                for (int column = 1; column < blockSize; ++column) {
                    try {
                        ref = line[column];
                        if (!CompilerFromLogo.isReference(ref)) continue;
                        ((CompilerFromLogo0)compiler).setReference(this.getBlock(lineCount, column), ref, this.getInputNumber(column));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Log.println("Error creating references: " + e.getMessage());
                        new LogoError(e.getMessage()).display();
                    }
                }
            }
            ++lineCount;
        }
    }

    protected ProgramMemory8() {
    }

    public ProgramMemory8(int transferOffsetAdr, int memorySize) throws IllegalArgumentException {
        this("Program", transferOffsetAdr, memorySize, 5);
        this.fBlockObjArr = new Block[memorySize];
    }

    public ProgramMemory8(String name, int transferOffsetAdr, int memorySize) throws IllegalArgumentException {
        this(name, transferOffsetAdr, memorySize, 5);
        this.fBlockObjArr = new Block[memorySize];
    }

    protected ProgramMemory8(String name, int transferOffsetAdress, int memorySize, int blockSize) throws IllegalArgumentException {
        super(name, transferOffsetAdress, memorySize, blockSize);
    }

    public void createBlocks(WiringDiagram wd, CompilerFromLogo compiler) {
        int opcode = 0;
        int size = this.size();
        for (int programLine = 0; programLine < size; ++programLine) {
            opcode = this.fMemory[programLine][0];
            if (!CompilerFromLogo.isOpcode(opcode)) continue;
            try {
                this.fBlockObjArr[programLine] = wd.createBlock(opcode, programLine + 1);
                continue;
            }
            catch (IllegalArgumentException e) {
                String s = "Block in Programmzeile " + programLine + " mit Opcode " + this.fMemory[programLine][0] + " nicht gefunden";
                Log.error(e, s);
                Log.println(s);
            }
        }
    }

    public Block getBlock(int blockNumber) throws IllegalArgumentException {
        Block retValue = null;
        try {
            retValue = this.fBlockObjArr[blockNumber - 1];
        }
        catch (IndexOutOfBoundsException e) {
            String err = this.fBlockObjArr.length == 0 ? Language.getString("error.util.anchorMemory.block", "No Blocks created") : Language.getString("error.util.blockNumber", "BlockNumber ") + blockNumber + Language.getString("error.util.anchorMemory.greater", "is greater than ") + this.fBlockObjArr.length;
            throw new IllegalArgumentException(err);
        }
        if (retValue == null) {
            throw new IllegalArgumentException(Language.getString("error.util.programMemory.noBlockCreated", "ProgramMemory: Block doesn't exist") + "(Blocknumber: " + blockNumber + ")");
        }
        return retValue;
    }

    public Block getBlock(int line, int column) throws IllegalArgumentException {
        Block retValue = null;
        try {
            retValue = this.fBlockObjArr[line];
        }
        catch (IndexOutOfBoundsException e) {
            String err = this.fBlockObjArr.length == 0 ? Language.getString("error.util.programMemory.block", "ProgramMemory: No BlockArray created") : Language.getString("error.util.programMemory.line", "ProgramMemory: LineNumber ") + line + Language.getString("error.util.anchorMemory.greater", "is greater than ") + this.fBlockObjArr.length;
            throw new IllegalArgumentException(err);
        }
        if (retValue == null) {
            throw new IllegalArgumentException(Language.getString("error.util.programMemory.noBlockCreated", "ProgramMemory: Block doesn't exist") + "(line: " + line + " column: " + column + ")");
        }
        return retValue;
    }

    public int getInputNumber(int column) {
        return column - 1;
    }

    public Memory init() {
        this.init(255);
        this.fBlockIndex = 0;
        this.fByteIndex = 0;
        return this;
    }
}

