/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.MemoryEnumeration;

public class ProgramMemory16
extends Memory16 {
    Block[] fBlockObjArr = null;

    public ProgramMemory16() {
    }

    public ProgramMemory16(int memorySize, int blockSize) throws IllegalArgumentException {
        super(memorySize, blockSize);
    }

    public ProgramMemory16(String name, int startAdresse, int memorySize, int blockSize) {
        super(name, startAdresse, memorySize, blockSize);
    }

    public boolean isChecksumRelevant() {
        return true;
    }

    public String toString(int startLine) {
        StringBuffer buffer = new StringBuffer();
        MemoryEnumeration enumeration = this.elements();
        String hexString = "";
        boolean i = false;
        boolean bufPos = false;
        int byteIdx = 0;
        int lineLength = 0;
        int adress = 200;
        while (enumeration.hasMoreElements()) {
            byte memByte = enumeration.nextByte();
            if (byteIdx == lineLength) {
                byteIdx = 0;
                buffer.append("\n");
                String adr = Integer.toHexString(adress += lineLength).toUpperCase();
                if (adr.length() < 3) {
                    buffer.append("0");
                }
                buffer.append(adr).append(":\t");
                lineLength = this.getProgramLineLength(memByte);
            }
            if ((hexString = Integer.toHexString(memByte & 0xFF).toUpperCase()).length() == 1) {
                buffer.append("0");
            }
            buffer.append(hexString);
            if (byteIdx < lineLength - 1) {
                buffer.append(", ");
            }
            ++byteIdx;
        }
        return buffer.toString();
    }

    protected int getProgramLineLength(int opcode) {
        switch (opcode &= 0xFF) {
            case 128: {
                return 20;
            }
            case 0: {
                return 20;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 12;
            }
            case 33: {
                return 8;
            }
            case 34: {
                return 12;
            }
            case 35: {
                return 12;
            }
            case 36: {
                return 20;
            }
            case 37: {
                return 8;
            }
            case 39: {
                return 12;
            }
            case 41: {
                return 28;
            }
            case 42: {
                return 8;
            }
            case 43: {
                return 28;
            }
            case 44: {
                return 16;
            }
            case 45: {
                return 12;
            }
            case 46: {
                return 12;
            }
            case 47: {
                return 12;
            }
            case 48: {
                return 12;
            }
            case 49: {
                return 12;
            }
            case 50: {
                return 16;
            }
            case 51: {
                return 16;
            }
            case 52: {
                return 8;
            }
            case 53: {
                return 16;
            }
            case 54: {
                return 24;
            }
            case 55: {
                return 8;
            }
            case 56: {
                return 12;
            }
            case 57: {
                return 20;
            }
            case 58: {
                return 16;
            }
            case 64: {
                return 20;
            }
            case 65: {
                return 36;
            }
            case 66: {
                return 12;
            }
            case 67: {
                return 40;
            }
            case 59: {
                return 24;
            }
            case 68: {
                return 20;
            }
            case 60: {
                return 12;
            }
            case 255: {
                return 20;
            }
        }
        System.err.println("ProgramMemory16.getProgLineLength: Unbekannter Opcode: " + opcode);
        return 20;
    }
}

