/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.MessageMemory8;

public class MessageMemoryRTF
extends MessageMemory8 {
    protected static final int SUB_MEMORIES_COUNT = 16;
    public static final int MAX_MSG_COUNT = 50;
    protected static final String MASS_COLLECTION = "Current character set";
    protected static final String MESSAGE_OFFSET = "Message offset table";
    protected static final String MESSAGE_TEXT = "Message text";
    protected static final String MESSAGE_INFO = "Message info";
    protected static final String TICKER_FLAG = "Message Line tick flag";
    protected static final String REF_PAR = "Parameter and actual value";
    protected static final String BAR_GRAPH = "Graphic bar";
    protected static final String IO_OFFSET = "I/O offset table";
    protected static final String IO_STATUS_NAME = "IO names";
    protected static final String FREE_ID = "Free message name id";
    protected Memory[] fMemories;
    protected final int fMessageCount;
    public transient boolean fGlobalSettingFinished = false;

    public MessageMemoryRTF(String name, int startAddress, int messageCount) {
        super(name, 0, 1, 1);
        this.fMessageCount = messageCount;
        this.initSubMemories(startAddress);
    }

    protected void initSubMemories(int startAddress) {
        this.fMemories = new Memory[16];
        int i = 0;
        int subStartAddress = startAddress;
        this.fMemories[i++] = new Memory(MASS_COLLECTION, subStartAddress, 6, 1);
        this.fMemories[i++] = new Memory(MESSAGE_OFFSET, subStartAddress += 6, 100, 1);
        this.fMemories[i++] = new MessageMemory8(MESSAGE_TEXT, subStartAddress += 128, 200, 32);
        subStartAddress += 8192;
        this.fMemories[i++] = new Memory(MESSAGE_INFO, subStartAddress += 8, 50, 1);
        this.fMemories[i++] = new Memory(TICKER_FLAG, subStartAddress += 64, 25, 1);
        subStartAddress += 32;
        this.fMemories[i++] = new Memory(BAR_GRAPH, subStartAddress += 128, 32, 8);
        this.fMemories[i++] = new Memory(IO_OFFSET, subStartAddress += 256, 20, 1);
        this.fMemories[i++] = new Memory(IO_STATUS_NAME, subStartAddress += 20, 40, 16);
        subStartAddress += 640;
        while (i < 16) {
            this.fMemories[i] = new Memory(FREE_ID, 0, 1, 1);
            ++i;
        }
    }

    public void setAllByteAtOnce(boolean allByteAtOnce) {
        this.fAllByteAtOnce = allByteAtOnce;
        for (int i = 0; i < this.fMemories.length; ++i) {
            if (!(this.fMemories[i] instanceof MessageMemory8)) continue;
            ((MessageMemory8)this.fMemories[i]).setAllByteAtOnce(allByteAtOnce);
        }
    }

    protected Memory getMemory(String name) {
        int i = 0;
        while (this.fMemories[i].getName() != name) {
            ++i;
        }
        if (i == this.fMemories.length) {
            return null;
        }
        return this.fMemories[i];
    }

    public Memory init() {
        for (int i = 0; i < this.fMemories.length; ++i) {
            this.fMemories[i].init(255);
        }
        this.fGlobalSettingFinished = false;
        return this;
    }

    public void upload(DataTransfer dt, boolean fastUpload) throws TransmissionFailedException {
        for (int i = 0; i < this.fMemories.length; ++i) {
            if (this.fMemories[i].getName().equals(MESSAGE_TEXT) && fastUpload) {
                this.fastUploadMessageText(dt);
                int savedBytes = this.fMemories[i].getBlockSize() * this.fMemories[i].size() - this.getFastUploadBytes();
                if (dt.getProgressListener() == null) continue;
                dt.getProgressListener().setMaximum(dt.getHardware().getNumberOfTransferBytes() - savedBytes);
                continue;
            }
            if (this.fMemories[i].getName().equals(FREE_ID)) continue;
            this.fMemories[i].upload(dt);
        }
    }

    public void fastUploadMessageText(DataTransfer dt) throws TransmissionFailedException {
        int size;
        MessageMemory8 msgText = (MessageMemory8)this.getMemory(MESSAGE_TEXT);
        Memory msgOffset = this.getMessageOffsetMemory();
        msgText.init(255);
        int textSize = msgText.getBlockSize() * 4;
        for (int pointer = 0; pointer < msgOffset.size() / 2; pointer += size) {
            if ((pointer = this.getNextValidTextID(pointer)) == -1) {
                return;
            }
            size = this.getThisStepIndex(pointer) - pointer + 1;
            int[] data = null;
            data = dt.readByteArray(msgText.fTansferStartAdress + pointer * textSize, size * textSize);
            msgText.setPosition(pointer * textSize);
            for (int k = 0; k < data.length; ++k) {
                msgText.put(data[k]);
            }
            System.out.println("Point: " + pointer + ", size" + size);
        }
    }

    public int getFastUploadBytes() {
        int textSize = this.getMemory(MESSAGE_TEXT).getBlockSize() * 4;
        int textCount = this.getMessageOffsetMemory().size() / 2;
        int wholeBytes = 0;
        int pointer = 0;
        while (pointer < textCount && (pointer = this.getNextValidTextID(pointer)) != -1) {
            int size = this.getThisStepIndex(pointer) - pointer + 1;
            wholeBytes += (pointer += size) * textSize;
        }
        return wholeBytes;
    }

    private int getThisStepIndex(int start) {
        int next;
        Memory msgOffset = this.getMessageOffsetMemory();
        int connectCost = 3;
        int pos = start;
        while (pos - start + 1 < msgOffset.size() / 2 && (next = this.getNextValidTextID(pos + 1)) != -1 && next - pos <= 3) {
            pos = next;
        }
        return pos;
    }

    private int getNextValidTextID(int start) {
        Memory msgOffset = this.getMessageOffsetMemory();
        for (int i = start; i < msgOffset.size() / 2; ++i) {
            if (msgOffset.get(i * 2) == 255) continue;
            return i;
        }
        return -1;
    }

    public void upload(DataTransfer dt) throws TransmissionFailedException {
        this.upload(dt, false);
    }

    public void download(DataTransfer dt) throws TransmissionFailedException {
        this.download(dt, false);
    }

    public void download(DataTransfer dt, boolean fastDownload) throws TransmissionFailedException {
        for (int i = 0; i < this.fMemories.length; ++i) {
            if (this.fMemories[i].getName().equals(FREE_ID)) continue;
            this.fMemories[i].download(dt, fastDownload && this.isFastDownloadSupported(this.fMemories[i]));
        }
    }

    private boolean isFastDownloadSupported(Memory mem) {
        return !mem.getName().equals(MESSAGE_INFO) && !mem.getName().equals(TICKER_FLAG);
    }

    public int getFastDownloadBytesCount() {
        int ret = 0;
        for (int i = 0; i < this.fMemories.length; ++i) {
            if (this.fMemories[i].getName().equals(FREE_ID)) continue;
            if (this.isFastDownloadSupported(this.fMemories[i])) {
                ret += this.fMemories[i].getFastDownloadBytesCount();
                continue;
            }
            ret += this.fMemories[i].getBlockSize() * this.fMemories[i].size();
        }
        return ret;
    }

    public void createBlocks(WiringDiagram wd, CompilerFromLogo compiler) {
    }

    public int putMemoryBlock(int[] memoryBlock) throws IndexOutOfBoundsException {
        return super.putMemoryBlock(memoryBlock);
    }

    public boolean setCharacterSetCur(int characterSetID) {
        this.getMemory(MASS_COLLECTION).setPosition(0);
        this.getMemory(MASS_COLLECTION).put(characterSetID & 0xFF);
        return true;
    }

    public int getCharacterSetCur() {
        return this.getMemory(MASS_COLLECTION).get(0);
    }

    public boolean setAnalogRefreshInterval(int interval) {
        this.getMemory(MASS_COLLECTION).setPosition(1);
        this.getMemory(MASS_COLLECTION).put(interval & 0xFF);
        return true;
    }

    public int getAnalogRefreshInterval() {
        return this.getMemory(MASS_COLLECTION).get(1);
    }

    public boolean setTickerInterval(int interval) {
        this.getMemory(MASS_COLLECTION).setPosition(2);
        this.getMemory(MASS_COLLECTION).put(interval & 0xFF);
        this.getMemory(MASS_COLLECTION).put(0);
        return true;
    }

    public int getTickerInterval() {
        return this.getMemory(MASS_COLLECTION).get(2);
    }

    public boolean setCharacterSets(int characterSet0, int characterSet1) {
        this.getMemory(MASS_COLLECTION).setPosition(4);
        this.getMemory(MASS_COLLECTION).put(characterSet0 & 0xFF);
        this.getMemory(MASS_COLLECTION).put(characterSet1 & 0xFF);
        return true;
    }

    public int[] getCharacterSets() {
        int[] ret = new int[2];
        int[] values = this.getMemory(MASS_COLLECTION).asArray();
        ret[0] = values[4];
        ret[1] = values[5];
        return ret;
    }

    public boolean setMessageTextInfo(int msgTextID, int msgBlockNr, int charSetID, int CharacterSet) {
        Memory offsetMemory = this.getMemory(MESSAGE_OFFSET);
        offsetMemory.setPosition(msgTextID * 2);
        offsetMemory.put(msgBlockNr + (charSetID << 7) & 0xFF);
        offsetMemory.put(CharacterSet);
        return true;
    }

    public int getMessageTextID(int msgBlockNr, int languageSet) {
        Memory offsetMemory = this.getMemory(MESSAGE_OFFSET);
        int infoByte = msgBlockNr + (languageSet << 7) & 0xFF;
        for (int i = 0; i < offsetMemory.size() / 2; ++i) {
            if (offsetMemory.get(i * 2) != infoByte) continue;
            return i;
        }
        return -1;
    }

    public Memory getMessageOffsetMemory() {
        return this.getMemory(MESSAGE_OFFSET);
    }

    public MessageMemory8 getMessageTextMemory() {
        return (MessageMemory8)this.getMemory(MESSAGE_TEXT);
    }

    public Memory getBarGraphMemory() {
        return this.getMemory(BAR_GRAPH);
    }

    public boolean setMsgInfo(int msgTextID, int msgInfo) {
        Memory offsetMemory = this.getMemory(MESSAGE_INFO);
        offsetMemory.setPosition(msgTextID);
        offsetMemory.put(msgInfo);
        return true;
    }

    public int getMsgInfo(int msgTextID) {
        return this.getMemory(MESSAGE_INFO).get(msgTextID);
    }

    public boolean setMsgLineTickerFlag(int msgTextID, int lineNr, boolean tickerFlag) {
        Memory tickMemory = this.getMemory(TICKER_FLAG);
        int memoryIndex = msgTextID / 2;
        int byteIndex = msgTextID % 2 * 4 + lineNr;
        int settingByte = tickMemory.get(memoryIndex);
        settingByte = this.setBit(settingByte, byteIndex, tickerFlag ? 1 : 0);
        tickMemory.setPosition(memoryIndex);
        tickMemory.put(settingByte);
        return true;
    }

    public boolean getMsgLineTickFlag(int msgTextID, int lineNr) {
        Memory tickMemory = this.getMemory(TICKER_FLAG);
        int memoryIndex = msgTextID / 2;
        int byteIndex = msgTextID % 2 * 4 + lineNr;
        int settingByte = tickMemory.get(memoryIndex);
        return this.getBit(settingByte, byteIndex);
    }

    public boolean setIO_Offset(int tableIndex, int opcodeCO) {
        Memory offsetMemory = this.getMemory(IO_OFFSET);
        offsetMemory.setPosition(tableIndex);
        offsetMemory.put(opcodeCO);
        return true;
    }

    public int getIO_Offset(int opcodeCO) {
        Memory offsetMemory = this.getMemory(IO_OFFSET);
        for (int i = 0; i < offsetMemory.size(); ++i) {
            if (offsetMemory.get(i) != opcodeCO) continue;
            return i;
        }
        return -1;
    }

    public Memory getIO_StatusNameMemory() {
        return this.getMemory(IO_STATUS_NAME);
    }

    private int setBit(int value, int bitIndex, int bitValue) {
        int ret = value;
        int mask = 1 << bitIndex;
        ret &= ~mask;
        return ret |= bitValue << bitIndex;
    }

    private boolean getBit(int settingByte, int bitIndex) {
        int mask = 1 << bitIndex;
        return (mask & settingByte) != 0;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(32768);
        for (int i = 0; i < this.fMemories.length; ++i) {
            if (this.fMemories[i].getName().equals(FREE_ID)) continue;
            ret.append(this.fMemories[i].toString());
        }
        return ret.toString();
    }
}

