/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.MemoryEnumeration;
import DE.siemens.ad.logo.util.Util;

public class Memory {
    protected String fName;
    protected int fTansferStartAdress;
    protected int[][] fMemory;
    protected int fByteIndex;
    protected int fBlockIndex;
    private static final int CONNECT_COST = 100;
    private static final int DEFAULT_VALUE = 255;

    public void createReferences(CompilerFromLogo compiler) {
    }

    protected Memory() {
    }

    protected Memory(int memorySize, int blockSize) throws IllegalArgumentException {
        if (memorySize < 1 || blockSize < 1) {
            throw new IllegalArgumentException();
        }
        this.fMemory = new int[memorySize][blockSize];
    }

    public Memory(String name, int transferAdress, int memorySize, int blockSize) {
        this(memorySize, blockSize);
        this.fName = name;
        this.fTansferStartAdress = transferAdress;
    }

    public final int[] asArray() {
        MemoryEnumeration me = new MemoryEnumeration(this.fMemory);
        int counter = this.size() * this.getBlockSize();
        int[] data = new int[counter];
        counter = 0;
        while (me.hasMoreElements()) {
            data[counter] = me.nextByteAsInt();
            ++counter;
        }
        return data;
    }

    public int getBlockSize() {
        return this.fMemory[0].length;
    }

    public void createBlocks(WiringDiagram wd, CompilerFromLogo compiler) {
    }

    public void download(DataTransfer dt) throws TransmissionFailedException {
        this.download(dt, false);
    }

    public void download(DataTransfer dt, boolean fastDownload) throws TransmissionFailedException {
        int[] array = this.asArray();
        int pointer = 0;
        if (!fastDownload) {
            while (array.length - pointer > 0) {
                int size = Math.min(array.length - pointer, 512);
                int[] buffer = new int[size];
                System.arraycopy(array, pointer, buffer, 0, size);
                dt.writeByteArray(this.fTansferStartAdress + pointer, buffer);
                pointer += size;
            }
        } else {
            while (array.length - pointer > 0) {
                if ((pointer = this.getValidValueIndex(array, pointer)) == -1) {
                    return;
                }
                int size = this.getThisStepIndex(array, pointer) - pointer + 1;
                int[] buffer = new int[size];
                System.arraycopy(array, pointer, buffer, 0, size);
                System.out.println("Array: " + Integer.toHexString(this.fTansferStartAdress) + ", size: " + array.length + ", Point " + pointer + " , size " + size);
                dt.writeByteArray(this.fTansferStartAdress + pointer, buffer);
                pointer += size;
            }
        }
    }

    public int getFastDownloadBytesCount() {
        int[] array = this.asArray();
        int pointer = 0;
        int wholeSize = 0;
        while (array.length - pointer > 0 && (pointer = this.getValidValueIndex(array, pointer)) != -1) {
            int size = this.getThisStepIndex(array, pointer) - pointer + 1;
            pointer += size;
            wholeSize += size;
        }
        return wholeSize;
    }

    private int getThisStepIndex(int[] arr, int start) {
        int next;
        int pos = start;
        while (pos - start + 1 < 512 && (next = this.getValidValueIndex(arr, pos + 1)) != -1 && next - pos <= 100) {
            pos = next;
        }
        return pos;
    }

    private int getValidValueIndex(int[] arr, int start) {
        for (int i = start; i < arr.length; ++i) {
            if (arr[i] == 255) continue;
            return i;
        }
        return -1;
    }

    public MemoryEnumeration elements() {
        return new MemoryEnumeration(this.fMemory);
    }

    public boolean equals(Object obj) {
        boolean result = true;
        Memory memObj = null;
        result = obj instanceof Memory;
        if (result) {
            memObj = (Memory)obj;
            result = this.size() == memObj.size();
        } else {
            Log.println("Other is no Memory");
        }
        if (result) {
            result = this.getBlockSize() == memObj.getBlockSize();
        } else {
            Log.println("\tMemorysize:" + this.size() + " - " + memObj.size());
        }
        if (result) {
            MemoryEnumeration enum1 = this.elements();
            MemoryEnumeration enum2 = memObj.elements();
            int i = 0;
            while (enum1.hasMoreElements()) {
                if (enum1.nextByte() != enum2.nextByte()) {
                    result = false;
                    Log.println("\tDifferent Byte in block/offset:" + i / this.getBlockSize() + "/" + i % this.getBlockSize());
                }
                ++i;
            }
        }
        return result;
    }

    public int getChecksum() {
        MemoryEnumeration me = new MemoryEnumeration(this.fMemory);
        int checksum = 0;
        while (me.hasMoreElements()) {
            checksum += me.nextByteAsInt();
        }
        return checksum;
    }

    public int[] getMemoryBlock(int line) {
        return this.fMemory[line];
    }

    public final String getName() {
        return this.fName;
    }

    public final int getOffsetAdress() {
        return this.fTansferStartAdress;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void incrementByteAdress() {
        ++this.fByteIndex;
        if (this.fByteIndex == this.fMemory[this.fBlockIndex].length) {
            ++this.fBlockIndex;
            this.fByteIndex = 0;
        }
    }

    public Memory init() {
        this.init(0);
        this.fBlockIndex = 0;
        this.fByteIndex = 0;
        return this;
    }

    public void init(int initByte) {
        int blockSize = this.fMemory[0].length;
        for (int blockIdx = 0; blockIdx < this.fMemory.length; ++blockIdx) {
            for (int byteIdx = 0; byteIdx < blockSize; ++byteIdx) {
                this.fMemory[blockIdx][byteIdx] = initByte;
            }
        }
    }

    public boolean isChecksumRelevant() {
        return false;
    }

    public void load(int[] data) {
        int ende = this.size() * this.getBlockSize() + this.fTansferStartAdress;
        this.setPosition(0, 0);
        for (int i = this.fTansferStartAdress; i < ende; ++i) {
            this.put(data[i]);
        }
    }

    private void incrementBlockAdress() {
        ++this.fBlockIndex;
        this.fByteIndex = 0;
    }

    public int putMemoryBlock(int[] memoryBlock) throws IndexOutOfBoundsException {
        int index = this.fBlockIndex;
        this.fMemory[this.fBlockIndex++] = memoryBlock;
        return index;
    }

    public int put(int[] valueArray) throws IndexOutOfBoundsException {
        int retValue = this.getPosition();
        for (int i = 0; i < valueArray.length; ++i) {
            this.put(valueArray[i]);
        }
        return retValue;
    }

    public int put(int aByte) {
        this.fMemory[this.fBlockIndex][this.fByteIndex] = aByte & 0xFF;
        this.incrementByteAdress();
        return this.getPosition() - 1;
    }

    public int putWord(int a16BitValue) {
        int retValue = this.getPosition();
        this.fMemory[this.fBlockIndex][this.fByteIndex] = a16BitValue & 0xFF;
        this.incrementByteAdress();
        this.fMemory[this.fBlockIndex][this.fByteIndex] = (a16BitValue & 0xFF00) >> 8;
        this.incrementByteAdress();
        return retValue;
    }

    public int putDoubleWord(int a32BitValue) {
        int retValue = this.putWord(a32BitValue & 0xFFFF);
        this.putWord((a32BitValue & 0xFFFF0000) >> 16);
        return retValue;
    }

    public void putMemoryBlock(int position, int[] memoryBlock) throws IndexOutOfBoundsException {
        this.fBlockIndex = position;
        this.fMemory[this.fBlockIndex] = memoryBlock;
        this.incrementBlockAdress();
    }

    public void replace(int pos, int value) {
        int blockIndex = pos / this.getBlockSize();
        int byteIndex = pos % this.getBlockSize();
        this.fMemory[blockIndex][byteIndex] = value & 0xFF;
    }

    public int put(int blockIndex, int byteIndex, int value) throws IndexOutOfBoundsException {
        this.fBlockIndex = blockIndex;
        this.fByteIndex = byteIndex;
        this.fMemory[blockIndex][byteIndex] = value & 0xFF;
        this.incrementByteAdress();
        return this.getPosition() - 1;
    }

    public int getPosition() {
        return this.fBlockIndex * this.fMemory[0].length + this.fByteIndex;
    }

    public void setPosition(int blockIndex, int byteIndex) {
        this.fBlockIndex = blockIndex;
        this.fByteIndex = byteIndex;
    }

    public void setPosition(int byteOffset) {
        int blockSize = this.getBlockSize();
        this.fBlockIndex = byteOffset / blockSize;
        this.fByteIndex = byteOffset % blockSize;
    }

    public int size() {
        int result = this.fMemory.length;
        return result;
    }

    public String toString() {
        return this.getName() + this.toString(0) + "\n";
    }

    public String toString(int startLine) {
        int lineNr = startLine;
        String result = "\n";
        String hexString = "";
        int blockSize = this.fMemory[0].length;
        for (int blockIdx = 0; blockIdx < this.fMemory.length; ++blockIdx) {
            result = result + lineNr++ + ":\t";
            for (int byteIdx = 0; byteIdx < blockSize; ++byteIdx) {
                hexString = Integer.toHexString(this.fMemory[blockIdx][byteIdx]).toUpperCase();
                if (hexString.length() == 1) {
                    hexString = "0" + hexString;
                }
                result = result + hexString;
                if (byteIdx >= blockSize - 1) continue;
                result = result + ", ";
            }
            result = result + "\n";
        }
        return result;
    }

    public void upload(DataTransfer dt) throws TransmissionFailedException {
        int[] data = null;
        int length = this.size() * this.getBlockSize();
        data = dt.readByteArray(this.fTansferStartAdress, length);
        this.setPosition(0, 0);
        for (int i = 0; i < length; ++i) {
            this.put(data[i]);
        }
    }

    public int getElement() {
        int value = this.fMemory[this.fBlockIndex][this.fByteIndex];
        this.incrementByteAdress();
        return value;
    }

    public int nextByte() {
        int value = this.fMemory[this.fBlockIndex][this.fByteIndex];
        this.incrementByteAdress();
        return value;
    }

    public int nextWord() {
        int result = this.nextByte();
        return result |= this.nextByte() << 8;
    }

    public int nextSignedWord() {
        int lowByte = this.nextByte();
        int highByte = this.nextByte();
        return Util.makeSignedWord(highByte, lowByte);
    }

    public int nextDoubleWord() {
        int result = this.nextWord();
        return result |= this.nextWord() << 16;
    }

    public int get(int pos) {
        int blockIndex = pos / this.getBlockSize();
        int byteIndex = pos % this.getBlockSize();
        return this.fMemory[blockIndex][byteIndex];
    }

    public int getWord(int pos) {
        int result = this.get(pos);
        return result |= this.get(pos + 1) << 8;
    }

    public int getDoubleWord(int pos) {
        int result = this.getWord(pos);
        return result |= this.getWord(pos + 2) << 16;
    }

    public int[] getMemoryBlock() {
        return this.fMemory[this.fBlockIndex++];
    }
}

