/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoPreviewPanel;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;

public class MarginPanel
extends LogoPreviewPanel {
    public static final String MARGIN = "Margin";

    public Color getDefaultColor() {
        return Color.white;
    }

    public String getKey() {
        return MARGIN;
    }

    public JPanel getPreview() {
        this.getfPanel();
        this.fPanel.add(this.getConnectionLabel());
        this.fPanel.setBackground(this.getColor());
        this.setMarginColor(this.getColor());
        this.fPanel.repaint();
        return this.fPanel;
    }

    public String getPreviewName() {
        return Language.getString("dialog.options.color.Margin", MARGIN);
    }

    protected void setMarginColor(Color c) {
        Color newColor;
        boolean algo = true;
        if (algo) {
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            hsb[0] = (float)((double)hsb[0] + 0.4);
            if (hsb[0] > 1.0f) {
                hsb[0] = hsb[0] - 1.0f;
            }
            hsb[1] = 1.0f;
            hsb[2] = 0.7f;
            newColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        } else {
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            hsb[0] = (float)((double)hsb[0] - 0.4);
            if (hsb[0] < 0.0f) {
                hsb[0] = hsb[0] + 1.0f;
            }
            hsb[1] = 1.0f;
            hsb[2] = 0.8f;
            newColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        }
        this.fPanel.setForeground(newColor);
    }

    public void stateChanged(ChangeEvent e) {
        Color color = null;
        if (e.getSource() instanceof DefaultColorSelectionModel) {
            color = ((DefaultColorSelectionModel)e.getSource()).getSelectedColor();
            this.setColor(color);
        }
        if (this.fPanel != null) {
            this.fPanel.setBackground(this.getColor());
            this.setMarginColor(color);
        }
    }
}

