/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class LogoPreviewPanel
implements ChangeListener,
Cloneable {
    protected JPanel fPanel = null;
    protected JLabel fOutputLabel = null;
    protected JLabel fInputLabel = null;
    protected JLabel fconnection = null;
    protected Color fSelectedColor = null;
    protected boolean fConnentionPreview = false;
    protected BorderJPanel fBorderPanel = null;
    protected BorderJPanel ivjBorderJPanel2 = null;
    protected Color fBackgroundColor = Global.BACKGROUND_COLOR;

    void addChangeListener(ChangeListener listener) {
    }

    public BorderJPanel getBackgroundPreview() {
        BorderJPanel returnPanel = this.getBorderJPanel2();
        returnPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        returnPanel.setLayout(new FlowLayout());
        returnPanel.setLayout(new BorderLayout());
        this.getfPanel();
        this.fPanel.add(this.getInputLabel());
        this.fPanel.add(this.getConnectionLabel());
        this.fPanel.add(this.getOutputLabel());
        this.fPanel.repaint();
        returnPanel.add(this.fPanel);
        return returnPanel;
    }

    public Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    public JPanel getBackgroundPreviewPanel() {
        BorderJPanel returnPanel = this.getBorderJPanel2();
        returnPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        returnPanel.setLayout(new FlowLayout());
        returnPanel.setLayout(new BorderLayout());
        this.getfPanel();
        this.fPanel.add(this.getInputLabel());
        this.fPanel.add(this.getConnectionLabel());
        this.fPanel.add(this.getOutputLabel());
        this.fPanel.repaint();
        return this.fPanel;
    }

    protected BorderJPanel getBorderJPanel2() {
        if (this.ivjBorderJPanel2 == null) {
            try {
                this.ivjBorderJPanel2 = new BorderJPanel();
                this.ivjBorderJPanel2.setName("BorderJPanel2");
                this.ivjBorderJPanel2.setLayout(new BorderLayout());
                this.ivjBorderJPanel2.setTitle("Preview");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderJPanel2;
    }

    public BorderJPanel getBorderPreview() {
        this.fBorderPanel = this.getBorderJPanel2();
        this.fBorderPanel.setTitle(this.getPreviewName());
        this.fBorderPanel.setLayout(new BorderLayout());
        this.fBorderPanel.add(this.getPreview());
        return this.fBorderPanel;
    }

    public Color getColor() {
        if (this.fSelectedColor == null) {
            this.fSelectedColor = this.getDefaultColor();
        }
        return this.fSelectedColor;
    }

    protected JLabel getConnectionLabel() {
        this.fconnection = new JLabel("                    ");
        return this.fconnection;
    }

    public BorderJPanel getConnectionPreview() {
        BorderJPanel returnPanel = this.getBorderJPanel2();
        returnPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        returnPanel.setLayout(new BorderLayout());
        returnPanel.setLayout(new BorderLayout());
        this.getfPanel();
        this.fPanel.add(this.getInputLabel());
        this.fPanel.add(this.getConnectionLabel());
        this.fPanel.add(this.getOutputLabel());
        returnPanel.add(this.fPanel);
        return returnPanel;
    }

    public JPanel getConnectionPreviewPanel() {
        BorderJPanel returnPanel = this.getBorderJPanel2();
        returnPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        returnPanel.setLayout(new BorderLayout());
        returnPanel.setLayout(new BorderLayout());
        this.getfPanel();
        this.fPanel.add(this.getInputLabel());
        this.fPanel.add(this.getConnectionLabel());
        this.fPanel.add(this.getOutputLabel());
        return this.fPanel;
    }

    public abstract Color getDefaultColor();

    protected JPanel getfPanel() {
        this.fPanel = new JPanel(){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawLine(size.width / 2 - 35, size.height / 2, size.width / 2 + 35, size.height / 2);
            }
        };
        this.fPanel.setLayout(new FlowLayout());
        return this.fPanel;
    }

    protected JLabel getInputLabel() {
        String resourcename = "/DE/siemens/ad/logo/images/InputIcon.gif";
        URL url = this.getClass().getResource(resourcename);
        ImageIcon startImage = new ImageIcon(url);
        this.fInputLabel = new JLabel(startImage){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
        };
        return this.fInputLabel;
    }

    public abstract String getKey();

    protected JLabel getOutputLabel() {
        String resourcename = "/DE/siemens/ad/logo/images/OutputIcon.gif";
        URL url = this.getClass().getResource(resourcename);
        ImageIcon startImage = new ImageIcon(url);
        this.fOutputLabel = new JLabel(startImage){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
        };
        return this.fOutputLabel;
    }

    public abstract JPanel getPreview();

    public abstract String getPreviewName();

    public Color getSelectedColor() {
        return null;
    }

    private void handleException(Throwable exception) {
    }

    public void newMethod() {
    }

    void removeChangeListener(ChangeListener listener) {
    }

    public void setColor(Color color) {
        this.fSelectedColor = color;
    }

    public void setConnectionColor(Color color) {
        this.fInputLabel.setForeground(color);
        this.fOutputLabel.setForeground(color);
        this.fPanel.setForeground(color);
    }

    public void setPreviewColor(Color color) {
        if (!this.fConnentionPreview) {
            this.getfPanel().setBackground(color);
            this.fPanel.revalidate();
        }
        if (this.fConnentionPreview) {
            this.setConnectionColor(color);
            this.fPanel.revalidate();
            this.fPanel.paint(this.fPanel.getGraphics());
        }
    }

    public void setSelectedColor(Color color) {
    }

    public abstract void stateChanged(ChangeEvent var1);

    public void setBackground(Color previewBackground) {
        this.fBackgroundColor = previewBackground;
        if (this.fPanel != null) {
            this.fPanel.setBackground(previewBackground);
        }
    }
}

