/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.util.BackgroundPanel;
import DE.siemens.ad.logo.util.ConnectionPanel;
import DE.siemens.ad.logo.util.FontsPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoColorChooser;
import DE.siemens.ad.logo.util.LogoPreviewPanel;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LogoColorChooserPanel
extends DataInputPanel {
    private LogoColorChooser fLogoColorChooser = null;
    private Color fCurrentColor = Color.black;
    private JPanel fPreviewPanel = null;
    private LogoPreviewPanel fPreview = null;

    public LogoColorChooserPanel() {
        this.initialize();
    }

    public LogoColorChooserPanel(Color color) {
        this.initialize();
        this.fCurrentColor = color;
    }

    public BorderJPanel getBorderPreview(JComponent inputPanel) {
        BorderJPanel retValue = new BorderJPanel();
        retValue.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        retValue.setLayout(new BorderLayout());
        retValue.add(inputPanel);
        return retValue;
    }

    public Color getCurrentColor() {
        return this.fCurrentColor;
    }

    private LogoColorChooser getLogoColorChooser() {
        if (this.fLogoColorChooser == null) {
            this.fLogoColorChooser = new LogoColorChooser();
            this.fLogoColorChooser.setLogoPreviewPanel(this.getPreview());
        }
        return this.fLogoColorChooser;
    }

    public LogoPreviewPanel getPreview() {
        return this.fPreview;
    }

    public String[] getPreviewKeys() {
        String[] retValue = new String[]{"logo.color.fonts", "backColor", "simulation.color.low", "simulation.color.high"};
        return retValue;
    }

    public Hashtable getPreviews() {
        Hashtable<String, LogoPreviewPanel> retValue = new Hashtable<String, LogoPreviewPanel>(30);
        retValue.put("logo.color.fonts", new FontsPanel());
        retValue.put("backColor", new BackgroundPanel());
        retValue.put("simulation.color.low", new ConnectionPanel());
        retValue.put("simulation.color.high", new ConnectionPanel());
        return retValue;
    }

    public String getTitle() {
        return Language.getString("dialog.options.color.colorChooser", "Colorchooser");
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setLayout(new BorderLayout());
            this.setName("LogoColorChooserDlg");
            this.setSize(430, 450);
            this.add(this.getLogoColorChooser());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void setCurrentColor(Color color) {
        this.fCurrentColor = color;
        if (this.fPreview != null) {
            this.fPreview.setColor(color);
        }
    }

    public void setLogoPreview(LogoPreviewPanel preview) {
        this.fPreview = preview;
        this.setCurrentColor(preview.getColor());
        this.fLogoColorChooser.setLogoPreviewPanel(preview);
    }

    public void setPreview(String key) {
        LogoPreviewPanel preview;
        this.fPreview = preview = (LogoPreviewPanel)this.getPreviews().get(key);
    }

    public void storeFieldContents() {
        Color color = this.getLogoColorChooser().getSelectionModel().getSelectedColor();
        this.setCurrentColor(color);
    }

    public void closeEvent() {
        super.closeEvent();
        this.fLogoColorChooser.closeEvent();
    }

    public void loadFieldContents() throws ProgramException {
        super.loadFieldContents();
        System.out.println(this.getCurrentColor() + "  -  " + this.fPreview.getBackgroundColor());
        this.fPreview.setBackground(this.fPreview.getBackgroundColor());
    }
}

