/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoPreviewPanel;
import DE.siemens.ad.logo.util.StandardColorChooserPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogoColorChooser
extends JColorChooser
implements ChangeListener {
    private BorderJPanel ivjBorderJPanel2 = null;
    private JPanel fPanel = null;
    private JComponent fPreviewComponent = null;
    private JLabel fconnection = null;
    private LogoPreviewPanel flogoPreviewPanel = null;
    private JComponent fShownPreview = null;
    private JLabel fOutputLabel = null;
    private JLabel fInputLabel = null;
    private boolean fConnentionPreview = false;
    private boolean fdefaultPreview = true;
    private JLabel fbanner = null;

    public LogoColorChooser() {
        this.initialize();
    }

    public LogoColorChooser(Color initialColor) {
        super(initialColor);
        this.initialize();
    }

    public LogoColorChooser(ColorSelectionModel model) {
        super(model);
        this.initialize();
    }

    public BorderJPanel getBackgroundPreview() {
        BorderJPanel returnPanel = this.getBorderJPanel2();
        returnPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        returnPanel.setLayout(new FlowLayout());
        returnPanel.setLayout(new BorderLayout());
        this.getfPanel();
        this.fPanel.add(this.getInputLabel());
        this.fPanel.add(this.getConnectionLabel());
        this.fPanel.add(this.getOututLabel());
        this.fPanel.repaint();
        returnPanel.add(this.fPanel);
        return returnPanel;
    }

    private BorderJPanel getBorderJPanel2() {
        if (this.ivjBorderJPanel2 == null) {
            try {
                this.ivjBorderJPanel2 = new BorderJPanel();
                this.ivjBorderJPanel2.setName("BorderJPanel2");
                this.ivjBorderJPanel2.setLayout(new BorderLayout());
                this.ivjBorderJPanel2.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderJPanel2;
    }

    private JLabel getConnectionLabel() {
        this.fconnection = new JLabel("                    ");
        return this.fconnection;
    }

    public BorderJPanel getConnectionPreview() {
        BorderJPanel returnPanel = this.getBorderJPanel2();
        returnPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        returnPanel.setLayout(new BorderLayout());
        returnPanel.setLayout(new BorderLayout());
        this.getfPanel();
        this.fPanel.add(this.getInputLabel());
        this.fPanel.add(this.getConnectionLabel());
        this.fPanel.add(this.getOututLabel());
        returnPanel.add(this.fPanel);
        return returnPanel;
    }

    private JPanel getfPanel() {
        this.fPanel = new JPanel(){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawLine(size.width / 2 - 35, size.height / 2, size.width / 2 + 35, size.height / 2);
            }
        };
        this.fPanel.setLayout(new FlowLayout());
        return this.fPanel;
    }

    private JLabel getInputLabel() {
        String resourcename = "/DE/siemens/ad/logo/images/InputIcon.gif";
        URL url = this.getClass().getResource(resourcename);
        ImageIcon startImage = new ImageIcon(url);
        this.fInputLabel = new JLabel(startImage){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
        };
        return this.fInputLabel;
    }

    public BorderJPanel getLogoPreview() {
        BorderJPanel returnPanel = this.getBorderJPanel2();
        returnPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
        returnPanel.setLayout(new FlowLayout());
        returnPanel.setLayout(new BorderLayout());
        this.fbanner = new JLabel("LOGO!", 0);
        this.fbanner.setOpaque(true);
        this.fbanner.setFont(new Font("SansSerif", 1, 24));
        this.fPanel = new JPanel();
        this.fPanel.add(this.fbanner);
        returnPanel.add(this.fPanel);
        return returnPanel;
    }

    private JLabel getOututLabel() {
        String resourcename = "/DE/siemens/ad/logo/images/OutputIcon.gif";
        URL url = this.getClass().getResource(resourcename);
        ImageIcon startImage = new ImageIcon(url);
        this.fOutputLabel = new JLabel(startImage){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
        };
        return this.fOutputLabel;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        this.setSelectionModel(new SelectionModel());
        try {
            this.addChooserPanel(new StandardColorChooserPanel());
            this.getSelectionModel().addChangeListener(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void setConnectionColor(Color color) {
        this.fInputLabel.setForeground(color);
        this.fOutputLabel.setForeground(color);
        this.fPanel.setForeground(color);
    }

    public void setLogoPreview() {
        this.fPreviewComponent = this.getLogoPreview();
        this.fbanner.setForeground(this.getSelectionModel().getSelectedColor());
        this.setPreviewPanel(this.fPreviewComponent);
    }

    public void setLogoPreview(boolean comp) {
        this.fdefaultPreview = false;
        if (comp) {
            this.fConnentionPreview = true;
            this.fPreviewComponent = this.getConnectionPreview();
            this.setConnectionColor(this.getSelectionModel().getSelectedColor());
        } else {
            this.fConnentionPreview = false;
            this.fPreviewComponent = this.getBackgroundPreview();
            this.fPanel.setBackground(this.getSelectionModel().getSelectedColor());
        }
        this.setPreviewPanel(this.fPreviewComponent);
    }

    public void setLogoPreviewPanel(LogoPreviewPanel lPP) {
        this.flogoPreviewPanel = lPP;
        if (lPP != null) {
            lPP.setBackground(lPP.getBackgroundColor());
            this.getSelectionModel().addChangeListener(lPP);
            this.getSelectionModel().setSelectedColor(lPP.getColor());
            this.setPreviewPanel(lPP.getBorderPreview());
        }
    }

    public void stateChanged(ChangeEvent e) {
        Color newColor = this.getColor();
        if (!this.fdefaultPreview) {
            if (!this.fConnentionPreview) {
                this.fPanel.setBackground(newColor);
            }
            if (this.fConnentionPreview) {
                this.setConnectionColor(newColor);
            }
        }
        if (this.fbanner != null) {
            this.fbanner.setForeground(newColor);
        }
    }

    public void closeEvent() {
        this.getSelectionModel().removeChangeListener(this.flogoPreviewPanel);
    }

    private class SelectionModel
    extends DefaultColorSelectionModel {
        private SelectionModel() {
        }

        protected void fireStateChanged() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = 0; i <= listeners.length - 2; i += 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
        }
    }
}

