/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.io.IOException;
import java.io.Serializable;

public class DoubleValueProperties
implements Serializable,
Storable {
    static final long serialVersionUID = -5567477863087470126L;
    protected double max;
    protected double min;
    protected double inc;
    protected double currentValue;
    protected String errorKey;
    protected String defaultErrorText;
    protected String pattern;

    public DoubleValueProperties() {
    }

    public DoubleValueProperties(double min, double max, double inc, double current, String pattern, String errorKey, String defaultErrorText) {
        this.setProperties(min, max, inc, current, pattern, errorKey, defaultErrorText);
    }

    public DoubleValueProperties(double min, double max, double inc, double current, int decimalPointPosition, String errorKey, String defaultErrorText) {
        StringBuffer pattern = new StringBuffer("############0");
        if (decimalPointPosition > 0) {
            pattern.append('.');
            for (int i = 0; i < decimalPointPosition; ++i) {
                pattern.append('#');
            }
        }
        this.setProperties(min, max, inc, current, pattern.toString(), errorKey, this.defaultErrorText);
    }

    public void correctValue() {
        this.currentValue = Math.max(this.currentValue, this.min);
        this.currentValue = Math.min(this.currentValue, this.max);
    }

    public int getDecimalPointPosition() {
        int decimalPointPosition = this.pattern.indexOf(46);
        if (decimalPointPosition == -1) {
            return 0;
        }
        return this.pattern.length() - decimalPointPosition - 1;
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public String getDefaultErrorText() {
        return this.defaultErrorText;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public double getInc() {
        return this.inc;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setCurrentValue(double value) {
        this.currentValue = value;
    }

    public void setDefaultErrorText(String errorText) {
        this.defaultErrorText = errorText;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public void setInc(float inc) {
        this.inc = inc;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setPattern(String newPattern) {
        this.pattern = newPattern;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Double.toString(this.currentValue));
        int patternDecimals = this.getDecimalPointPosition();
        int stringDecimals = buffer.length() - buffer.indexOf(".") - 1;
        if (stringDecimals < patternDecimals) {
            while (stringDecimals++ < patternDecimals) {
                buffer.append("0");
            }
        } else if (patternDecimals < stringDecimals) {
            buffer.substring(0, buffer.length() - (stringDecimals - patternDecimals) - 1);
        }
        return buffer.toString();
    }

    public void setProperties(double min, double max, double inc, double current, String pattern, String errorKey, String defaultErrorText) {
        this.min = min;
        this.max = max;
        this.inc = inc;
        this.currentValue = current;
        this.pattern = pattern;
        this.errorKey = errorKey;
        this.defaultErrorText = defaultErrorText;
    }

    public void read(StorableInput dr) throws IOException {
        this.currentValue = dr.readDouble();
        this.defaultErrorText = dr.readString();
        this.errorKey = dr.readString();
        this.inc = dr.readDouble();
        this.max = dr.readDouble();
        this.min = dr.readDouble();
        this.pattern = dr.readString();
    }

    public void write(StorableOutput dw) {
        dw.writeDouble(this.currentValue);
        dw.writeString(this.defaultErrorText);
        dw.writeString(this.errorKey);
        dw.writeDouble(this.inc);
        dw.writeDouble(this.max);
        dw.writeDouble(this.min);
        dw.writeString(this.pattern);
    }
}

