/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.app.dialog.ControlPanel;
import DE.siemens.ad.logo.util.BackgroundPanel;
import DE.siemens.ad.logo.util.ConnectionHighPanel;
import DE.siemens.ad.logo.util.ConnectionLowPanel;
import DE.siemens.ad.logo.util.ConnectionMarkerPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoColorChooser;
import DE.siemens.ad.logo.util.LogoColorChooserPanel;
import DE.siemens.ad.logo.util.LogoPreviewPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorDialog
implements ActionListener,
ListSelectionListener {
    private JPanel ivjColorChooserPanel = null;
    private String fLastPreview = null;
    private JPanel ivjColorContentPane = null;
    private JList ivjColorList = null;
    private JFrame ivjFarbauswahl = null;
    private LogoColorChooserPanel fColorChooserPanel = null;
    private LogoPreviewPanel fBackgroundPanel = null;
    private Hashtable fPreviewHashtabel = null;
    private Color fSelectedColor = new Color(204, 204, 204);
    private LogoPreviewPanel fConnectionPanel = null;
    private JFrame ivjJFrame1 = null;
    private JPanel ivjJFrameContentPane = null;
    private JButton ivjnewFCButton = null;
    private JButton ivjSColorButton = null;
    private BorderJPanel ivjPreviewPanel = null;
    private JRadioButton ivjRadioHigh = null;
    private JRadioButton ivjRadioLow = null;
    private JPanel ivjRadioPanel = null;
    private LogoColorChooser ivjLogoColorChooser4 = null;
    public JRadioButton fPressedRadioButton = null;
    private ControlPanel ivjOkCancelJPanel = null;
    private JDialog fColorDialog = null;
    public static final String FONTS = "logo.color.fonts";
    public static final String BACKGROUND = "backColor";
    public static final String SIMULATION_LOW = "simulation.color.low";
    public static final String SIMULATION_HIGH = "simulation.color.high";
    private Vector fLogoPreviewPanelsVector = new Vector();
    private Color fPreviewBackground = Global.BACKGROUND_COLOR;

    public ColorDialog() {
    }

    public ColorDialog(boolean defaultPreviews) {
        if (defaultPreviews) {
            this.initDefaultPreviews();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getnewFCButton() && this.getSelectedListItem() != null) {
            this.connEtoM1(e);
        }
        if (e.getSource() == this.getStandardColorButton()) {
            this.setStandardColors();
        }
    }

    public void addLogoPreviewPanel(LogoPreviewPanel additionalPreview) {
        this.fLogoPreviewPanelsVector.add(additionalPreview);
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.getnewFCButton());
            if (this.fColorChooserPanel == null) {
                this.fColorChooserPanel = new LogoColorChooserPanel();
            }
            this.fColorChooserPanel.setLogoPreview(this.getSelectedListItem());
            SplittedDlg dialog = SplittedDlg.create(frame, this.fColorChooserPanel, 11);
            dialog.show();
            int rw = dialog.getControlPanel().getResult();
            if (rw == 1) {
                this.okPressed();
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2() {
        try {
            this.getFarbauswahl().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getColorChooserPanel() {
        if (this.ivjColorChooserPanel == null) {
            try {
                this.ivjColorChooserPanel = new JPanel();
                this.ivjColorChooserPanel.setName("ColorChooserPanel");
                this.ivjColorChooserPanel.setLayout(new BorderLayout());
                this.ivjColorChooserPanel.setBackground(SystemColor.controlHighlight);
                this.getColorChooserPanel().add((Component)this.getLogoColorChooser4(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjColorChooserPanel;
    }

    private JPanel getColorContentPane() {
        if (this.ivjColorContentPane == null) {
            this.ivjColorContentPane = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(5, 5, 0, 0);
            gbc.fill = 2;
            buttonPanel.add((Component)this.getnewFCButton(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(5, 5, 0, 0);
            gbc.fill = 2;
            buttonPanel.add((Component)this.getStandardColorButton(), gbc);
            JPanel filler = new JPanel();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            buttonPanel.add((Component)filler, gbc);
            this.ivjColorContentPane.add((Component)buttonPanel, "East");
            this.ivjColorContentPane.add((Component)new JScrollPane(this.getColorList()), "Center");
            this.ivjColorContentPane.add((Component)this.getPreviewPanel(), "South");
        }
        return this.ivjColorContentPane;
    }

    public JPanel getColorDialogPanel() {
        this.setList();
        try {
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        JPanel retPanel = new JPanel();
        retPanel.setPreferredSize(new Dimension(332, 279));
        retPanel.setLayout(new BorderLayout());
        retPanel.add(this.getColorContentPane());
        return retPanel;
    }

    private JList getColorList() {
        if (this.ivjColorList == null) {
            try {
                this.ivjColorList = new JList();
                this.ivjColorList.setName("ColorList");
                this.ivjColorList.addListSelectionListener(this);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjColorList;
    }

    private JFrame getFarbauswahl() {
        if (this.ivjFarbauswahl == null) {
            try {
                this.ivjFarbauswahl = new JFrame();
                this.ivjFarbauswahl.setName(Language.getString("dialog.options.color.colorChooser", "Colorchooser"));
                this.ivjFarbauswahl.setDefaultCloseOperation(2);
                this.ivjFarbauswahl.setBounds(134, 88, 332, 279);
                this.getFarbauswahl().setContentPane(this.getColorContentPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFarbauswahl;
    }

    private LogoColorChooser getLogoColorChooser4() {
        if (this.ivjLogoColorChooser4 == null) {
            try {
                this.ivjLogoColorChooser4 = new LogoColorChooser();
                this.ivjLogoColorChooser4.setName("LogoColorChooser4");
                LogoPreviewPanel preview = this.getSelectedListItem();
                this.ivjLogoColorChooser4.getSelectionModel().setSelectedColor(preview.getColor());
                String font = FONTS;
                if (this.getSelectedListItem().equals(BACKGROUND)) {
                    this.ivjLogoColorChooser4.setLogoPreview(false);
                }
                if (this.getSelectedListItem().equals(SIMULATION_LOW)) {
                    this.ivjLogoColorChooser4.setLogoPreview(true);
                }
                if (this.getSelectedListItem().equals(SIMULATION_HIGH)) {
                    this.ivjLogoColorChooser4.setLogoPreview(true);
                }
                if (this.getSelectedListItem().equals(font)) {
                    this.ivjLogoColorChooser4.setLogoPreview();
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogoColorChooser4;
    }

    public Vector getLogoPreviewPanels() {
        return this.fLogoPreviewPanelsVector;
    }

    private JButton getnewFCButton() {
        if (this.ivjnewFCButton == null) {
            try {
                this.ivjnewFCButton = new JButton();
                this.ivjnewFCButton.setName("newFCButton");
                this.ivjnewFCButton.setEnabled(false);
                String text = Language.getString("dialog.options.color", "Color");
                this.ivjnewFCButton.setText(text + "...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjnewFCButton;
    }

    private JPanel getPreviewPanel() {
        if (this.ivjPreviewPanel == null) {
            try {
                this.ivjPreviewPanel = new BorderJPanel();
                this.ivjPreviewPanel.setName("PreviewPanel");
                this.ivjPreviewPanel.setLayout(new CardLayout());
                this.ivjPreviewPanel.setTitle(Language.getString("dialog.options.color.preview", "Preview"));
                Vector previews = this.getLogoPreviewPanels();
                Color backgroundColor = ((LogoPreviewPanel)previews.get(0)).getColor();
                for (int i = 0; i < previews.size(); ++i) {
                    LogoPreviewPanel comp = (LogoPreviewPanel)previews.get(i);
                    JPanel vorschau = comp.getPreview();
                    vorschau.setBackground(backgroundColor);
                    this.ivjPreviewPanel.add((Component)vorschau, comp.getKey());
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreviewPanel;
    }

    public static String getRGBofColor(Color color) {
        String colorString = color.toString();
        String retValue = "";
        for (int i = 0; i < 3; ++i) {
            int startIndex = colorString.indexOf("=");
            int endIndex = colorString.indexOf(",");
            if (endIndex == -1) {
                endIndex = colorString.length() - 1;
            }
            retValue = retValue + colorString.substring(startIndex + 1, endIndex) + ",";
            colorString = colorString.substring(endIndex + 1);
        }
        return retValue.substring(0, retValue.length() - 1);
    }

    public Color getSelectedColor() {
        return this.fSelectedColor;
    }

    public LogoPreviewPanel getSelectedListItem() {
        String auswahl = null;
        try {
            auswahl = (String)this.getColorList().getSelectedValue();
            Vector previews = this.getLogoPreviewPanels();
            for (int i = 0; i < previews.size(); ++i) {
                LogoPreviewPanel prevPanel = (LogoPreviewPanel)previews.get(i);
                if (!auswahl.equals(prevPanel.getPreviewName())) continue;
                this.getnewFCButton().setEnabled(true);
                return prevPanel;
            }
        }
        catch (ClassCastException exp) {
            System.out.println("Cast Exception in ColorDialog.getSelectedListItem");
        }
        return null;
    }

    private JButton getStandardColorButton() {
        if (this.ivjSColorButton == null) {
            try {
                this.ivjSColorButton = new JButton();
                this.ivjSColorButton.setName("StandardButton");
                String text = Language.getString("view.toolbars.standard", "~Standard");
                this.ivjSColorButton.setText(text.substring(1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSColorButton;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getnewFCButton().addActionListener(this);
        this.getStandardColorButton().addActionListener(this);
    }

    public void initDefaultPreviews() {
        BackgroundPanel background = new BackgroundPanel();
        background.setColor(Global.BACKGROUND_COLOR);
        this.addLogoPreviewPanel(background);
        ConnectionLowPanel connectionLow = new ConnectionLowPanel();
        connectionLow.setColor(Global.SIMULATION_COLOR_LOW);
        this.addLogoPreviewPanel(connectionLow);
        ConnectionHighPanel connectionHigh = new ConnectionHighPanel();
        connectionHigh.setColor(Global.SIMULATION_COLOR_HIGH);
        this.addLogoPreviewPanel(connectionHigh);
        for (int i = 0; i < 5; ++i) {
            ConnectionMarkerPanel markerPanel = new ConnectionMarkerPanel(i);
            markerPanel.setColor(markerPanel.getDefaultColor());
            this.addLogoPreviewPanel(markerPanel);
        }
    }

    private void initialize() {
        try {
            this.setList();
            this.initConnections();
            this.connEtoM2();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void okPressed() {
        this.fSelectedColor = this.fColorChooserPanel.getCurrentColor();
        if (this.fColorChooserPanel != null) {
            this.setSelectedColor(this.fSelectedColor);
            this.repaintPreview();
        }
        this.fColorChooserPanel = null;
        this.ivjJFrameContentPane = null;
        this.ivjJFrame1 = null;
        this.ivjColorChooserPanel = null;
        this.ivjLogoColorChooser4 = null;
        if (this.ivjFarbauswahl != null) {
            this.ivjFarbauswahl.setVisible(false);
            this.ivjFarbauswahl = null;
        }
        if (this.fColorDialog != null) {
            this.fColorDialog.setVisible(false);
            this.fColorDialog = null;
        }
    }

    public void repaintAllPreviews() {
        Vector previews = this.getLogoPreviewPanels();
        this.getPreviewPanel().removeAll();
        Color backgroundColor = ((LogoPreviewPanel)previews.get(0)).getColor();
        for (int i = 0; i < previews.size(); ++i) {
            LogoPreviewPanel preview = (LogoPreviewPanel)previews.get(i);
            if (preview == null) {
                return;
            }
            preview.setColor(preview.getDefaultColor());
            preview.getPreview().setBackground(backgroundColor);
            preview.getPreview().invalidate();
            this.getPreviewPanel().add((Component)preview.getPreview(), preview.getKey());
            CardLayout cl = (CardLayout)this.getPreviewPanel().getLayout();
            cl.show(this.getPreviewPanel(), preview.getKey());
        }
        this.getColorList().setSelectedIndex(0);
        LogoPreviewPanel preview = this.getSelectedListItem();
        CardLayout cl = (CardLayout)this.getPreviewPanel().getLayout();
        cl.show(this.getPreviewPanel(), preview.getKey());
    }

    private void repaintPreview() {
        LogoPreviewPanel preview = this.getSelectedListItem();
        if (preview instanceof BackgroundPanel) {
            this.fPreviewBackground = this.getSelectedColor();
        }
        if (preview == null) {
            return;
        }
        this.getLogoPreviewPanels().remove(preview);
        this.getPreviewPanel().remove(preview.getPreview());
        preview.setColor(this.getSelectedColor());
        preview.setBackground(this.fPreviewBackground);
        preview.getPreview().repaint();
        this.getPreviewPanel().repaint();
        this.getLogoPreviewPanels().add(preview);
        this.getPreviewPanel().add((Component)preview.getPreview(), preview.getKey());
        CardLayout cl = (CardLayout)this.getPreviewPanel().getLayout();
        cl.show(this.getPreviewPanel(), preview.getKey());
    }

    protected void setList() {
        Vector useablePanels = this.getLogoPreviewPanels();
        String[] properties = new String[useablePanels.size()];
        for (int i = 0; i < properties.length; ++i) {
            LogoPreviewPanel preview = (LogoPreviewPanel)useablePanels.get(i);
            properties[i] = preview.getPreviewName();
        }
        this.getColorList().setListData(properties);
        this.getColorList().setSelectionMode(0);
        this.getColorList().addListSelectionListener(this);
    }

    public void setSelectedColor(Color color) {
        this.fSelectedColor = color;
        LogoPreviewPanel preview = this.getSelectedListItem();
        preview.setColor(this.getSelectedColor());
    }

    public void setStandardColors() {
        Vector previews = this.getLogoPreviewPanels();
        for (int i = 0; i < previews.size(); ++i) {
            LogoPreviewPanel preview = (LogoPreviewPanel)previews.get(i);
            preview.setColor(preview.getDefaultColor());
        }
        this.repaintAllPreviews();
    }

    public void valueChanged(ListSelectionEvent e) {
        LogoPreviewPanel selectedItem = this.getSelectedListItem();
        this.getLogoPreviewPanels().remove(selectedItem);
        this.getPreviewPanel().remove(selectedItem.getPreview());
        selectedItem.setBackground(this.fPreviewBackground);
        selectedItem.getPreview().repaint();
        this.getPreviewPanel().repaint();
        this.getLogoPreviewPanels().add(selectedItem);
        this.getPreviewPanel().add((Component)selectedItem.getPreview(), selectedItem.getKey());
        CardLayout cl = (CardLayout)this.getPreviewPanel().getLayout();
        cl.show(this.getPreviewPanel(), selectedItem.getKey());
    }

    public static void main(String[] argv) {
        ColorDialog cd = new ColorDialog();
        cd.initDefaultPreviews();
        JFrame frame = new JFrame();
        frame.getContentPane().add(cd.getColorDialogPanel());
        frame.setSize(300, 300);
        frame.show();
    }
}

