/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.textedit;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.StatusLine;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.textedit.TextEditorInfo;
import DE.siemens.ad.logo.textedit.TextEditorMenuManager;
import DE.siemens.ad.logo.textedit.TextModel;
import DE.siemens.ad.logo.textedit.TextView;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.logo.util.UntitledFile;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JToolBar;

public class TextEditor
implements Editor {
    private List fViews;
    private View fActiveView;
    private TextEditorMenuManager fMenuManager;
    private ActionManager fActionManager;
    private ActionFactory fActionFactory;
    private Application fApplication;
    private boolean fActivated;
    private ApplicationSurface fApplicationSurface;
    private View fView;
    private JToolBar fStandardToolBar;

    public void activate(ApplicationSurface applicationSurface) {
        this.fActivated = true;
        this.fApplicationSurface = applicationSurface;
        this.getApplicationSurface().getWindowManager().getToolbarPanel("Standard", "North").add(this.fStandardToolBar);
    }

    public void addView(View view) {
        this.fViews.add(view);
    }

    public void deactivate() {
    }

    public void end() {
    }

    public ApplicationSurface getApplicationSurface() {
        return this.fApplicationSurface;
    }

    public EditorInfo getEditorInfo() {
        return new TextEditorInfo();
    }

    public MenuManager getMenuManager() {
        if (this.fMenuManager == null) {
            this.fMenuManager = new TextEditorMenuManager(this);
        }
        return this.fMenuManager;
    }

    public StatusLine getStatusLine() {
        return null;
    }

    public View getView() {
        return this.fView;
    }

    public List getViews() {
        if (this.fViews == null) {
            this.fViews = new ArrayList(2);
        }
        return this.fViews;
    }

    public void init(Application application) {
        this.fApplication = application;
        this.getMenuManager().getMenuBar(application.getMenuActionGroup());
        this.fStandardToolBar = this.getMenuManager().getToolBar(application.getToolbarActionGroup());
    }

    public View loadDocument(File document, ProgressListener progressListener) {
        try {
            this.fView = new TextView(this);
            BufferedReader reader = new BufferedReader(new FileReader(document));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            TextModel textModel = new TextModel();
            textModel.setText(buffer.toString());
            this.getView().setModel(textModel);
            return this.fView;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void removeView(View view) {
        this.getViews().remove(view);
    }

    public View newDocument() {
        this.fView = new TextView(this);
        this.fView.getModel().setFile(new UntitledFile(this.getEditorInfo().getDocumentNameKey()));
        return this.fView;
    }

    public void saveDocument(File file, ProgressListener progressListener) throws IOException, ProgramException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(((TextModel)this.getView().getModel()).getText());
        writer.close();
    }

    public void setApplication(Application application) {
        this.fApplication = application;
    }

    public void setApplicationSurface(ApplicationSurface applicationSurface) {
        this.fApplicationSurface = applicationSurface;
    }

    public boolean isActivated() {
        return this.fActivated;
    }

    public Application getApplication() {
        return this.fApplication;
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
        }
        return this.fActionFactory;
    }

    public ActionManager getActionManager() {
        if (this.fActionManager == null) {
            this.fActionManager = new ActionManager(this);
        }
        return this.fActionManager;
    }

    public Window getWindow() {
        return this.getApplicationSurface().getWindow();
    }

    public void endNew() {
    }
}

