/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.BlockByNameComparator;
import DE.siemens.ad.logo.util.Memory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public abstract class CompilerToLogo
extends Visitor
implements CompilerToHardware {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected Hardware fHardware;
    protected LinkerToLogo fLinker;

    public void compile(WiringDiagram wd, Hardware hw) {
        this.fHardware = hw;
        this.init();
        Vector clone = new Vector(wd.getBlocks());
        Collections.sort(clone, new BlockByNameComparator());
        Enumeration enumeration = clone.elements();
        while (enumeration.hasMoreElements()) {
            ((Block)enumeration.nextElement()).acceptVisitor(this);
        }
    }

    public Memory getMemory(String name) throws IndexOutOfBoundsException {
        return ((Logo)this.fHardware).getMemory(name);
    }

    public void init() {
        this.fLinker = ((Logo)this.fHardware).getLinkerToHardware();
        this.clearProgram();
    }

    private void clearProgram() {
        Memory[] memArr = ((Logo)this.fHardware).getMemories();
        for (int i = 0; i < memArr.length; ++i) {
            memArr[i].init();
        }
    }

    protected void link(Block block, Memory memory) {
        this.fLinker.setMemory(memory);
        InBlockConnector[] inConnectors = block.getInConnectors();
        if (inConnectors != null) {
            for (int i = 0; i < inConnectors.length; ++i) {
                inConnectors[i].acceptVisitor(this.fLinker);
            }
        }
    }

    protected abstract void setAnchor(OutputBlock var1, String var2);

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString()).append(" - ").append(this.fHardware).append(this.fLinker);
        return buffer.toString();
    }

    public Object visit(Block block) {
        Memory memory = this.writeOpcode(block);
        this.link(block, memory);
        return null;
    }

    public Object visit(ConstantBlock constantBlock) {
        return null;
    }

    public Object visit(MarkerBlock block) {
        this.setAnchor(block, "Merker");
        return null;
    }

    public Object visit(ClockBlock block) {
        Memory memory = this.writeOpcode(block);
        this.fLinker.setMemory(memory);
        block.getParameter().acceptVisitor(this.fLinker);
        return null;
    }

    public Object visit(OutputBlock block) {
        this.setAnchor(block, "Anker Q1...Qi");
        return null;
    }

    protected abstract Memory writeOpcode(Block var1);
}

