/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AnalogComparatorParameter;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo1;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageMemory8;
import DE.siemens.ad.logo.util.ProgramMemory8;
import DE.siemens.ad.logo.util.Util;

public class CompilerFromLogo2
extends CompilerFromLogo1 {
    protected MessageLine getMessageLine(int lineNr) {
        MessageLine result = null;
        MessageMemory8 msgMemory = (MessageMemory8)this.fHardware.getMemory("Meldetext");
        int[] line = msgMemory.getMemoryBlock(lineNr);
        if (line[0] == 255) {
            result = new MessageLine();
        } else if (line[0] == 1) {
            byte[] bytes = new byte[line.length];
            StringBuffer buffer = new StringBuffer();
            int j = 1;
            while (line[j] != 0) {
                bytes[j] = (byte)line[j];
                ++j;
            }
            byte[] strBytes = new byte[--j];
            System.arraycopy(bytes, 1, strBytes, 0, j);
            result = new MessageLine();
            result.setText(new String(strBytes));
        } else if (line[0] == 2) {
            result = new MessageLine();
            Block block = ((ProgramMemory8)this.fHardware.getMemory("Program")).getBlock(this.convertToBlockNumber(line[1]));
            BlockParameter parameter = block.getParameter();
            result.setText(parameter, line[3]);
            parameter.addParameterUpdateListener(result);
            parameter.addParameterSetListener(result);
        } else {
            result = new MessageLine();
            System.out.println("Warnung: MessagelineID " + line[0] + " unbekannt");
        }
        return result;
    }

    public MessageLine[] getMessageLines(int msgNr) {
        int startLine = msgNr * 4;
        MessageMemory8 msgMemory = (MessageMemory8)this.fHardware.getMemory("Meldetext");
        MessageLine[] msgLines = new MessageLine[4];
        for (int i = 0; i < 4; ++i) {
            msgLines[i] = this.getMessageLine(startLine++);
            msgLines[i].setLineNumber(i);
        }
        return msgLines;
    }

    public Object visit(AnalogComparatorParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setProtection(hwMemory[0] == 240);
        param.setGain(Util.makeSignedWord(hwMemory[1], hwMemory[2]));
        hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setOffset(Util.makeSignedWord(hwMemory[1], hwMemory[2]));
        hwMemory = this.getParameterMemory().getMemoryBlock();
        int trigger = Util.makeSignedWord(hwMemory[1], hwMemory[2]);
        param.setOn(trigger);
        param.setOff(trigger);
        return null;
    }

    public Object visit(AnalogTriggerParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setProtection(hwMemory[0] == 240);
        param.setGain(Util.makeSignedWord(hwMemory[1], hwMemory[2]));
        hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setOffset(Util.makeSignedWord(hwMemory[1], hwMemory[2]));
        hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setOnTrigger(Util.makeSignedWord(hwMemory[1], hwMemory[2]));
        hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setOffTrigger(Util.makeSignedWord(hwMemory[1], hwMemory[2]));
        return null;
    }

    public Object visit(MessageParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setPriority(new Integer(hwMemory[1] & 0x7F));
        param.setReceipt((hwMemory[1] & 0x80) > 0);
        param.setMessage(this.getMessageLines(hwMemory[2]));
        return null;
    }

    public Object visit(Time2ProtectionParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setProtection(hwMemory[0] == 240);
        param.getHTimer().setParamTime(this.getNewTimeObject(hwMemory[1], hwMemory[2]));
        hwMemory = this.getParameterMemory().getMemoryBlock();
        param.getLTimer().setParamTime(this.getNewTimeObject(hwMemory[1], hwMemory[2]));
        return null;
    }
}

