/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AsymPulseGeneratorParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.ModeUniversal;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.PseudoParameter;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.ParameterMemory8;
import DE.siemens.ad.logo.util.ProgramMemory8;
import DE.siemens.ad.logo.util.Util;

public class CompilerFromLogo0
extends CompilerFromLogo {
    public static final short BLOCK_NR_TO_PROGLINE_OFFSET = 1;
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected static final int EE_USED = 240;
    private ParameterMemory8 fParameterMemory;
    protected int fInputNumber;

    public WiringDiagram compile(Hardware hw) {
        int i;
        this.init(hw);
        Memory[] memArr = ((Logo)hw).getMemories();
        for (i = 0; i < memArr.length; ++i) {
            memArr[i].createBlocks(this.fWiringDiagram, this);
        }
        for (i = 0; i < memArr.length; ++i) {
            memArr[i].createReferences(this);
        }
        return this.fWiringDiagram;
    }

    public int convertToBlockNumber(int progLine) {
        return progLine - 1;
    }

    protected ParameterMemory8 getParameterMemory() {
        return this.fParameterMemory;
    }

    public void init(Hardware hw) {
        super.init(hw);
        this.fParameterMemory = (ParameterMemory8)((Logo)hw).getMemory("Parameter");
    }

    public void setReference(Block srcObj, int dstReference, int input) throws IllegalArgumentException {
        Block dstBlock = null;
        InBlockConnector inConnector = null;
        switch (dstReference & 0xC0) {
            case 0: {
                try {
                    inConnector = srcObj.getInConnector(input);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.error(e, "No Input " + (input + 1) + "at Block " + srcObj.toString());
                    throw new IllegalArgumentException();
                }
                OutBlockConnector outConnector = ((ProgramMemory8)this.fHardware.getMemory("Program")).getBlock(this.convertToBlockNumber(dstReference)).getOutConnector(0);
                inConnector.connect(outConnector);
                break;
            }
            case 64: {
                this.getParameterMemory().setPosition(dstReference - 64, 0);
                this.fInputNumber = input;
                srcObj.getParameter().acceptVisitor(this);
            }
            case 128: {
                if ((dstReference & 0xB0) != 176) break;
                BlockParameter parameter = srcObj.getParameter();
                parameter.setRemanenceAvailable(true);
                parameter.getRemanenceObject().setRemanence(true);
                break;
            }
            case 192: {
                int dstBlockNumber;
                if (!CompilerFromLogo0.isReference(dstReference)) break;
                try {
                    inConnector = srcObj.getInConnector(input);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.error(e, "No Input " + (input + 1) + "at Block " + srcObj.toString());
                    throw new IllegalArgumentException();
                }
                try {
                    dstBlockNumber = this.fHardware.calculateBlockNumber(dstReference);
                }
                catch (IllegalArgumentException e) {
                    Log.error(e, "Couldn't resolve reference to Constant");
                    throw e;
                }
                dstBlock = this.fWiringDiagram.getBlock(dstReference, dstBlockNumber);
                if (dstBlock == null) {
                    dstBlock = this.fWiringDiagram.createBlock(dstReference, dstBlockNumber);
                }
                OutBlockConnector outConnector = dstBlock.getOutConnector(0);
                inConnector.connect(outConnector);
            }
        }
    }

    public Object visit(AsymPulseGeneratorParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setProtection(hwMemory[0] == 240);
        param.getHTimer().setParamTime(this.getNewTimeObject(hwMemory[1], hwMemory[2]));
        this.getParameterMemory().getMemoryBlock();
        hwMemory = this.getParameterMemory().getMemoryBlock();
        param.getLTimer().setParamTime(this.getNewTimeObject(hwMemory[1], hwMemory[2]));
        return null;
    }

    public Object visit(CamParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setProtection(hwMemory[0] == 240);
        if (Util.makeSignedWord(hwMemory[1], hwMemory[2]) < 0) {
            param.getOnTime().setInactive(true);
        } else {
            ClockHours onTime = (ClockHours)this.getNewTimeObject(hwMemory[1], hwMemory[2]);
            onTime.setInactive(false);
            param.setOnTime(onTime);
        }
        hwMemory = this.getParameterMemory().getMemoryBlock();
        ((ModeUniversal)param.getAvailableModes()[11]).setLogoMode(hwMemory[0] & 0x7F);
        if (Util.makeSignedWord(hwMemory[1], hwMemory[2]) < 0) {
            param.getOffTime().setInactive(true);
        } else {
            ClockHours offTime = (ClockHours)this.getNewTimeObject(hwMemory[1], hwMemory[2]);
            offTime.setInactive(false);
            param.setOffTime(offTime);
        }
        return null;
    }

    public Object visit(ClockParameter param) {
        param.getCam(this.fInputNumber).acceptVisitor(this);
        return null;
    }

    public Object visit(CounterParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setProtection(hwMemory[0] == 240);
        param.setLim(Util.makeSignedWord(hwMemory[1], hwMemory[2]));
        return null;
    }

    public Object visit(PseudoParameter param) {
        return null;
    }

    public Object visit(TimeProtectionParameter param) {
        int[] hwMemory = this.getParameterMemory().getMemoryBlock();
        param.setProtection(hwMemory[0] == 240);
        param.getTimer().setParamTime(this.getNewTimeObject(hwMemory[1], hwMemory[2]));
        return null;
    }
}

