/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Util;

public abstract class CompilerFromLogo
extends Visitor
implements CompilerFromHardware {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected WiringDiagram fWiringDiagram;
    protected Logo fHardware;
    public static final int REFTYPE_PROGLINE = 0;
    public static final int REFTYPE_PARAMETER = 64;
    public static final int REFTYPE_RAM = 128;
    public static final int REFTYPE_TIMER = 128;
    public static final int REFTYPE_REM = 176;
    public static final int REFTYPE_PA_CONST = 192;
    public static int REF_NC = 252;

    public abstract WiringDiagram compile(Hardware var1) throws ProgramException;

    public int convertToBlockNumber(int progLine) {
        throw new RuntimeException("Method Hardware.convertToBlockNumber(int) not redefined");
    }

    protected void init(Hardware hw) {
        this.fHardware = (Logo)hw;
        this.fWiringDiagram = new WiringDiagram(hw);
    }

    public static boolean isOpcode(int opcode) {
        return opcode != 255 && opcode != 0;
    }

    public static boolean isReference(int ref) {
        return !(ref == 252 | ref == 255);
    }

    public TimeUnit getNewTimeObject(int highByte, int lowByte) {
        TimeUnit retValue = null;
        int timeValue = Util.makeSignedWord(highByte, lowByte);
        int timeBase = timeValue & 0xC000;
        timeValue &= 0x3FFF;
        switch (timeBase) {
            case 0: {
                retValue = new ClockHours();
                retValue.setTime(timeValue / 60, timeValue % 60);
                break;
            }
            case 16384: {
                retValue = new Seconds();
                retValue.setTime(timeValue / 20, timeValue % 20 * 5);
                break;
            }
            case 32768: {
                retValue = new Minutes();
                retValue.setTime(timeValue / 60, timeValue % 60);
                break;
            }
            case 49152: {
                retValue = new Hours();
                retValue.setTime(timeValue / 60, timeValue % 60);
                break;
            }
            default: {
                retValue = new Seconds();
                Log.out.println("Error calculating a new Time. I take a default Value of 0 seconds.");
            }
        }
        return retValue;
    }
}

