/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.dialog.comp.TimeValueOrReferencePanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.WipingRelayPECParameter;
import DE.siemens.ad.logo.model.panel.TimeProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WipingRelayPECPanel
extends TimeProtectionPanel {
    private TimeValueOrReferencePanel fBreakTime;
    private JComboBox fCycles;
    private JLabel fCyclesLabel;

    public WipingRelayPECPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.addComponents(parameterReference);
        if (!((BlockParameter)parameterReference).getBlock().getWiringDiagram().getHardware().supports("comfortSwitchResetWarning")) {
            this.setAdditionalComponents(false);
        }
    }

    private void addComponents(Parameter parameterReference) {
        this.paramPane.setLayout(new BoxLayout(this.paramPane, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        WipingRelayPECParameter param = (WipingRelayPECParameter)this.fParameterReference;
        Hardware hw = param.getBlock().getHardware();
        TimeUnit[] availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
        Timer timer = param.getBreakTimer();
        timer.setNameKey("dialog.parameter.wipingRelayPEC.breakTime");
        timer.convertTimerTo(availableTimeUnits);
        this.fBreakTime = new TimeValueOrReferencePanel(timer);
        Block block = ((TimeProtectionParameter)this.fParameterReference).getBlock();
        this.fBreakTime.setReferenceList(block.getWiringDiagram().getBlocksForReference(block, true));
        this.fBreakTime.setReferenceVisability(parameterReference.isValueOrReference());
        panel.add(this.fBreakTime);
        JPanel cyclePanel = new JPanel(new FlowLayout(0));
        this.fCyclesLabel = new JLabel();
        cyclePanel.add(this.fCyclesLabel);
        this.fCycles = new JComboBox();
        cyclePanel.add(this.fCycles);
        panel.add(cyclePanel);
        this.paramPane.add(panel);
    }

    private void setAdditionalComponents(boolean visible) {
        this.fBreakTime.setVisible(visible);
        this.fCycles.setVisible(visible);
        this.fCyclesLabel.setVisible(visible);
    }

    public boolean checkChanged() {
        if (super.checkChanged()) {
            return true;
        }
        if (this.fBreakTime.checkChanged()) {
            return true;
        }
        WipingRelayPECParameter param = (WipingRelayPECParameter)this.getParameterReference();
        return ((Integer)this.fCycles.getSelectedItem()).intValue() != param.getCycles();
    }

    public boolean checkFieldContents() {
        if (!super.checkFieldContents()) {
            return false;
        }
        return this.fBreakTime.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        WipingRelayPECParameter param = (WipingRelayPECParameter)this.fParameterReference;
        this.fBreakTime.loadFieldContents();
        DefaultComboBoxModel<Integer> comboBoxModel = new DefaultComboBoxModel<Integer>();
        for (int i = 1; i < 10; ++i) {
            Integer value = new Integer(i);
            comboBoxModel.addElement(value);
        }
        this.fCycles.setModel(comboBoxModel);
        this.fCycles.setSelectedIndex(param.getCycles() - 1);
    }

    public void setLabels() {
        super.setLabels();
        this.fBreakTime.setLabels();
        this.fCyclesLabel.setText(Language.getString("dialog.parameter.wipingRelayPEC.cycles", "Cycles"));
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        this.fBreakTime.storeFieldContents();
        WipingRelayPECParameter param = (WipingRelayPECParameter)this.fParameterReference;
        param.setCycles(this.fCycles.getSelectedIndex() + 1);
    }
}

