/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ShiftRegisterParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShiftRegisterPanel
extends BlockParameterPanel {
    private JComboBox fShiftRegisterOutput;
    private JLabel fShiftRegisterLabel;

    public ShiftRegisterPanel(Vector panels, Parameter parameterReference, boolean simulation) {
        super(panels, parameterReference, simulation);
        JPanel shiftRegisterPanel = new JPanel();
        shiftRegisterPanel.setLayout(new FlowLayout(0, 5, 5));
        this.fShiftRegisterLabel = new JLabel("Shfit register for output");
        shiftRegisterPanel.add(this.fShiftRegisterLabel);
        this.fShiftRegisterOutput = new JComboBox();
        shiftRegisterPanel.add(this.fShiftRegisterOutput);
        this.addParameterPane(shiftRegisterPanel);
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        ShiftRegisterParameter shiftRegisterParameter = (ShiftRegisterParameter)this.fParameterReference;
        WiringDiagram wiringDiagram = shiftRegisterParameter.getBlock().getWiringDiagram();
        Hardware hardware = wiringDiagram.getHardware();
        int maxShiftRegisterInputNumbers = hardware.getMaxResource(19);
        Integer selectedItem = null;
        DefaultComboBoxModel<Integer> comboBoxModel = new DefaultComboBoxModel<Integer>();
        for (int i = 0; i < maxShiftRegisterInputNumbers; ++i) {
            Integer currentShiftRegisterOutput = new Integer(i + 1);
            comboBoxModel.addElement(currentShiftRegisterOutput);
            if (i != shiftRegisterParameter.getOutputBit()) continue;
            selectedItem = currentShiftRegisterOutput;
        }
        this.fShiftRegisterOutput.setModel(comboBoxModel);
        if (selectedItem != null) {
            this.fShiftRegisterOutput.setSelectedItem(selectedItem);
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        ShiftRegisterParameter shiftRegisterParameter = (ShiftRegisterParameter)this.fParameterReference;
        int bitNumber = (Integer)this.fShiftRegisterOutput.getSelectedItem() - 1;
        shiftRegisterParameter.setOutputBit(bitNumber);
    }

    public boolean checkChanged() {
        boolean changed = super.checkChanged();
        ShiftRegisterParameter shiftRegisterParameter = (ShiftRegisterParameter)this.fParameterReference;
        changed = changed || !new Integer(shiftRegisterParameter.getOutputBit() + 1).equals(this.fShiftRegisterOutput.getSelectedItem());
        return changed;
    }

    public boolean checkFieldContents() {
        boolean check = super.checkFieldContents();
        return this.fShiftRegisterOutput.getSelectedItem() != null;
    }

    public void setLabels() {
        super.setLabels();
        this.fShiftRegisterLabel.setText(Language.getString("dialog.parameter.shiftRegister.outputBit", "Bit for output"));
    }
}

