/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.dialog.comp.display.AIDetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.ExtenalMoveModel;
import DE.siemens.ad.logo.dialog.comp.display.IONameDetailsDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageEditorPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private JLabel fMessageLabel = null;
    private LogoDisplay fMessageDisplay = null;
    private JLabel fUnusedLabel = null;
    private LogoDisplay fUnusedDisplay = null;
    private staticModel fMessageModel;
    private staticModel fUnusedModel;
    MessageParameterDisplayModelRTF fMessageParameterDisplayModelRTF;
    private JLabel fTextLabel = null;
    private JTextArea fTextArea;
    private DisplayElement fInsertedElement = null;
    private Point fEditedCell = null;

    public MessageEditorPanel(MessageParameterDisplayModelRTF model) {
        this.initialize(model);
    }

    public void setElementToCycleBin(DisplayElement disp) {
        this.fInsertedElement = disp;
    }

    public void setCellToBeMoved(Point cell) {
        this.fEditedCell = cell;
    }

    public String getTitle() {
        return "Static editor";
    }

    private void initialize(MessageParameterDisplayModelRTF model) {
        this.fMessageParameterDisplayModelRTF = model;
        this.setLayout(new BoxLayout(this, 3));
        this.fMessageModel = new staticModel(model);
        this.fMessageDisplay = new LogoDisplay();
        this.fMessageDisplay.setModel(this.fMessageModel);
        this.initLogoDisplay(this.fMessageDisplay);
        this.fMessageDisplay.setDefaultCellEditor(new OneCharacterCellEditor());
        this.fUnusedModel = new staticModel(model);
        this.fUnusedModel.clearAll();
        this.fUnusedDisplay = new LogoDisplay();
        this.fUnusedDisplay.setModel(this.fUnusedModel);
        this.initLogoDisplay(this.fUnusedDisplay);
        this.fMessageLabel = new JLabel();
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new BoxLayout(msgPanel, 3));
        this.addComponentLeft(msgPanel, this.fMessageLabel);
        this.addComponentLeft(msgPanel, this.fMessageDisplay);
        msgPanel.add(Box.createRigidArea(new Dimension(5, 15)));
        this.addComponentCenter(this, msgPanel);
        this.addComponentCenter(this, this.getToolBarPanel());
        this.fUnusedLabel = new JLabel();
        JPanel unusedPanel = new JPanel();
        unusedPanel.setLayout(new BoxLayout(unusedPanel, 3));
        this.addComponentLeft(unusedPanel, this.fUnusedLabel);
        this.addComponentLeft(unusedPanel, this.fUnusedDisplay);
        unusedPanel.add(Box.createRigidArea(new Dimension(5, 15)));
        this.addComponentCenter(this, unusedPanel);
        this.fTextLabel = new JLabel();
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 3));
        this.addComponentLeft(textPanel, this.fTextLabel);
        this.addComponentLeft(textPanel, this.getTextArea());
        this.addComponentCenter(this, textPanel);
        this.fMessageModel.setTextListener(this.fTextArea);
        this.fUnusedModel.setTextListener(this.fTextArea);
    }

    private void addComponentLeft(JPanel parent, JComponent child) {
        child.setAlignmentX(0.0f);
        parent.add(child);
    }

    private void addComponentCenter(JPanel parent, JComponent child) {
        child.setAlignmentX(0.5f);
        parent.add(child);
    }

    private void initLogoDisplay(LogoDisplay display) {
        display.setCellRenderer(ParameterItem.class, new DetailsParameterDisplayCellRenderer());
        display.setCellRenderer(BarDisplayElement.class, new BarDetailsParameterDisplayCellRenderer());
        display.setCellRenderer(AIDisplayElement.class, new AIDetailsParameterDisplayCellRenderer());
        display.setCellRenderer(IONameDisplayElement.class, new IONameDetailsDisplayCellRenderer());
        display.setDragEnabled(true);
        display.setDropEnabled(true);
    }

    private JPanel getToolBarPanel() {
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 0));
        RolloverButton copyDown = new RolloverButton(Global.getIcon("Next.gif"));
        toolbarPanel.add(copyDown);
        copyDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageEditorPanel.this.copyElements(MessageEditorPanel.this.fUnusedDisplay, MessageEditorPanel.this.fMessageDisplay);
            }
        });
        copyDown.setToolTipText(Language.getString("dialog.parameter.message.EditManually.toRecycleBinTip", "Move down"));
        RolloverButton copyUp = new RolloverButton(Global.getIcon("Previous.gif"));
        toolbarPanel.add(copyUp);
        copyUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageEditorPanel.this.copyElements(MessageEditorPanel.this.fMessageDisplay, MessageEditorPanel.this.fUnusedDisplay);
            }
        });
        copyUp.setToolTipText(Language.getString("dialog.parameter.message.EditManually.toTextAreaTip", "Move up"));
        return toolbarPanel;
    }

    private JScrollPane getTextArea() {
        this.fTextArea = new JTextArea("", 5, 60);
        this.fTextArea.setLineWrap(true);
        this.fTextArea.setWrapStyleWord(true);
        this.fTextArea.setEditable(false);
        JScrollPane textAreaPane = new JScrollPane(this.fTextArea, 20, 31);
        Dimension d = this.fUnusedDisplay.getPreferredSize();
        textAreaPane.setPreferredSize(new Dimension(d.width, d.height / 2));
        textAreaPane.setMinimumSize(textAreaPane.getPreferredSize());
        textAreaPane.setMaximumSize(textAreaPane.getPreferredSize());
        return textAreaPane;
    }

    protected void copyElements(LogoDisplay dest, LogoDisplay src) {
        staticModel destModel;
        if (dest == null || src == null || dest == src) {
            return;
        }
        staticModel srcModel = (staticModel)src.getModel();
        List cells = src.getSelectedCells();
        if (cells.size() == 0) {
            if (srcModel.getElementAt(src.getFocusPosition()) != null) {
                cells.add(src.getFocusPosition());
            } else {
                return;
            }
        }
        if ((destModel = (staticModel)dest.getModel()).moveCellsFrom(srcModel, cells, dest.getFocusPosition())) {
            src.clearSelection();
            dest.clearSelection();
            src.repaint();
            dest.repaint();
        }
    }

    public void setLabels() {
        this.fMessageLabel.setText(Language.getString("dialog.parameter.message.EditManually.MessageTextArea", "Message Text Area"));
        this.fUnusedLabel.setText(Language.getString("dialog.parameter.message.EditManually.RecycleBin", "Recycle Bin"));
        this.fTextLabel.setText(Language.getString("dialog.parameter.message.EditManually.InfoWindow", "Info Window"));
        this.fTextArea.setText(Language.getString("dialog.parameter.message.EditManually.Desription1", "The static editor allows you to move, add, or delete message text elements without changing the position of any other elements.") + " " + Language.getString("dialog.parameter.message.EditManually.Desription2", "Drag and drop to and from the recycle bin to simplify moving and repositioning elements."));
    }

    public Dimension getPreferredSize() {
        Dimension ret = new Dimension(500, 256);
        if (this.fMessageDisplay != null) {
            Dimension base = this.fMessageDisplay.getPreferredSize();
            ret.setSize(base.width + 50, base.height * 3 + 50);
        }
        return ret;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean checkFieldContents() {
        if (!this.isEmptyRecycleBin()) {
            return new LogoError(null, "dialog.parameter.message.EditManually.RecycleBinNotEmpty", "Delete contents in Recycle Bin?", 2, 1).display() == 0;
        }
        return true;
    }

    private boolean isEmptyRecycleBin() {
        Dimension d = this.fUnusedModel.getDisplayDimension();
        for (int x = 0; x < d.width; ++x) {
            for (int y = 0; y < d.height; ++y) {
                if (this.fUnusedModel.isWriteableCell(x, y, null)) continue;
                return false;
            }
        }
        return true;
    }

    public void loadFieldContents() throws ProgramException {
        if (this.fEditedCell != null) {
            DisplayElement disp = this.fMessageModel.getElementAt(this.fEditedCell);
            this.fMessageModel.getDisplayElements()[this.fEditedCell.x][this.fEditedCell.y] = null;
            this.fUnusedModel.getDisplayElements()[this.fEditedCell.x][this.fEditedCell.y] = disp;
        } else if (this.fInsertedElement != null) {
            this.fUnusedModel.getDisplayElements()[0][0] = this.fInsertedElement;
        }
    }

    public void storeFieldContents() {
        this.fMessageParameterDisplayModelRTF.setDisplayElemets(this.fMessageModel.getDisplayElementsClone());
    }

    protected static class staticModel
    extends MessageParameterDisplayModelRTF
    implements ExtenalMoveModel {
        private String errText = null;
        private JTextArea fTextArea = null;

        public staticModel(MessageParameterDisplayModelRTF model) {
            super(model.getMessageParameter(), model.getCharSetID(), 0);
            this.fDisplayElements = model.getDisplayElementsClone();
        }

        public String getErrText() {
            return this.errText;
        }

        private void setErrText(String newText) {
            this.errText = newText;
            if (this.fTextArea != null) {
                if (this.fTextArea.getText().length() > 60) {
                    this.fTextArea.setText(this.errText);
                } else if (this.errText == null) {
                    this.fTextArea.setText(null);
                } else {
                    this.fTextArea.setText(this.fTextArea.getText() + "\n" + this.errText);
                }
            }
        }

        public void setTextListener(JTextArea listener) {
            this.fTextArea = listener;
        }

        public void clearAll() {
            for (int i = 0; i < this.fDisplayDimension.width; ++i) {
                for (int j = 0; j < this.fDisplayDimension.height; ++j) {
                    this.fDisplayElements[i][j] = null;
                }
            }
        }

        public boolean canInsert(DisplayElement displayElement, Point destination) {
            if (displayElement == null) {
                return false;
            }
            if (displayElement.getWidth() + destination.x > this.fDisplayDimension.width || displayElement.getHeight() + destination.y > this.fDisplayDimension.height) {
                return false;
            }
            for (int x = 0; x < displayElement.getWidth(); ++x) {
                for (int y = 0; y < displayElement.getHeight(); ++y) {
                    if (this.isWriteableCell(destination.x + x, destination.y + y, null)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean deleteElement(Point location) {
            this.fDisplayElements[location.x][location.y] = null;
            this.fireModelChangedEvent();
            return true;
        }

        public boolean insertElement(DisplayElement displayElement, Point destination) {
            if (!this.canInsert(displayElement, destination)) {
                return false;
            }
            this.fDisplayElements[destination.x][destination.y] = displayElement;
            this.fireModelChangedEvent();
            return true;
        }

        public boolean moveCells(List cells, Point destination) {
            ArrayList<DisplayElement> elements = new ArrayList<DisplayElement>(cells.size());
            ArrayList<Point> toBeEmptyPoints = new ArrayList<Point>();
            for (Point cell : cells) {
                elements.add(this.getElementAt(cell));
                Rectangle r = this.getElementBounds(cell);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    for (int y = r.y; y < r.y + r.height; ++y) {
                        toBeEmptyPoints.add(new Point(x, y));
                    }
                }
            }
            Point upperLeftCorner = this.getUpperLeftCorner(cells);
            int xOffset = destination.x - upperLeftCorner.x;
            int yOffset = destination.y - upperLeftCorner.y;
            if (this.isAreaEmpty(this, cells, xOffset, yOffset, toBeEmptyPoints)) {
                this.deleteCells(cells);
                Iterator cellsIterator = cells.iterator();
                Iterator elementsIterator = elements.iterator();
                while (cellsIterator.hasNext()) {
                    Point cell = (Point)cellsIterator.next();
                    DisplayElement element = (DisplayElement)elementsIterator.next();
                    Point destinationPoint = new Point(cell);
                    destinationPoint.translate(xOffset, yOffset);
                    this.insertElement(element, destinationPoint);
                }
                return true;
            }
            this.setErrText(Language.getString("dialog.parameter.message.EditManually.errorCanNotMoveTo", "Can not move the area to here."));
            return true;
        }

        protected boolean canMoveCellLeft(Rectangle selectArea) {
            return true;
        }

        protected boolean canMoveCellRight(Rectangle selectArea) {
            return true;
        }

        public boolean deleteCells(List cells) {
            return super.deleteCells(cells);
        }

        private boolean isWriteableCell(int x, int y, List emptyList) {
            if (emptyList != null && emptyList.contains(new Point(x, y))) {
                return true;
            }
            DisplayElement disp = this.getElementAt(new Point(x, y));
            if (!(disp == null || disp instanceof DefaultDisplayElement && ((DefaultDisplayElement)disp).getUserObject().equals(" "))) {
                System.out.println("Can not cover: " + disp + " at (" + x + "," + y + ")");
                return false;
            }
            return true;
        }

        private boolean isAreaEmpty(DisplayModel srcModel, List cells, int xOffset, int yOffset, List emptyList) {
            Rectangle displayRectangle = new Rectangle(0, 0, this.fDisplayDimension.width, this.fDisplayDimension.height);
            for (Point cell : cells) {
                Rectangle rect = srcModel.getElementBounds(cell);
                Rectangle rect1 = new Rectangle(rect);
                rect1.translate(xOffset, yOffset);
                if (!displayRectangle.contains(rect1)) {
                    this.setErrText(Language.getString("dialog.parameter.message.EditManually.errorOutOfRange", "Out of range"));
                    return false;
                }
                for (int x = rect.x; x < rect.x + rect.width; ++x) {
                    for (int y = rect.y; y < rect.y + rect.height; ++y) {
                        if (this.isWriteableCell(x + xOffset, y + yOffset, emptyList)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        public boolean moveCellsFrom(ExtenalMoveModel srcModel, List cells, Point destPoint) {
            if (srcModel == this) {
                return false;
            }
            Point upperLeftCorner = this.getUpperLeftCorner(cells);
            int xOffset = destPoint.x - upperLeftCorner.x;
            int yOffset = destPoint.y - upperLeftCorner.y;
            if (this.isAreaEmpty(srcModel, cells, xOffset, yOffset, null)) {
                for (Point cell : cells) {
                    Rectangle rect = srcModel.getElementBounds(cell);
                    for (int x = rect.x; x < rect.x + rect.width; ++x) {
                        for (int y = rect.y; y < rect.y + rect.height; ++y) {
                            this.getDisplayElements()[x + xOffset][y + yOffset] = srcModel.getDisplayElements()[x][y];
                            srcModel.getDisplayElements()[x][y] = null;
                        }
                    }
                }
                this.setErrText(null);
            } else {
                this.setErrText(Language.getString("dialog.parameter.message.EditManually.errorCanNotMoveTo", "Can not move the area to here."));
            }
            return true;
        }

        public boolean isCellEditable(Point location) {
            return super.isCellEditable(location);
        }

        public DisplayElement[][] getDisplayElements() {
            return this.fDisplayElements;
        }
    }
}

