/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HoursCounterTimebaseHourPanel
extends AbstractProtectionPanel {
    private BorderJPanel fBorderPanel;
    private EditableNumericSpinner fTimeInterval;
    private JLabel fTimeIntervalLabel;
    private JCheckBox fOutputBehavior;
    private JLabel fOperatingTimeLabel;
    private EditableNumericSpinner fOperatingTimeStart;
    private JLabel fTimeIntervalUnitLabel;
    private JLabel fOperatingTimeUnitLabel;

    public HoursCounterTimebaseHourPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.initialize((HoursCounterParameter)parameterReference);
    }

    private void initialize(HoursCounterParameter parameterReference) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.addParameterPane(panel);
        GridBagConstraints gbc = null;
        this.fTimeIntervalLabel = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        panel.add((Component)this.fTimeIntervalLabel, gbc);
        this.fTimeInterval = new EditableNumericSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.fTimeInterval, gbc);
        this.fTimeIntervalUnitLabel = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        panel.add((Component)this.fTimeIntervalUnitLabel, gbc);
        this.fOperatingTimeLabel = new JLabel();
        this.fOperatingTimeLabel.setAlignmentY(0.0f);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        panel.add((Component)this.fOperatingTimeLabel, gbc);
        this.fOperatingTimeStart = new EditableNumericSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.fOperatingTimeStart, gbc);
        this.fOperatingTimeUnitLabel = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        panel.add((Component)this.fOperatingTimeUnitLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)new JPanel(), gbc);
        this.fOutputBehavior = new JCheckBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        panel.add((Component)this.fOutputBehavior, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        panel.add((Component)new JPanel(), gbc);
        if (!parameterReference.getBlock().getWiringDiagram().getHardware().supports("extHourscounter")) {
            this.fOperatingTimeLabel.setVisible(false);
            this.fOperatingTimeStart.setVisible(false);
            this.fOperatingTimeUnitLabel.setVisible(false);
            this.fOutputBehavior.setVisible(false);
        }
    }

    public boolean checkChanged() {
        HoursCounterParameter param = (HoursCounterParameter)this.fParameterReference;
        if (this.fTimeInterval.getValue() * 60 != param.getMI_Minute()) {
            return true;
        }
        if (this.fOperatingTimeStart.getValue() * 60 != param.getOTStart_Minute()) {
            return true;
        }
        if (this.fOutputBehavior.isSelected() != param.isOutputIndependentOfEn()) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!this.fTimeInterval.checkValue(true)) {
            this.fTimeInterval.requestFocus();
            return false;
        }
        if (!this.fOperatingTimeStart.checkValue(true)) {
            this.fOperatingTimeStart.requestFocus();
            return false;
        }
        return super.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        HoursCounterParameter param = (HoursCounterParameter)this.fParameterReference;
        IntValueProperties MIProp = this.getIntProp(param.getMIProperties());
        this.fTimeInterval.setProperties(MIProp);
        IntValueProperties OTStartProp = this.getIntProp(param.getOperatingTimeStart());
        this.fOperatingTimeStart.setProperties(OTStartProp);
        this.fOutputBehavior.setSelected(param.isOutputIndependentOfEn());
        this.getRemanenceField().setEnabled(false);
    }

    public void setLabels() {
        super.setLabels();
        this.fTimeIntervalLabel.setText(Language.getString("dialog.parameter.hoursCounter.maintenanceInterval", "Maintenance interval"));
        this.fOutputBehavior.setText(Language.getString("dialog.parameter.hoursCounter.outputBehavior", "Reset output on En==0"));
        this.fOperatingTimeLabel.setText(Language.getString("dialog.parameter.hoursCounter.totalTimeStart", "OperatingStartTime"));
        String hours = Language.getString("dialog.hoursCounter.hours", "Hours");
        this.fTimeIntervalUnitLabel.setText(hours);
        this.fOperatingTimeUnitLabel.setText(hours);
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        ((HoursCounterParameter)this.fParameterReference).setMaintenanceInterval(this.fTimeInterval.getValue());
        ((HoursCounterParameter)this.fParameterReference).setOutputSeparatedFromEn(this.fOutputBehavior.isSelected());
        ((HoursCounterParameter)this.fParameterReference).setOperatingTimeStart(this.fOperatingTimeStart.getValue() * 60);
    }

    private IntValueProperties getIntProp(TimeValueProperties prop) {
        return prop.getCurrentValue().getHigh();
    }
}

