/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.LinePanel;
import DE.siemens.ad.logo.dialog.comp.TimeValueOrReferencePanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.FrequencyParameter;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FrequencyPanel
extends AbstractProtectionPanel {
    BorderJPanel borderJPanel1;
    JLabel lOnThreshold;
    JLabel lOffThreshold;
    EditableNumericSpinner onThreshold;
    EditableNumericSpinner offThreshold;
    BorderJPanel borderJPanel2;
    TimeValueOrReferencePanel gateTime;

    public FrequencyPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        LinePanel panel = new LinePanel();
        this.addParameterPane(panel);
        this.borderJPanel1 = new BorderJPanel();
        panel.add((Component)this.borderJPanel1);
        this.lOnThreshold = new JLabel();
        this.lOnThreshold.setText(Language.getString("model.panel.frequenzPanel.up", "up"));
        this.lOnThreshold.setBounds(12, 12, 96, 24);
        this.borderJPanel1.add(this.lOnThreshold);
        this.lOffThreshold = new JLabel();
        this.lOffThreshold.setText(Language.getString("model.panel.frequenzPanel.down", "down"));
        this.lOffThreshold.setBounds(100, 12, 96, 24);
        this.borderJPanel1.add(this.lOffThreshold);
        this.borderJPanel1.add(new JPanel());
        this.onThreshold = new EditableNumericSpinner();
        this.onThreshold.setPeriodicDelay(25);
        this.onThreshold.setMax(9999);
        this.onThreshold.setLayout(null);
        this.onThreshold.setBounds(12, 36, 72, 24);
        this.borderJPanel1.add(this.onThreshold);
        this.offThreshold = new EditableNumericSpinner();
        this.offThreshold.setMax(9999);
        this.offThreshold.setLayout(null);
        this.offThreshold.setBounds(100, 36, 72, 24);
        this.borderJPanel1.add(this.offThreshold);
        this.borderJPanel1.add(new JPanel());
        this.borderJPanel1.add(new JPanel());
        this.borderJPanel2 = new BorderJPanel(new FlowLayout(0));
        panel.add((Component)this.borderJPanel2);
        Timer timer = ((FrequencyParameter)this.fParameterReference).getTimeInterval();
        timer.convertTimerTo(new TimeUnit[]{new HighResolutionSeconds()});
        this.gateTime = new TimeValueOrReferencePanel(timer){

            protected TimeUnit[] getTimeUnitsForReference() {
                return new TimeUnit[]{new HighResolutionSeconds()};
            }
        };
        this.gateTime.setName("gateTime");
        this.gateTime.setBounds(17, 106, 291, 60);
        this.gateTime.setReferenceVisability(parameterReference.isValueOrReference());
        Block lBlock = ((BlockParameter)this.fParameterReference).getBlock();
        this.gateTime.setReferenceList(lBlock.getWiringDiagram().getBlocksForReference(lBlock, true));
        this.borderJPanel2.add(this.gateTime);
    }

    public boolean checkChanged() {
        FrequencyParameter tp = (FrequencyParameter)this.fParameterReference;
        if (this.onThreshold.getValue() != tp.getOnThreshold().getCurrentValue()) {
            return true;
        }
        if (this.offThreshold.getValue() != tp.getOffThreshold().getCurrentValue()) {
            return true;
        }
        if (this.gateTime.checkChanged()) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        FrequencyParameter tp = (FrequencyParameter)this.fParameterReference;
        if (!this.gateTime.checkFieldContents()) {
            return false;
        }
        if (!this.onThreshold.checkValue(true)) {
            this.onThreshold.requestFocus();
            return false;
        }
        if (!this.offThreshold.checkValue(true)) {
            this.offThreshold.requestFocus();
            return false;
        }
        return super.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        this.gateTime.loadFieldContents();
        this.onThreshold.setProperties(((FrequencyParameter)this.fParameterReference).getOnThreshold());
        this.offThreshold.setProperties(((FrequencyParameter)this.fParameterReference).getOffThreshold());
    }

    public void setLabels() {
        super.setLabels();
        this.borderJPanel1.setTitle(Language.getString("dialog.parameter.frequency.threshold", "Threshold"));
        this.borderJPanel2.setTitle(Language.getString("dialog.parameter.frequency.gateTime", "Time interval"));
        this.lOnThreshold.setText(Language.getString("dialog.parameter.frequency.on", "On"));
        this.lOffThreshold.setText(Language.getString("dialog.parameter.frequency.off", "Off"));
        TimeUnit paramTime = ((FrequencyParameter)this.fParameterReference).getTimeInterval().getParamTime();
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        FrequencyParameter tp = (FrequencyParameter)this.fParameterReference;
        this.gateTime.storeFieldContents();
        tp.setOnThreshold(this.onThreshold.getValue());
        tp.setOffThreshold(this.offThreshold.getValue());
    }
}

