/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.model.panel.CamPanel;
import DE.siemens.ad.logo.model.panel.CamPanelInno2;
import DE.siemens.ad.logo.util.Language;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;

public class ClockPanel
extends AbstractProtectionPanel {
    protected JCheckBox cbPulse;

    public ClockPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.setPanelName(Language.getString("global.general", "General"));
        Hardware hw = ((BlockParameter)this.fParameterReference).getBlock().getWiringDiagram().getHardware();
        boolean oneProtection = hw.supports("clockOneProtection");
        if (!oneProtection) {
            panels.remove(this);
        }
        if (hw.supports("anyDayClock")) {
            for (int i = 0; i < ((ClockParameter)this.fParameterReference).getCamCount(); ++i) {
                CamPanelInno2 camPanel = new CamPanelInno2(panels, ((ClockParameter)this.fParameterReference).getCam(i), simulationMode);
                camPanel.setPanelName(Language.getString("dialog.parameter.cam", "Cam") + " " + (i + 1));
                if (!oneProtection) continue;
                camPanel.setProtectionVisible(false);
            }
            this.cbPulse = new JCheckBox();
            this.globalParamPane.add(this.cbPulse);
            this.cbPulse.setVisible(hw.supports("pulseClock"));
            this.cbPulse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClockPanel.this.setPulseMode(ClockPanel.this.cbPulse.isSelected());
                }
            });
        } else {
            for (int i = 0; i < ((ClockParameter)this.fParameterReference).getCamCount(); ++i) {
                CamPanel camPanel = new CamPanel(panels, ((ClockParameter)this.fParameterReference).getCam(i), simulationMode);
                camPanel.setPanelName(Language.getString("dialog.parameter.cam", "Cam") + " " + (i + 1));
            }
        }
    }

    private void setPulseMode(boolean pulseMode) {
        try {
            for (int i = 0; i < this.getParent().getComponentCount(); ++i) {
                if (!(this.getParent().getComponent(i) instanceof CamPanelInno2)) continue;
                ((CamPanelInno2)this.getParent().getComponent(i)).setPulseMode(pulseMode);
            }
        }
        catch (Exception e) {
            System.err.println("Error in ClockPanel.setPulseMode(boolean)");
        }
    }

    public boolean checkChanged() {
        if (this.cbPulse.isSelected() != ((ClockParameter)this.fParameterReference).getPulse()) {
            return true;
        }
        return super.checkChanged();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        if (this.cbPulse != null) {
            this.cbPulse.setSelected(((ClockParameter)this.fParameterReference).getPulse());
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        if (this.cbPulse != null) {
            ((ClockParameter)this.fParameterReference).setPulse(this.cbPulse.isSelected());
        }
    }

    public void setLabels() {
        super.setLabels();
        if (this.cbPulse != null) {
            this.cbPulse.setText(Language.getString("dialog.parameter.output.pulse", "Pulse Output"));
        }
    }
}

