/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.dialog.comp.TimeInputPanel;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class CamPanel
extends AbstractProtectionPanel {
    BorderJPanel modePanel;
    JComboBox cobMode;
    BorderJPanel onTimeBorderPanel;
    JCheckBox cbOnTimeInactive;
    TimeInputPanel onTime;
    BorderJPanel offTimeBorderPanel;
    JCheckBox cbOffTimeInactive;
    TimeInputPanel offTime;

    public CamPanel(Vector panels, Parameter cam, boolean simulationMode) {
        super(panels, cam, simulationMode);
        JPanel panel = new JPanel(null);
        this.addParameterPane(panel);
        this.modePanel = new BorderJPanel();
        this.modePanel.setLayout(null);
        this.modePanel.setBounds(24, 12, 300, 60);
        panel.add(this.modePanel);
        this.cobMode = new JComboBox();
        this.cobMode.setRequestFocusEnabled(false);
        this.cobMode.setBounds(12, 18, 276, 24);
        this.modePanel.add(this.cobMode);
        this.onTimeBorderPanel = new BorderJPanel();
        this.onTimeBorderPanel.setLayout(null);
        this.onTimeBorderPanel.setBounds(24, 84, 144, 84);
        panel.add(this.onTimeBorderPanel);
        this.cbOnTimeInactive = new JCheckBox();
        this.cbOnTimeInactive.setText(Language.getString("dialog.parameter.cam.inactive", "Inaktiv"));
        this.cbOnTimeInactive.setActionCommand("Inaktiv");
        this.cbOnTimeInactive.setBounds(12, 54, 120, 24);
        this.onTimeBorderPanel.add(this.cbOnTimeInactive);
        this.onTime = new TimeInputPanel();
        this.onTime.setLayout(null);
        this.onTime.setBounds(12, 24, 120, 24);
        this.onTimeBorderPanel.add(this.onTime);
        this.offTimeBorderPanel = new BorderJPanel();
        this.offTimeBorderPanel.setLayout(null);
        this.offTimeBorderPanel.setBounds(180, 84, 144, 84);
        panel.add(this.offTimeBorderPanel);
        this.cbOffTimeInactive = new JCheckBox();
        this.cbOffTimeInactive.setText(Language.getString("dialog.parameter.cam.inactive", "Inaktiv"));
        this.cbOffTimeInactive.setActionCommand("Inaktiv");
        this.cbOffTimeInactive.setBounds(12, 54, 120, 24);
        this.offTimeBorderPanel.add(this.cbOffTimeInactive);
        this.offTime = new TimeInputPanel();
        this.offTime.setLayout(null);
        this.offTime.setBounds(12, 24, 120, 24);
        this.offTimeBorderPanel.add(this.offTime);
        SymItem lSymItem = new SymItem();
        this.cbOnTimeInactive.addItemListener(lSymItem);
        this.cbOffTimeInactive.addItemListener(lSymItem);
    }

    void cbOffTimeInactive_itemStateChanged() {
        this.offTime.setEnabled(!this.cbOffTimeInactive.isSelected());
    }

    void cbOnTimeInactive_itemStateChanged() {
        this.onTime.setEnabled(!this.cbOnTimeInactive.isSelected());
    }

    public boolean checkChanged() {
        CamParameter cp = (CamParameter)this.fParameterReference;
        if (cp.getMode() != this.cobMode.getSelectedIndex()) {
            return true;
        }
        if (cp.getOnTime().isInactive() != this.cbOnTimeInactive.isSelected()) {
            return true;
        }
        if (cp.getOffTime().isInactive() != this.cbOffTimeInactive.isSelected()) {
            return true;
        }
        if (this.onTime.checkChanged(cp.getOnTime())) {
            return true;
        }
        if (this.offTime.checkChanged(cp.getOffTime())) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!this.onTime.checkFieldContents()) {
            return false;
        }
        if (!this.offTime.checkFieldContents()) {
            return false;
        }
        return super.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        CamParameter cp = (CamParameter)this.fParameterReference;
        this.cbOnTimeInactive.setSelected(cp.getOnTime().isInactive());
        this.cbOffTimeInactive.setSelected(cp.getOffTime().isInactive());
        int mode = cp.getMode();
        if (mode == 11) {
            Mode[] modeArr = cp.getAvailableModes();
            int max = modeArr.length - 1;
            int fLogoMode = cp.getLogoMode();
            if (fLogoMode == 0) {
                mode = 6;
            } else {
                for (int i = 0; i < max; ++i) {
                    if (fLogoMode != modeArr[i].getLogoMode()) continue;
                    mode = i;
                    break;
                }
            }
        }
        if (mode == 11) {
            mode = 6;
        }
        this.cobMode.setSelectedIndex(mode);
        this.onTime.loadFieldContents(cp.getOnTime());
        this.offTime.loadFieldContents(cp.getOffTime());
    }

    public void setLabels() {
        super.setLabels();
        CamParameter cp = (CamParameter)this.fParameterReference;
        this.modePanel.setTitle(Language.getString("dialog.parameter.cam.mode", "Mode"));
        this.onTimeBorderPanel.setTitle(Language.getString("dialog.parameter.cam.onTime", "On time"));
        this.offTimeBorderPanel.setTitle(Language.getString("dialog.parameter.cam.offTime", "Off time"));
        this.cbOnTimeInactive.setText(Language.getString("dialog.parameter.cam.inactive", "Inactive"));
        this.cbOffTimeInactive.setText(Language.getString("dialog.parameter.cam.inactive", "Inactive"));
        Mode[] am = cp.getAvailableModes();
        int max = am.length - 1;
        for (int i = 0; i < max; ++i) {
            this.cobMode.addItem(am[i]);
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        CamParameter camParameter = (CamParameter)this.fParameterReference;
        camParameter.getOnTime().setInactive(this.cbOnTimeInactive.isSelected());
        camParameter.getOffTime().setInactive(this.cbOffTimeInactive.isSelected());
        this.onTime.storeFieldContents(camParameter.getOnTime());
        this.offTime.storeFieldContents(camParameter.getOffTime());
        camParameter.setMode(this.cobMode.getSelectedIndex());
    }

    public Dimension getPreferredSize() {
        return new Dimension(340, 280);
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == CamPanel.this.cbOnTimeInactive) {
                CamPanel.this.cbOnTimeInactive_itemStateChanged();
            } else if (object == CamPanel.this.cbOffTimeInactive) {
                CamPanel.this.cbOffTimeInactive_itemStateChanged();
            }
        }
    }
}

