/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.dialog.comp.TimeInputPanel;
import DE.siemens.ad.logo.dialog.comp.TimeUnitListCellRenderer;
import DE.siemens.ad.logo.model.AsymPulseGeneratorParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AsymPulseGeneratorPanelSTB
extends AbstractProtectionPanel {
    BorderJPanel impulseLengthBorderPanel;
    JLabel impulseLengthUnit;
    TimeInputPanel impulseLength;
    BorderJPanel impulsePauseBorderPanel;
    BorderJPanel timeUnitBorderPanel;
    JLabel pauseLengthUnit;
    TimeInputPanel pauseLength;
    JComboBox cobTimeUnit;

    public AsymPulseGeneratorPanelSTB(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        JPanel panel = new JPanel(new GridLayout(0, 1));
        this.addParameterPane(panel);
        this.timeUnitBorderPanel = new BorderJPanel(new FlowLayout(0));
        panel.add(this.timeUnitBorderPanel);
        this.cobTimeUnit = new JComboBox();
        this.cobTimeUnit.setRequestFocusEnabled(false);
        this.cobTimeUnit.setRenderer(new TimeUnitListCellRenderer());
        this.timeUnitBorderPanel.add(this.cobTimeUnit);
        this.impulseLengthBorderPanel = new BorderJPanel(new FlowLayout(0));
        panel.add(this.impulseLengthBorderPanel);
        this.impulseLength = new TimeInputPanel();
        this.impulseLengthBorderPanel.add(this.impulseLength);
        this.impulseLengthUnit = new JLabel();
        this.impulseLengthBorderPanel.add(this.impulseLengthUnit);
        this.impulsePauseBorderPanel = new BorderJPanel(new FlowLayout(0));
        panel.add(this.impulsePauseBorderPanel);
        this.pauseLength = new TimeInputPanel();
        this.impulsePauseBorderPanel.add(this.pauseLength);
        this.pauseLengthUnit = new JLabel();
        this.impulsePauseBorderPanel.add(this.pauseLengthUnit);
        SymItem lSymItem = new SymItem();
        this.cobTimeUnit.addItemListener(lSymItem);
    }

    public boolean checkChanged() {
        AsymPulseGeneratorParameter paramObj = (AsymPulseGeneratorParameter)this.fParameterReference;
        if (!paramObj.getHTimer().getParamTime().getUnitKey().equals(((TimeUnit)this.cobTimeUnit.getSelectedItem()).getUnitKey())) {
            return true;
        }
        if (this.impulseLength.checkChanged(paramObj.getHTimer().getParamTime())) {
            return true;
        }
        if (this.pauseLength.checkChanged(paramObj.getLTimer().getParamTime())) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!this.impulseLength.checkFieldContents()) {
            return false;
        }
        if (!this.pauseLength.checkFieldContents()) {
            return false;
        }
        return super.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        AsymPulseGeneratorParameter apgp = (AsymPulseGeneratorParameter)this.fParameterReference;
        Timer hTimer = apgp.getHTimer();
        TimeUnit[] availableTimeUnits = hTimer.getAvailableTimeUnitObjects();
        DefaultComboBoxModel<TimeUnit> timeUnitModel = new DefaultComboBoxModel<TimeUnit>(availableTimeUnits);
        this.cobTimeUnit.setModel(timeUnitModel);
        String timeUnitKey = hTimer.getParamTime().getUnitKey();
        for (int index = 0; index < availableTimeUnits.length; ++index) {
            if (!availableTimeUnits[index].getUnitKey().equals(timeUnitKey)) continue;
            this.cobTimeUnit.setSelectedIndex(index);
            break;
        }
        String timeUnit = Language.getString(timeUnitKey, hTimer.getParamTime().getDefaultUnitString());
        this.impulseLengthUnit.setText(timeUnit);
        this.pauseLengthUnit.setText(timeUnit);
        this.impulseLength.loadFieldContents(apgp.getHTimer().getParamTime());
        this.pauseLength.loadFieldContents(apgp.getLTimer().getParamTime());
    }

    public void setLabels() {
        super.setLabels();
        this.impulseLengthBorderPanel.setTitle(Language.getString("dialog.parameter.asymPulseGenerator.impulseLength", "Impulse length"));
        this.impulsePauseBorderPanel.setTitle(Language.getString("dialog.parameter.asymPulseGenerator.impulsePause", "Impulse pause"));
        this.timeUnitBorderPanel.setTitle(Language.getString("dialog.parameter.timeUnit", "Time unit"));
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        AsymPulseGeneratorParameter paramObj = (AsymPulseGeneratorParameter)this.fParameterReference;
        String unitKey = ((TimeUnit)this.cobTimeUnit.getSelectedItem()).getUnitKey();
        paramObj.getHTimer().setParamTime(0, 0, unitKey);
        paramObj.getLTimer().setParamTime(0, 0, unitKey);
        this.impulseLength.storeFieldContents(paramObj.getHTimer().getParamTime());
        this.pauseLength.storeFieldContents(paramObj.getLTimer().getParamTime());
    }

    void timeUnit_itemStateChanged() {
        AsymPulseGeneratorParameter paramObj = (AsymPulseGeneratorParameter)this.fParameterReference;
        String timeUnitString = Language.getString(((TimeUnit)this.cobTimeUnit.getSelectedItem()).getUnitKey());
        int i = this.cobTimeUnit.getSelectedIndex();
        if (i < 0) {
            i = 0;
        }
        String unitKey = ((TimeUnit)this.cobTimeUnit.getSelectedItem()).getUnitKey();
        this.impulseLengthUnit.setText(timeUnitString);
        this.pauseLengthUnit.setText(timeUnitString);
        this.impulseLength.changeTimeUnit(unitKey);
        this.pauseLength.changeTimeUnit(unitKey);
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == AsymPulseGeneratorPanelSTB.this.cobTimeUnit) {
                AsymPulseGeneratorPanelSTB.this.timeUnit_itemStateChanged();
            }
        }
    }
}

