/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.lgoExImport.PartsOfLgo;

public class PartsOfProgramm
extends PartsOfLgo {
    public PartsOfProgramm() {
    }

    public PartsOfProgramm(String[] lgoData) {
        super(lgoData);
    }

    public int[] getConnectionToBlock(int index) {
        int[] zeile = this.getProgPart2()[index];
        return zeile;
    }

    public int getLengthOfProg() {
        int pos = this.getProgStartIndex() - 1;
        int anzahl = (this.fLgoInt[pos] - 64) * this.getLengthOfProgLine();
        return anzahl;
    }

    public int getLengthOfProgLine() {
        if (this.fLgoInt[1] == 1) {
            return 6;
        }
        if (this.fHardware.supports("longCounter")) {
            return 6;
        }
        return 5;
    }

    public int getNumberOfProgLines() {
        int anzahl = this.getLengthOfProg() / this.getLengthOfProgLine();
        return anzahl;
    }

    public int[] getOPCodes() {
        int[][] prog2 = this.getProgPart2();
        int[] opCodes = new int[prog2.length];
        for (int i = 0; i < opCodes.length; ++i) {
            opCodes[i] = prog2[i][0];
        }
        return opCodes;
    }

    public int[] getProgPart() {
        int startProg = 0;
        while (this.fLgoInt[startProg] == 0) {
            ++startProg;
        }
        int progLength = this.getLengthOfProg() - startProg;
        int start = this.getProgStartIndex() + startProg;
        int[] progPart = new int[progLength];
        for (int i = 0; i < progLength; ++i) {
            progPart[i] = this.fLgoInt[i + start];
        }
        return progPart;
    }

    public int[][] getProgPart2() {
        int[] prog = this.getProgPart();
        int anzahlReihen = prog.length / this.getLengthOfProgLine();
        int zeilenLaenge = this.getLengthOfProgLine();
        int[][] progArray = new int[anzahlReihen][zeilenLaenge];
        for (int reihe = 0; reihe < anzahlReihen; ++reihe) {
            for (int zeile = 0; zeile < zeilenLaenge; ++zeile) {
                progArray[reihe][zeile] = prog[zeile + reihe * zeilenLaenge];
            }
        }
        return progArray;
    }

    public String toString() {
        int[][] prog = this.getProgPart2();
        String ret = "Programm ";
        for (int i = 0; i < prog.length; ++i) {
            ret = ret + "\n" + i + ": ";
            for (int d = 0; d < prog[0].length; ++d) {
                ret = ret + prog[i][d] + "\t";
            }
        }
        return ret;
    }
}

