/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.lgoExImport.CSpecialFunctions;

public class CClockBlock
extends CSpecialFunctions {
    public CClockBlock() {
    }

    public CClockBlock(ClockBlock uebergabeBlock) {
        super(uebergabeBlock);
    }

    public CClockBlock(Block uebergabeBlock) {
        super(uebergabeBlock);
    }

    public boolean canCreateCBlock(Block block) {
        if (block instanceof ClockBlock) {
            this.fNewBlock = block;
            return true;
        }
        return false;
    }

    public boolean canCreateParameters(Block block) {
        if (block instanceof ClockBlock) {
            this.fNewBlock = block;
            return true;
        }
        return false;
    }

    public int getComfortOPCode(Hardware hw, int blocknummer) {
        return 36;
    }

    private int getModeIndex(int mode) {
        boolean back = false;
        if (mode >= 100) {
            mode -= 100;
        }
        if (mode == 0) {
            return 6;
        }
        if (mode <= 6) {
            return mode - 1;
        }
        if (mode > 6) {
            return mode;
        }
        return 0;
    }

    public int[][] getParameters2() {
        ClockParameter clockPara = null;
        CamParameter cam = null;
        int[][] back = new int[3][this.fParaDataArray.length];
        for (int camCounter = 0; camCounter < 3; ++camCounter) {
            clockPara = (ClockParameter)this.fNewBlock.getParameter();
            cam = clockPara.getCam(camCounter);
            back[camCounter][0] = 0;
            boolean pState = cam.getProtection();
            int modeIndex = cam.getLogoMode();
            back[camCounter][1] = this.getSoftMode(modeIndex, pState);
            if (cam.getOnTime().isInactive()) {
                back[camCounter][2] = 30;
                back[camCounter][3] = 30;
            } else {
                ClockHours timeObjektOn = cam.getOnTime();
                back[camCounter][2] = ((TimeUnit)timeObjektOn).getHighValue();
                back[camCounter][3] = ((TimeUnit)timeObjektOn).getLowValue();
            }
            if (cam.getOffTime().isInactive()) {
                back[camCounter][4] = 30;
                back[camCounter][5] = 30;
                continue;
            }
            ClockHours timeObjektOff = cam.getOffTime();
            back[camCounter][4] = ((TimeUnit)timeObjektOff).getHighValue();
            back[camCounter][5] = ((TimeUnit)timeObjektOff).getLowValue();
        }
        return back;
    }

    private boolean getProtection(int mode) {
        return mode < 100;
    }

    protected int getSoftMode(int comfortModeIndex, boolean pState) {
        int[] softModesAndProtection = new int[]{101, 102, 103, 104, 105, 106, 100, 107, 108, 109, 110};
        int[] softModesWithoutProtection = new int[]{1, 2, 3, 4, 5, 6, 0, 7, 8, 9, 10};
        CamParameter cam = new CamParameter();
        Mode[] availableModes = cam.getAvailableModes();
        for (int index = 0; index < availableModes.length; ++index) {
            if (availableModes[index].getLogoMode() != comfortModeIndex) continue;
            if (!pState) {
                if (index > softModesAndProtection.length - 1) {
                    index = 6;
                }
                return softModesAndProtection[index];
            }
            if (index > softModesWithoutProtection.length - 1) {
                index = 6;
            }
            return softModesWithoutProtection[index];
        }
        return softModesWithoutProtection[6];
    }

    public int getSoftOPCode() {
        return 34;
    }

    public int getUsedParaLine() {
        return 3;
    }

    protected void setLineNumbers() {
        this.fParaZeilen = new int[3];
        this.fParaZeilen[0] = -1;
        this.fParaZeilen[1] = -1;
        this.fParaZeilen[2] = -1;
        if (this.fProgZeile == -1) {
            int pos = this.fExport.getFreeProgNumber();
            this.fProgZeile = this.getBlockNumber() + 64;
        }
        if (this.fParaZeilen[0] == -1) {
            this.fParaZeilen[0] = this.fExport.getFreeParaNumber();
            this.fParaZeilen[1] = this.fExport.getFreeParaNumber();
            this.fParaZeilen[2] = this.fExport.getFreeParaNumber();
        }
    }

    public void setParameters(int startIndex, int[][] parameterArray) {
        ClockParameter clockPara = null;
        CamParameter cam = null;
        for (int camCounter = 0; camCounter < 3; ++camCounter) {
            ClockHours timeObjekt;
            int[] paraZeile = parameterArray[startIndex + camCounter];
            if (paraZeile[0] != 0) continue;
            int mode = paraZeile[1];
            int onHigh = paraZeile[2];
            int onLow = paraZeile[3];
            int offHigh = paraZeile[4];
            int offLow = paraZeile[5];
            clockPara = (ClockParameter)this.fNewBlock.getParameter();
            cam = clockPara.getCam(camCounter);
            cam.setMode(this.getModeIndex(mode));
            if (onHigh == 30) {
                cam.getOnTime().setInactive(true);
            } else {
                cam.getOnTime().setInactive(false);
                timeObjekt = cam.getOnTime();
                ((TimeUnit)timeObjekt).setTime(onHigh, onLow);
            }
            if (offHigh == 30) {
                cam.getOffTime().setInactive(true);
            } else {
                cam.getOffTime().setInactive(false);
                timeObjekt = cam.getOffTime();
                ((TimeUnit)timeObjekt).setTime(offHigh, offLow);
            }
            cam.setProtection(this.getProtection(mode));
        }
    }
}

