/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.hardware;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItemTableLogo5;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogMuxBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AndBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.LatchingRelayBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.NandBlock;
import DE.siemens.ad.logo.model.block.NorBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.OrBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.PecAndBlock;
import DE.siemens.ad.logo.model.block.PecNandBlock;
import DE.siemens.ad.logo.model.block.PulseRelayBlock;
import DE.siemens.ad.logo.model.block.RampControlBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.block.XorBlock;
import DE.siemens.ad.logo.model.block.YearClockBlock;
import DE.siemens.ad.logo.model.hardware.Logo4;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo5;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo5;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo5;
import DE.siemens.ad.logo.util.Util;
import java.util.Dictionary;
import java.util.Hashtable;

public class Logo5
extends Logo4 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;

    public int getOrder() {
        return 1200;
    }

    protected static Dictionary getSystemInfo() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>(20);
        dict.put("knownBlocks", Logo5.getBlockNamesArray());
        TimeUnit[] availableTimeUnits = new TimeUnit[]{new Hours(), new Minutes(), new HighResolutionSeconds()};
        dict.put("availableTimeUnits", availableTimeUnits);
        int[] iArr = new int[]{130, Integer.MAX_VALUE, 60, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 24, 16, 0, 0, 24, 8, 10, 2, 2000, 64, 6, 4, 1, 8, 16};
        dict.put("maxValues", iArr);
        dict.put("blockMemoryTable", new BlockMemoryUsage());
        dict.put("blockActualParameterMemory", new BlockActualMemoryUsage());
        dict.put("blockREMMemoryTable", new BlockREMMemoryUsage());
        dict.put("parameterItemTable", new ParameterItemTableLogo5());
        Logo5.addPropertyItems(dict);
        Logo5.addSupportItems(dict);
        return dict;
    }

    protected static String[][] getBlockNamesArray() {
        String[][] sArr = new String[][]{{"Constant", "Input", "KeyInput", "Output", "Marker", "AnalogMarker", "High", "Low", "AnalogInput", "AnalogOutput", "ShiftRegisterInput", "VirtualOutput"}, {"Base", "And", "Or", "Not", "Xor", "Nand", "Nor", "PecAnd", "PecNand"}, {"Special", "OnDelay", "OffDelay", "PulseRelay", "Clock", "LatchingRelay", "RetentiveOnDelay", "Counter", "HoursCounter", "WipingRelay", "Trigger", "AsymPulseGenerator", "YearClock", "OnOffDelay", "Random", "StairsSwitch", "ComfortSwitch", "WipingRelayPEC", "Message", "AnalogTrigger", "AnalogComparator", "Amplifier", "AnalogWatchdog", "AnalogDeltaTrigger", "ShiftRegister", "Softkey", "PID", "AnalogMux", "RampControl"}};
        return sArr;
    }

    protected static void addPropertyItems(Hashtable dict) {
        Logo4.addPropertyItems(dict);
    }

    protected static void addSupportItems(Hashtable dict) {
        Logo4.addSupportItems(dict);
        dict.remove("0BA4AnalogCalculation");
        dict.put("0BA5AnalogCalculation", Boolean.TRUE);
        dict.put("startScreen", Boolean.TRUE);
        dict.put("aqStop", Boolean.TRUE);
    }

    protected int getOpcodeSF(String name) throws IllegalArgumentException {
        if (name.equals("AnalogMux")) {
            return 64;
        }
        if (name.equals("RampControl")) {
            return 65;
        }
        if (name.equals("PID")) {
            return 67;
        }
        return super.getOpcodeSF(name);
    }

    public int getID() {
        return 66;
    }

    public int getFirmwareID() {
        return 352;
    }

    public int getNumberOfTransferBytes() {
        return 3733;
    }

    protected int getActualDataOffset(int opcode) {
        switch (opcode) {
            case 128: {
                return 20;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 12;
            }
            case 33: {
                return 6;
            }
            case 34: {
                return 8;
            }
            case 35: {
                return 9;
            }
            case 36: {
                return 17;
            }
            case 37: {
                return 6;
            }
            case 39: {
                return 8;
            }
            case 41: {
                return 15;
            }
            case 42: {
                return 6;
            }
            case 43: {
                return 16;
            }
            case 44: {
                return 10;
            }
            case 45: {
                return 10;
            }
            case 46: {
                return 8;
            }
            case 47: {
                return 8;
            }
            case 48: {
                return 8;
            }
            case 49: {
                return 10;
            }
            case 50: {
                return 14;
            }
            case 51: {
                return 12;
            }
            case 52: {
                return 8;
            }
            case 53: {
                return 13;
            }
            case 54: {
                return 15;
            }
            case 55: {
                return 6;
            }
            case 56: {
                return 9;
            }
            case 57: {
                return 13;
            }
            case 58: {
                return 13;
            }
            case 64: {
                return 18;
            }
            case 65: {
                return 24;
            }
            case 66: {
                return 10;
            }
            case 67: {
                return 27;
            }
        }
        throw new IllegalArgumentException("getActualDataOffset- Unbekannter Opcode: " + opcode);
    }

    public CompilerFromHardware getCompilerFromHardware() {
        return new CompilerFromLogo5();
    }

    protected int getChecksum() {
        return super.getChecksum();
    }

    public CompilerToHardware getCompilerToHardware() {
        return new CompilerToLogo5();
    }

    public LinkerToLogo getLinkerToHardware() {
        return new LinkerToLogo5(this);
    }

    public void downloadAnalogOutputTable(DataTransfer dt) throws TransmissionFailedException {
        int[] data = new int[5];
        DrawingProperties drawingProp = this.fDownloadedWiringDiagram.getDrawingProperties();
        data[0] = drawingProp.getAnalogOutputLastValueStatus() ? 1 : 0;
        int value = (int)Math.round(drawingProp.getAnalogOutputFixedValue1() * 100.0);
        data[1] = Util.getLowByte(value);
        data[2] = Util.getHighByte(value);
        value = (int)Math.round(drawingProp.getAnalogOutputFixedValue2() * 100.0);
        data[3] = Util.getLowByte(value);
        data[4] = Util.getHighByte(value);
        dt.writeByteArray(1363, data);
    }

    public int[] uploadAnalogOutputTable(DataTransfer dt) throws TransmissionFailedException {
        int[] data = dt.readByteArray(1363, 5);
        return data;
    }

    public void downloadStartScreen(DataTransfer dt) throws TransmissionFailedException {
        DrawingProperties drawingProp = this.fDownloadedWiringDiagram.getDrawingProperties();
        dt.writeByte(1362, drawingProp.isStartScreenIO() ? 1 : 255);
    }

    public boolean uploadStarScreen(DataTransfer dt) throws TransmissionFailedException {
        return dt.readByte(1362) == 1;
    }

    static {
        cSystemInfoDict.put("Logo5", Logo5.getSystemInfo());
    }

    private static class BlockREMMemoryUsage
    extends MemoryUsageTable {
        private BlockREMMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 3);
            this.put(OffDelayBlock.class, 3);
            this.put(PulseRelayBlock.class, 1);
            this.put(LatchingRelayBlock.class, 1);
            this.put(RetentiveOnDelayBlock.class, 3);
            this.put(HoursCounterBlock.class, 9);
            this.put(WipingRelayBlock.class, 3);
            this.put(CounterBlock.class, 5);
            this.put(AsymPulseGeneratorBlock.class, 3);
            this.put(OnOffDelayBlock.class, 3);
            this.put(StairsSwitchBlock.class, 3);
            this.put(ComfortSwitchBlock.class, 3);
            this.put(WipingRelayPECBlock.class, 4);
            this.put(SoftkeyBlock.class, 2);
            this.put(ShiftRegisterBlock.class, 1);
            this.put(PIDBlock.class, 2);
        }
    }

    private static class BlockActualMemoryUsage
    extends MemoryUsageTable {
        private BlockActualMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 4);
            this.put(OffDelayBlock.class, 6);
            this.put(PulseRelayBlock.class, 5);
            this.put(ClockBlock.class, 5);
            this.put(LatchingRelayBlock.class, 4);
            this.put(RetentiveOnDelayBlock.class, 6);
            this.put(HoursCounterBlock.class, 11);
            this.put(WipingRelayBlock.class, 4);
            this.put(CounterBlock.class, 10);
            this.put(TriggerBlock.class, 8);
            this.put(AsymPulseGeneratorBlock.class, 4);
            this.put(YearClockBlock.class, 2);
            this.put(OnOffDelayBlock.class, 6);
            this.put(RandomBlock.class, 6);
            this.put(StairsSwitchBlock.class, 4);
            this.put(ComfortSwitchBlock.class, 4);
            this.put(WipingRelayPECBlock.class, 6);
            this.put(MessageBlock.class, 2);
            this.put(AnalogTriggerBlock.class, 5);
            this.put(AnalogComparatorBlock.class, 11);
            this.put(SoftkeyBlock.class, 4);
            this.put(ShiftRegisterBlock.class, 2);
            this.put(AmplifierBlock.class, 4);
            this.put(AnalogWatchdogBlock.class, 9);
            this.put(AnalogDeltaTriggerBlock.class, 5);
            this.put(AnalogMuxBlock.class, 4);
            this.put(RampControlBlock.class, 14);
            this.put(PIDBlock.class, 15);
        }
    }

    private static class BlockMemoryUsage
    extends MemoryUsageTable {
        private BlockMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(AndBlock.class, 12);
            this.put(OrBlock.class, 12);
            this.put(NotBlock.class, 4);
            this.put(NandBlock.class, 12);
            this.put(NorBlock.class, 12);
            this.put(XorBlock.class, 8);
            this.put(PecAndBlock.class, 12);
            this.put(PecNandBlock.class, 12);
            this.put(OnDelayBlock.class, 8);
            this.put(OffDelayBlock.class, 12);
            this.put(PulseRelayBlock.class, 12);
            this.put(ClockBlock.class, 20);
            this.put(LatchingRelayBlock.class, 8);
            this.put(RetentiveOnDelayBlock.class, 12);
            this.put(HoursCounterBlock.class, 24);
            this.put(WipingRelayBlock.class, 8);
            this.put(CounterBlock.class, 24);
            this.put(TriggerBlock.class, 16);
            this.put(AsymPulseGeneratorBlock.class, 12);
            this.put(YearClockBlock.class, 8);
            this.put(OnOffDelayBlock.class, 12);
            this.put(RandomBlock.class, 12);
            this.put(StairsSwitchBlock.class, 12);
            this.put(ComfortSwitchBlock.class, 16);
            this.put(WipingRelayPECBlock.class, 16);
            this.put(MessageBlock.class, 8);
            this.put(AnalogTriggerBlock.class, 16);
            this.put(AnalogComparatorBlock.class, 24);
            this.put(SoftkeyBlock.class, 8);
            this.put(ShiftRegisterBlock.class, 12);
            this.put(AmplifierBlock.class, 12);
            this.put(AnalogWatchdogBlock.class, 20);
            this.put(AnalogDeltaTriggerBlock.class, 16);
            this.put(AnalogMuxBlock.class, 20);
            this.put(RampControlBlock.class, 36);
            this.put(PIDBlock.class, 40);
        }
    }
}

