/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HardwareChangedListener;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.PulseRelayParameter;
import DE.siemens.ad.logo.model.RamRemSpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class PulseRelayBlock
extends RamRemSpecialBlock
implements HardwareChangedListener {
    static final long serialVersionUID = -5172386603626412794L;
    private int pulseRelaylockSerializedDataVersion = 2;
    protected PulseRelayParameter fParameter;
    protected InBlockConnector[][] fInConnectorsSet;

    public PulseRelayBlock() {
    }

    public PulseRelayBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected boolean calculateBinaryValue() {
        boolean inputTrigger = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
        boolean inputSet = false;
        boolean inputReset = false;
        if (this.fInConnectors.length > 3) {
            inputSet = ((BinaryInBlockConnector)this.fInConnectors[1]).calculateBinaryValue();
            inputReset = ((BinaryInBlockConnector)this.fInConnectors[2]).calculateBinaryValue();
        } else {
            inputReset = ((BinaryInBlockConnector)this.fInConnectors[1]).calculateBinaryValue();
        }
        return this.fParameter.getValue(inputTrigger, inputSet, inputReset);
    }

    protected int getDefaultOrder() {
        return 600;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = super.getMemoryResources(hardware);
        BlockParameter param = this.getParameter();
        if (param == null) {
            result[1] = 1;
        }
        return result;
    }

    public final int getOpcode() {
        return 35;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        String oldIconName = this.getIconName();
        this.setHardware(newHardware);
        String newIconName = this.getIconName();
        if (!oldIconName.equals(newIconName)) {
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "icon", "IconName", oldIconName, newIconName));
        }
        this.fToolTipText = null;
        int connectorCount = this.getInConnectorCount();
        this.setCorrectInConnectors();
        if (connectorCount != this.getInConnectorCount()) {
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "inConnector"));
        }
        this.fParameter.hardwareChanged(hardwareChangedEvent);
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        this.fParameter.init(interpreter, forceReset);
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (this.isSetInputNeeded() && !hw.supports("pulseRelayWithSetInput")) {
            result &= false;
            errorList.add(new ErrorInfo(this, "error.convert.pulseRelaySet", hw));
        }
        return result;
    }

    public boolean isSetInputNeeded() {
        if (!(this.getInConnectorCount() > 3)) {
            return false;
        }
        InBlockConnector setConnector = this.getInConnector(1);
        if (setConnector.getLinkedConnectorCount() > 0) {
            return true;
        }
        return setConnector.isNegated();
    }

    protected void initInConnectors() {
        BinaryInBlockConnector triggerConnector = new BinaryInBlockConnector(this, false, "Trg");
        BinaryInBlockConnector setConnector = new BinaryInBlockConnector(this, false, "S");
        BinaryInBlockConnector resetConnector = new BinaryInBlockConnector(this, false, "R");
        ParameterInBlockConnector parameterConnector = new ParameterInBlockConnector((Block)this, "DE.siemens.ad.logo.model.PulseRelayParameter", "Par");
        this.fParameter = (PulseRelayParameter)parameterConnector.getLinkedParameter();
        this.fParameter.setRemanenceAvailable(true);
        this.setInConnectorSet(triggerConnector, setConnector, resetConnector, parameterConnector);
        this.setCorrectInConnectors();
    }

    protected void setInConnectorSet(InBlockConnector triggerConnector, InBlockConnector setConnector, InBlockConnector resetConnector, ParameterInBlockConnector parameterConnector) {
        this.fInConnectorsSet = new InBlockConnector[3][];
        this.fInConnectorsSet[0] = new InBlockConnector[2];
        this.fInConnectorsSet[0][0] = triggerConnector;
        this.fInConnectorsSet[0][1] = resetConnector;
        this.fInConnectorsSet[1] = new InBlockConnector[3];
        this.fInConnectorsSet[1][0] = triggerConnector;
        this.fInConnectorsSet[1][1] = resetConnector;
        this.fInConnectorsSet[1][2] = parameterConnector;
        this.fInConnectorsSet[2] = new InBlockConnector[4];
        this.fInConnectorsSet[2][0] = triggerConnector;
        this.fInConnectorsSet[2][1] = setConnector;
        this.fInConnectorsSet[2][2] = resetConnector;
        this.fInConnectorsSet[2][3] = parameterConnector;
    }

    public void read(StorableInput dr) throws IOException {
        int i;
        super.read(dr);
        this.fParameter = (PulseRelayParameter)dr.readStorable();
        int count = dr.readInt();
        if (count > 0) {
            this.fInConnectors = new InBlockConnector[count];
            for (i = 0; i < count; ++i) {
                this.fInConnectors[i] = (InBlockConnector)dr.readStorable();
            }
        }
        for (i = 0; i < this.fInConnectorsSet.length; ++i) {
            for (int j = 0; j < this.fInConnectorsSet[i].length; ++j) {
                this.fInConnectorsSet[i][j] = (InBlockConnector)dr.readStorable();
            }
        }
    }

    protected void setCorrectInConnectors() {
        boolean supportREM = false;
        boolean supportSetConnector = true;
        if (this.fWiringDiagram != null) {
            Hardware hw = this.fWiringDiagram.getHardware();
            supportREM = hw.getMaxResource(2) > 0;
            supportSetConnector = hw.supports("pulseRelayWithSetInput");
        }
        if (supportSetConnector) {
            this.fInConnectors = this.fInConnectorsSet[2];
            this.fParameter.setRemanenceAvailable(true);
        } else if (supportREM) {
            this.fInConnectors = this.fInConnectorsSet[1];
            this.fParameter.setRemanenceAvailable(true);
        } else {
            this.fInConnectors = this.fInConnectorsSet[0];
            this.fParameter.setRemanenceAvailable(false);
        }
    }

    public void write(StorableOutput dw) {
        int i;
        super.write(dw);
        dw.writeStorable(this.fParameter);
        if (this.fInConnectors != null) {
            dw.writeInt(this.fInConnectors.length);
            for (i = 0; i < this.fInConnectors.length; ++i) {
                dw.writeStorable(this.fInConnectors[i]);
            }
        } else {
            dw.writeInt(0);
        }
        for (i = 0; i < this.fInConnectorsSet.length; ++i) {
            for (int j = 0; j < this.fInConnectorsSet[i].length; ++j) {
                dw.writeStorable(this.fInConnectorsSet[i][j]);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.pulseRelaylockSerializedDataVersion == 1) {
            ParameterInBlockConnector parameterConnector;
            this.pulseRelaylockSerializedDataVersion = 2;
            InBlockConnector triggerConnector = this.getInConnector(0);
            InBlockConnector resetConnector = this.getInConnector(1);
            BinaryInBlockConnector setConnector = new BinaryInBlockConnector(this, false, "S");
            if (this.getInConnectorCount() > 2) {
                parameterConnector = (ParameterInBlockConnector)this.getInConnector(2);
            } else {
                parameterConnector = new ParameterInBlockConnector((Block)this, "DE.siemens.ad.logo.model.PulseRelayParameter", "Par");
                this.fParameter = (PulseRelayParameter)parameterConnector.getLinkedParameter();
                this.fParameter.setRemanenceAvailable(true);
            }
            this.setInConnectorSet(triggerConnector, setConnector, resetConnector, parameterConnector);
        }
    }

    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        boolean equal = super.compareTo(otherBlock, differences);
        if (this.fParameter != null) {
            equal = equal && this.fParameter.compareTo(otherBlock.getParameter(), differences);
        }
        return equal;
    }

    public String getIconName() {
        Hardware hardware = this.getHardware();
        if (hardware != null && hardware.supports("pulseRelayWithSetInput")) {
            return "PulseLatchingRelayIcon.gif";
        }
        return super.getIconName();
    }
}

