/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import java.util.List;

public class PIDBlock
extends SpecialBlock
implements AnalogBlock {
    static final long serialVersionUID = 0L;
    private int serializedDataVersion = 1;
    private transient int fCurAQ;
    private transient int fCurPV;
    private transient boolean fObserved = false;

    public PIDBlock() {
    }

    public PIDBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[4];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "A/M");
        this.fInConnectors[1] = new BinaryInBlockConnector(this, false, "R");
        this.fInConnectors[2] = new AnalogInBlockConnector(this, 0.0, "PV");
        String name = "DE.siemens.ad.logo.model.PIDParameter";
        this.fInConnectors[3] = new ParameterInBlockConnector((Block)this, name, "Par");
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new AnalogOutBlockConnector(this);
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
        this.getParameter().addParameterSetListener(listener);
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
        this.getParameter().removeAllParameterSetListeners();
    }

    public void collectSensors(List sensorContainer) {
        Analog analogParameter = (Analog)this.getParameter();
        sensorContainer.add(analogParameter.getMeasurement().getSensor());
    }

    public double getAnalogValue() {
        return this.calculateAnalogValue();
    }

    protected double calculateAnalogValue() {
        boolean input1 = ((BinaryInBlockConnector)this.getInConnector(0)).calculateBinaryValue();
        boolean input2 = ((BinaryInBlockConnector)this.getInConnector(1)).calculateBinaryValue();
        double input3 = ((AnalogInBlockConnector)this.getInConnector(2)).calculateAnalogValue();
        return ((PIDParameter)this.getParameter()).calculateAnalogValue(input1, input2, input3);
    }

    public void setOnlineTestAQ(int newValue) {
        this.fCurAQ = newValue;
    }

    public void setOnlineTestPV(int newValue) {
        this.fCurPV = newValue;
    }

    public void setOnlineTestObserved(boolean observed) {
        this.fObserved = observed;
    }

    public boolean isOnlineTestObserved() {
        return this.fObserved;
    }

    public int getTrendviewAQ(boolean isOnlineTest) {
        if (isOnlineTest) {
            return this.fCurAQ;
        }
        return ((PIDParameter)this.getParameter()).getAmplifiedAQ().getCurrentValue();
    }

    public int getTrendviewPV(boolean isOnlineTest) {
        if (isOnlineTest) {
            return this.fCurPV;
        }
        return ((PIDParameter)this.getParameter()).getAmplifiedXProperties().getCurrentValue();
    }
}

